/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.silverpeas.core.admin.domain.DomainServiceProvider;
import org.silverpeas.core.admin.domain.quota.UserDomainQuotaKey;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.quota.exception.QuotaRuntimeException;
import org.silverpeas.core.admin.quota.model.Quota;
import org.silverpeas.core.security.authentication.AuthDomain;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class Domain
implements AuthDomain,
Serializable {
    private static final long serialVersionUID = 7451639218436788229L;
    public static final String MIXED_DOMAIN_ID = "-1";
    private String id;
    private String name;
    private String description;
    private String driverClassName;
    private String propFileName;
    private String authenticationServer;
    private String silverpeasServerURL = "";
    private Quota userDomainQuota;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String className) {
        this.driverClassName = className;
    }

    public String getPropFileName() {
        return this.propFileName;
    }

    public void setPropFileName(String propFileName) {
        this.propFileName = propFileName;
    }

    public String getAuthenticationServer() {
        return this.authenticationServer;
    }

    public void setAuthenticationServer(String authenticationServer) {
        this.authenticationServer = authenticationServer;
    }

    public String getSilverpeasServerURL() {
        return this.silverpeasServerURL;
    }

    public void setSilverpeasServerURL(String silverpeasServerURL) {
        this.silverpeasServerURL = silverpeasServerURL;
    }

    private void loadUserDomainQuota() {
        try {
            this.userDomainQuota = DomainServiceProvider.getUserDomainQuotaService().get(UserDomainQuotaKey.from(this));
        }
        catch (QuotaException qe) {
            throw new QuotaRuntimeException("Cannot get quota for user domain", (Throwable)((Object)qe));
        }
    }

    public Quota getUserDomainQuota() {
        if (this.userDomainQuota == null) {
            this.loadUserDomainQuota();
        }
        return this.userDomainQuota;
    }

    public void setUserDomainQuotaMaxCount(String userDomainQuotaMaxCount) throws QuotaException {
        this.loadUserDomainQuota();
        this.userDomainQuota.setMaxCount(userDomainQuotaMaxCount);
        this.userDomainQuota.validateBounds();
    }

    public boolean isQuotaReached() {
        this.loadUserDomainQuota();
        return this.userDomainQuota.isReached();
    }

    public boolean isMixedOne() {
        return MIXED_DOMAIN_ID.equals(this.getId());
    }

    public List<String> getLooks() {
        String param = this.getSettings().getString("domain.looks", "");
        return Arrays.asList(StringUtil.split((String)param, (char)','));
    }

    public SettingBundle getSettings() {
        return ResourceLocator.getSettingBundle((String)this.getPropFileName());
    }

    public boolean getProperty(String name, boolean defaultValue) {
        return this.getSettings().getBoolean(name, defaultValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Domain{id=");
        sb.append(this.id);
        sb.append(", name=");
        sb.append(this.name);
        sb.append(", description=");
        sb.append(this.description);
        sb.append(", driverClassName=");
        sb.append(this.driverClassName);
        sb.append(", propFileName=");
        sb.append(this.propFileName);
        sb.append(", authenticationServer=");
        sb.append(this.authenticationServer);
        sb.append(", silverpeasServerURL=");
        sb.append(this.silverpeasServerURL);
        if (this.userDomainQuota != null) {
            sb.append(", usersInDomainQuotaMaxCount=");
            sb.append(this.userDomainQuota.getMaxCount());
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Domain)) {
            return false;
        }
        Domain domain = (Domain)o;
        return Objects.equals(this.id, domain.id) && Objects.equals(this.name, domain.name) && Objects.equals(this.description, domain.description) && Objects.equals(this.driverClassName, domain.driverClassName) && Objects.equals(this.propFileName, domain.propFileName) && Objects.equals(this.authenticationServer, domain.authenticationServer) && Objects.equals(this.silverpeasServerURL, domain.silverpeasServerURL) && Objects.equals(this.userDomainQuota, domain.userDomainQuota);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.driverClassName, this.propFileName, this.authenticationServer, this.silverpeasServerURL, this.userDomainQuota);
    }
}

