/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.sqldriver;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.Transactional;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.domain.AbstractDomainDriver;
import org.silverpeas.core.admin.domain.DomainServiceProvider;
import org.silverpeas.core.admin.domain.driver.sqldriver.SQLGroupTable;
import org.silverpeas.core.admin.domain.driver.sqldriver.SQLGroupUserRelTable;
import org.silverpeas.core.admin.domain.driver.sqldriver.SQLSettings;
import org.silverpeas.core.admin.domain.driver.sqldriver.SQLUserTable;
import org.silverpeas.core.admin.domain.model.DomainProperty;
import org.silverpeas.core.admin.domain.quota.UserDomainQuotaKey;
import org.silverpeas.core.admin.quota.exception.QuotaException;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.security.authentication.password.PasswordEncryption;
import org.silverpeas.core.security.authentication.password.PasswordEncryptionProvider;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class SQLDriver
extends AbstractDomainDriver {
    public static final String GROUP = "group";
    private DataSource dataSource;
    protected SQLSettings drvSettings = new SQLSettings();
    protected SQLUserTable localUserMgr = new SQLUserTable(this.drvSettings);
    protected SQLGroupTable localGroupMgr = new SQLGroupTable(this.drvSettings);
    protected SQLGroupUserRelTable localGroupUserRelMgr = new SQLGroupUserRelTable(this.drvSettings);

    protected SQLDriver() {
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public String[] getGroupMemberGroupIds(String groupId) throws AdminException {
        GroupDetail group = this.getGroup(groupId);
        if (group != null && group.getSuperGroupId() != null) {
            return new String[]{group.getSuperGroupId()};
        }
        return ArrayUtil.emptyStringArray();
    }

    @Override
    public void initFromProperties(SettingBundle rs) throws AdminException {
        this.drvSettings.initFromProperties(rs);
        try {
            this.dataSource = (DataSource)InitialContext.doLookup(this.drvSettings.getDataSourceJNDIName());
        }
        catch (NamingException e) {
            throw new AdminException(e.getMessage(), e);
        }
    }

    @Override
    public UserDetail importUser(String userLogin) throws AdminException {
        return null;
    }

    @Override
    public void removeUser(String userId) throws AdminException {
    }

    @Override
    public UserDetail synchroUser(String userId) throws AdminException {
        return null;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public String createUser(UserDetail ud) throws AdminException {
        String string;
        block9: {
            Connection connection = this.dataSource.getConnection();
            try {
                DomainServiceProvider.getUserDomainQuotaService().verify(UserDomainQuotaKey.from(ud));
                int userId = this.localUserMgr.createUser(connection, ud);
                this.localUserMgr.updateUserPassword(connection, userId, "");
                this.localUserMgr.updateUserPasswordValid(connection, userId, false);
                string = SQLDriver.idAsString(userId);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (QuotaException qe) {
                    throw new AdminException(qe.getMessage(), (Throwable)((Object)qe));
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)"user", (Object)ud.getDisplayedName()), e);
                }
            }
            connection.close();
        }
        return string;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void resetPassword(UserDetail user, String password) throws AdminException {
        PasswordEncryption encryption = PasswordEncryptionProvider.getDefaultPasswordEncryption();
        String encryptedPassword = encryption.encrypt(password);
        this.effectiveResetPassword(user, encryptedPassword);
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void resetEncryptedPassword(UserDetail user, String encryptedPassword) throws AdminException {
        this.effectiveResetPassword(user, encryptedPassword);
    }

    private void effectiveResetPassword(UserDetail user, String password) throws AdminException {
        try (Connection connection = this.dataSource.getConnection();){
            this.localUserMgr.updateUserPassword(connection, SQLDriver.idAsInt(user.getSpecificId()), password);
            this.localUserMgr.updateUserPasswordValid(connection, SQLDriver.idAsInt(user.getSpecificId()), true);
        }
        catch (Exception e) {
            throw new AdminException("Fail to effectively reset password for user " + user.getSpecificId(), e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void deleteUser(String userId) throws AdminException {
        try (Connection connection = this.dataSource.getConnection();){
            this.localGroupUserRelMgr.removeAllUserRel(connection, SQLDriver.idAsInt(userId));
            this.localUserMgr.deleteUser(connection, SQLDriver.idAsInt(userId));
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)"user", (Object)userId), e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void updateUserFull(UserFull uf) throws AdminException {
        try (Connection connection = this.dataSource.getConnection();){
            String[] specificProps;
            this.localUserMgr.updateUser(connection, uf);
            int userId = SQLDriver.idAsInt(uf.getSpecificId());
            for (String specificProp : specificProps = this.getPropertiesNames()) {
                DomainProperty theProp = this.getProperty(specificProp);
                this.localUserMgr.updateUserSpecificProperty(connection, userId, theProp, uf.getValue(theProp.getName()));
            }
            if (this.drvSettings.isUserPasswordAvailable()) {
                String existingPassword;
                if (StringUtil.isDefined((String)uf.getPassword()) && !(existingPassword = this.localUserMgr.getUserPassword(connection, userId)).equals(uf.getPassword())) {
                    PasswordEncryption encryption = PasswordEncryptionProvider.getDefaultPasswordEncryption();
                    String encryptedPassword = encryption.encrypt(uf.getPassword());
                    this.localUserMgr.updateUserPassword(connection, userId, encryptedPassword);
                }
                this.localUserMgr.updateUserPasswordValid(connection, userId, uf.isPasswordValid());
            }
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)"user", (Object)uf.getSpecificId()), e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void updateUserDetail(UserDetail ud) throws AdminException {
        try (Connection connection = this.dataSource.getConnection();){
            this.localUserMgr.updateUser(connection, ud);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)"user", (Object)ud.getSpecificId()), e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public UserDetail getUser(String specificId) throws AdminException {
        return (UserDetail)JdbcSqlQuery.unique(this.listUsers(Collections.singleton(specificId)));
    }

    @Override
    public List<UserDetail> listUsers(Collection<String> specificIds) throws AdminException {
        List<UserDetail> list;
        block8: {
            Connection connection = this.dataSource.getConnection();
            try {
                list = this.localUserMgr.getUsers(connection, specificIds.stream().map(AbstractDomainDriver::idAsInt).collect(Collectors.toList()));
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"user", specificIds), e);
                }
            }
            connection.close();
        }
        return list;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public UserFull getUserFull(String id) throws AdminException {
        return (UserFull)JdbcSqlQuery.unique(this.listUserFulls(Collections.singleton(id)));
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public List<UserFull> listUserFulls(Collection<String> ids) throws AdminException {
        ArrayList<UserFull> arrayList;
        block11: {
            Connection connection = this.dataSource.getConnection();
            try {
                List<UserDetail> users = this.localUserMgr.getUsers(connection, ids.stream().map(AbstractDomainDriver::idAsInt).collect(Collectors.toList()));
                ArrayList<UserFull> result = new ArrayList<UserFull>(users.size());
                for (UserDetail ud : users) {
                    String[] specificProps;
                    int userId = SQLDriver.idAsInt(ud.getSpecificId());
                    UserFull uf = new UserFull(this, ud);
                    if (this.drvSettings.isUserPasswordAvailable()) {
                        uf.setPasswordAvailable(true);
                        uf.setPassword(this.localUserMgr.getUserPassword(connection, userId));
                        uf.setPasswordValid(this.localUserMgr.getUserPasswordValid(connection, userId));
                    }
                    for (String specificProp : specificProps = this.getPropertiesNames()) {
                        DomainProperty theProp = this.getProperty(specificProp);
                        String value = this.localUserMgr.getUserSpecificProperty(connection, userId, theProp);
                        uf.setValue(theProp.getName(), value);
                    }
                    result.add(uf);
                }
                arrayList = result;
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"users", ids), e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    @Override
    public String[] getUserMemberGroupIds(String specificId) throws AdminException {
        return new String[0];
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public UserDetail[] getAllUsers() throws AdminException {
        UserDetail[] userDetailArray;
        block8: {
            Connection connection = this.dataSource.getConnection();
            try {
                List<UserDetail> users = this.localUserMgr.getAllUsers(connection);
                userDetailArray = users.toArray(new UserDetail[0]);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all users", (Object)""), e);
                }
            }
            connection.close();
        }
        return userDetailArray;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public UserDetail[] getUsersBySpecificProperty(String propertyName, String propertyValue) throws AdminException {
        UserDetail[] userDetailArray;
        block9: {
            DomainProperty property = this.getProperty(propertyName);
            if (property == null) {
                return new UserDetail[0];
            }
            Connection connection = this.dataSource.getConnection();
            try {
                List<UserDetail> users = this.localUserMgr.getUsersBySpecificProperty(connection, property.getMapParameter(), propertyValue);
                userDetailArray = users.toArray(new UserDetail[0]);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all users by property", (Object)propertyName), e);
                }
            }
            connection.close();
        }
        return userDetailArray;
    }

    @Override
    public UserDetail[] getUsersByQuery(Map<String, String> query) throws AdminException {
        return new UserDetail[0];
    }

    @Override
    public GroupDetail importGroup(String groupName) throws AdminException {
        return null;
    }

    @Override
    public void removeGroup(String groupId) throws AdminException {
    }

    @Override
    public GroupDetail synchroGroup(String groupId) throws AdminException {
        return null;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public String createGroup(GroupDetail group) throws AdminException {
        String string;
        block9: {
            Connection connection = this.dataSource.getConnection();
            try {
                String[] asUserIds;
                int theGrpId = this.localGroupMgr.createGroup(connection, group);
                String theGrpIdStr = Integer.toString(theGrpId);
                for (String asUserId : asUserIds = group.getUserIds()) {
                    if (!StringUtil.isDefined((String)asUserId)) continue;
                    this.addUserInGroup(asUserId, theGrpIdStr);
                }
                string = theGrpIdStr;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)GROUP, (Object)group.getName()), e);
                }
            }
            connection.close();
        }
        return string;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void deleteGroup(String groupId) throws AdminException {
        try (Connection connection = this.dataSource.getConnection();){
            ArrayList<GroupDetail> allSubGroups = new ArrayList<GroupDetail>();
            allSubGroups.add(this.localGroupMgr.getGroup(connection, SQLDriver.idAsInt(groupId)));
            while (!allSubGroups.isEmpty()) {
                int gid = SQLDriver.idAsInt(((GroupDetail)allSubGroups.remove(0)).getSpecificId());
                allSubGroups.addAll(this.localGroupMgr.getDirectSubGroups(connection, gid));
                this.localGroupUserRelMgr.removeAllGroupRel(connection, gid);
                this.localGroupMgr.deleteGroup(connection, gid);
            }
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)GROUP, (Object)groupId), e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void updateGroup(GroupDetail group) throws AdminException {
        ArrayList<String> alAddUsers = new ArrayList<String>();
        if (group == null || group.getName().isEmpty() || group.getSpecificId().isEmpty()) {
            throw new AdminException(SilverpeasExceptionMessages.undefined((String)GROUP), new String[0]);
        }
        try (Connection connection = this.dataSource.getConnection();){
            int groupId = SQLDriver.idAsInt(group.getSpecificId());
            this.localGroupMgr.updateGroup(connection, group);
            List<String> asOldUsersId = this.localGroupUserRelMgr.getDirectUserIdsOfGroup(connection, groupId);
            String[] asNewUsersId = group.getUserIds();
            for (String anAsNewUsersId : asNewUsersId) {
                if (asOldUsersId.remove(anAsNewUsersId)) continue;
                alAddUsers.add(anAsNewUsersId);
            }
            for (String anAsOldUsersId : asOldUsersId) {
                this.localGroupUserRelMgr.removeGroupUserRel(connection, groupId, SQLDriver.idAsInt(anAsOldUsersId));
            }
            for (String alAddUser : alAddUsers) {
                this.localGroupUserRelMgr.createGroupUserRel(connection, groupId, SQLDriver.idAsInt(alAddUser));
            }
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)GROUP, (Object)group.getSpecificId()), e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail getGroup(String specificId) throws AdminException {
        GroupDetail groupDetail;
        block9: {
            Connection connection = this.dataSource.getConnection();
            try {
                GroupDetail group = this.localGroupMgr.getGroup(connection, SQLDriver.idAsInt(specificId));
                if (group != null) {
                    List<String> asUsersId = this.localGroupUserRelMgr.getDirectUserIdsOfGroup(connection, SQLDriver.idAsInt(specificId));
                    group.setUserIds(asUsersId.toArray(new String[0]));
                }
                groupDetail = group;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)GROUP, (Object)specificId), e);
                }
            }
            connection.close();
        }
        return groupDetail;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail getGroupByName(String groupName) throws AdminException {
        GroupDetail groupDetail;
        block8: {
            Connection connection = this.dataSource.getConnection();
            try {
                groupDetail = this.localGroupMgr.getGroupByName(connection, groupName);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)GROUP, (Object)groupName), e);
                }
            }
            connection.close();
        }
        return groupDetail;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail[] getGroups(String groupId) throws AdminException {
        GroupDetail[] groupDetailArray;
        block9: {
            Connection connection = this.dataSource.getConnection();
            try {
                List<GroupDetail> ar = this.localGroupMgr.getDirectSubGroups(connection, SQLDriver.idAsInt(groupId));
                for (GroupDetail theGroup : ar) {
                    List<String> asUsersId = this.localGroupUserRelMgr.getDirectUserIdsOfGroup(connection, SQLDriver.idAsInt(theGroup.getSpecificId()));
                    theGroup.setUserIds(asUsersId.toArray(new String[0]));
                }
                groupDetailArray = ar.toArray(new GroupDetail[0]);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"subgroups of group", (Object)groupId), e);
                }
            }
            connection.close();
        }
        return groupDetailArray;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail[] getAllGroups() throws AdminException {
        GroupDetail[] groupDetailArray;
        block9: {
            Connection connection = this.dataSource.getConnection();
            try {
                List<GroupDetail> ar = this.localGroupMgr.getAllGroups(connection);
                for (GroupDetail theGroup : ar) {
                    List<String> asUsersId = this.localGroupUserRelMgr.getDirectUserIdsOfGroup(connection, SQLDriver.idAsInt(theGroup.getSpecificId()));
                    theGroup.setUserIds(asUsersId.toArray(new String[0]));
                }
                groupDetailArray = ar.toArray(new GroupDetail[0]);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all groups", (Object)""), e);
                }
            }
            connection.close();
        }
        return groupDetailArray;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public GroupDetail[] getAllRootGroups() throws AdminException {
        GroupDetail[] groupDetailArray;
        block9: {
            Connection connection = this.dataSource.getConnection();
            try {
                List<GroupDetail> ar = this.localGroupMgr.getDirectSubGroups(connection, -1);
                for (GroupDetail theGroup : ar) {
                    List<String> asUsersId = this.localGroupUserRelMgr.getDirectUserIdsOfGroup(connection, SQLDriver.idAsInt(theGroup.getSpecificId()));
                    theGroup.setUserIds(asUsersId.toArray(new String[0]));
                }
                groupDetailArray = ar.toArray(new GroupDetail[0]);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all root groups", (Object)""), e);
                }
            }
            connection.close();
        }
        return groupDetailArray;
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    public void addUserInGroup(String userId, String groupId) throws AdminException {
        try (Connection connection = this.dataSource.getConnection();){
            this.localGroupUserRelMgr.createGroupUserRel(connection, SQLDriver.idAsInt(groupId), SQLDriver.idAsInt(userId));
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)("user " + userId), (Object)("in group" + groupId)), e);
        }
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    public void removeUserFromGroup(String userId, String groupId) throws AdminException {
        try (Connection connection = this.dataSource.getConnection();){
            this.localGroupUserRelMgr.removeGroupUserRel(connection, SQLDriver.idAsInt(groupId), SQLDriver.idAsInt(userId));
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)("user " + userId), (Object)("in group" + groupId)), e);
        }
    }

    @Override
    public List<String> getUserAttributes() throws AdminException {
        return Arrays.asList(this.getPropertiesNames());
    }
}

