/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.ldapdriver;

import org.silverpeas.core.security.encryption.ContentEncryptionService;
import org.silverpeas.core.security.encryption.cipher.CryptoException;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.kernel.logging.SilverLogger;

public class LdapConfiguration {
    private boolean encryptedCredentials = false;
    private String ldapHost = "localhost";
    private int ldapPort = 389;
    private String username;
    private String password;
    private int timeout = 0;
    private boolean secure = false;

    public void setEncryptedCredentials(boolean encryptedCredentials) {
        this.encryptedCredentials = encryptedCredentials;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public byte[] getPassword() {
        return this.decryptIfNeeded(this.password).getBytes(Charsets.UTF_8);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLdapHost() {
        return this.ldapHost;
    }

    public void setLdapHost(String ldapHost) {
        this.ldapHost = ldapHost;
    }

    public int getLdapPort() {
        return this.ldapPort;
    }

    public void setLdapPort(int ldapPort) {
        this.ldapPort = ldapPort;
    }

    public String getUsername() {
        return this.decryptIfNeeded(this.username);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String toString() {
        return "LdapConfiguration{ldapHost=" + this.ldapHost + ", ldapPort=" + this.ldapPort + ", username=" + this.username + ", password=" + this.password + ", timeout=" + this.timeout + ", secure=" + this.secure + "}";
    }

    private String decryptIfNeeded(String possibleEncryptedText) {
        try {
            return this.encryptedCredentials ? ContentEncryptionService.get().decryptContent(possibleEncryptedText)[0] : possibleEncryptedText;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | CryptoException e) {
            String additionalInfo = e.getCause() != null ? "Cause: " + e.getCause().getMessage() : "";
            SilverLogger.getLogger((Object)this).error(e.getMessage() + " " + additionalInfo, new Object[0]);
            return possibleEncryptedText;
        }
    }
}

