/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.ldapdriver;

import com.novell.ldap.LDAPEntry;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.silverpeas.core.admin.domain.driver.ldapdriver.AbstractLDAPGroup;
import org.silverpeas.core.admin.domain.driver.ldapdriver.LDAPUtility;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainReport;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class LDAPGroupAllRoot
extends AbstractLDAPGroup {
    private static final String LDAPGROUP_ALL_ROOT_GET_CHILD_GROUPS_ENTRY = "LDAPGroupAllRoot.getChildGroupsEntry()";
    private static final String GROUP_CYCLIC_PROCESS_SECURITY_CACHE_KEY = LDAPGroupAllRoot.class.getName() + "#getUserSpecificIds";

    private List<String> getMemberGroupIds(String lds, String memberId, boolean isGroup) throws AdminException {
        ArrayList<String> groupIds = new ArrayList<String>();
        if (StringUtil.isDefined((String)memberId)) {
            LDAPEntry memberEntry = this.getMemberEntry(lds, memberId, isGroup);
            String groupsMemberField = this.driverSettings.getGroupsMemberField();
            LDAPEntry[] theEntries = "memberUid".equalsIgnoreCase(groupsMemberField) ? LDAPUtility.search1000Plus(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), "(&" + this.driverSettings.getGroupsFullFilter() + "(" + this.driverSettings.getGroupsMemberField() + "=" + memberId + "))", this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes()) : LDAPUtility.search1000Plus(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), "(&" + this.driverSettings.getGroupsFullFilter() + "(" + this.driverSettings.getGroupsMemberField() + "=" + LDAPUtility.normalizeFilterValue(memberEntry.getDN()) + "))", this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes());
            for (LDAPEntry currentEntry : theEntries) {
                groupIds.add(this.getGroupId(currentEntry));
            }
        }
        return groupIds;
    }

    @Override
    public String[] getGroupMemberGroupIds(String lds, String groupId) {
        return ArrayUtil.emptyStringArray();
    }

    @Override
    public String[] getUserMemberGroupIds(String lds, String userId) throws AdminException {
        HashSet<String> groupsManaged = new HashSet<String>();
        List<String> groupsIdsSet = this.getMemberGroupIds(lds, userId, false);
        while (!groupsIdsSet.isEmpty()) {
            ArrayList<String> groupsCur = new ArrayList<String>();
            for (String grId : groupsIdsSet) {
                if (!StringUtil.isDefined((String)grId) || groupsManaged.contains(grId)) continue;
                groupsManaged.add(grId);
                groupsCur.addAll(this.getMemberGroupIds(lds, grId, true));
            }
            groupsIdsSet = groupsCur;
        }
        return groupsManaged.toArray(new String[0]);
    }

    @Override
    protected String[] getUserIds(String lds, LDAPEntry groupEntry) {
        HashSet<String> usersManaged = new HashSet<String>();
        HashSet<String> groupsManaged = new HashSet<String>();
        ArrayList<LDAPEntry> groupsSet = new ArrayList<LDAPEntry>();
        groupsSet.add(groupEntry);
        while (!groupsSet.isEmpty()) {
            ArrayList<LDAPEntry> groupsCur = new ArrayList<LDAPEntry>();
            for (LDAPEntry curGroup : groupsSet) {
                String grId;
                if (curGroup == null || groupsManaged.contains(grId = this.getGroupId(curGroup))) continue;
                groupsManaged.add(grId);
                usersManaged.addAll(this.getUserSpecificIds(lds, curGroup));
                groupsCur.addAll(this.getChildGroupsEntry(lds, curGroup));
            }
            groupsSet = groupsCur;
        }
        return usersManaged.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUserSpecificIds(String lds, LDAPEntry groupEntry) {
        Set processedGroups = (Set)CacheAccessorProvider.getThreadCacheAccessor().getCache().computeIfAbsent((Object)GROUP_CYCLIC_PROCESS_SECURITY_CACHE_KEY, Set.class, HashSet::new);
        boolean isFirstCall = Objects.requireNonNull(processedGroups).isEmpty();
        ArrayList<String> users = new ArrayList<String>();
        try {
            if (!processedGroups.add(groupEntry.getDN())) {
                String warning = MessageFormat.format("Users of group with DN ''{0}'' have already been retrieved (please verify a potential circular case)", groupEntry.getDN());
                SilverLogger.getLogger((Object)this).warn(warning, new Object[0]);
                SynchroDomainReport.warn(LDAPGROUP_ALL_ROOT_GET_CHILD_GROUPS_ENTRY, warning);
            } else {
                String[] stringVals;
                String groupsMemberField = this.driverSettings.getGroupsMemberField();
                for (String memberFieldValue : stringVals = LDAPUtility.getAttributeValues(groupEntry, groupsMemberField)) {
                    try {
                        if ("memberUid".equals(groupsMemberField)) {
                            Optional.ofNullable(this.getUserEntryByUID(lds, memberFieldValue)).ifPresent(e -> users.add(memberFieldValue));
                            continue;
                        }
                        this.findUserIdsByDNOrUID(lds, memberFieldValue, users);
                    }
                    catch (AdminException e2) {
                        SilverLogger.getLogger((Object)this).error("USER NOT FOUND : " + LDAPUtility.dblBackSlashesForDNInFilters(memberFieldValue), (Throwable)((Object)e2));
                    }
                }
            }
        }
        finally {
            if (isFirstCall) {
                CacheAccessorProvider.getThreadCacheAccessor().getCache().remove((Object)GROUP_CYCLIC_PROCESS_SECURITY_CACHE_KEY);
            }
        }
        return users;
    }

    private void findUserIdsByDNOrUID(String lds, String memberFieldValue, List<String> users) throws AdminException {
        LDAPEntry userEntry = this.getUserEntryByDN(lds, memberFieldValue);
        if (userEntry != null) {
            String userSpecificId = this.getUserId(userEntry);
            if ((userEntry = this.getUserEntryByUID(lds, userSpecificId)) != null) {
                users.add(userSpecificId);
            }
        } else {
            LDAPEntry gEntry = this.getGroupEntryByDN(lds, memberFieldValue);
            if (gEntry != null) {
                users.addAll(this.getUserSpecificIds(lds, gEntry));
            }
        }
    }

    @Override
    protected LDAPEntry[] getChildGroupsEntry(String lds, String parentId, String extraFilter) throws AdminException {
        LDAPEntry[] theEntries;
        if (StringUtil.isDefined((String)parentId)) {
            return new LDAPEntry[0];
        }
        Object theFilter = this.driverSettings.getGroupsFullFilter();
        if (StringUtil.isDefined((String)extraFilter)) {
            theFilter = "(&" + extraFilter + this.driverSettings.getGroupsFullFilter() + ")";
        }
        try {
            theEntries = LDAPUtility.search1000Plus(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), (String)theFilter, this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes());
            SynchroDomainReport.debug(LDAPGROUP_ALL_ROOT_GET_CHILD_GROUPS_ENTRY, "R\u00e9cup\u00e9ration de " + theEntries.length + " groupes racine");
        }
        catch (AdminException e) {
            if (this.synchroInProcess) {
                SilverLogger.getLogger((Object)this).warn((Throwable)((Object)e));
                this.append("PB getting Group's subgroups : ").append(parentId).append("\n");
                SynchroDomainReport.error(LDAPGROUP_ALL_ROOT_GET_CHILD_GROUPS_ENTRY, "Erreur lors de la r\u00e9cup\u00e9ration des groupes racine (parentId = " + parentId + ")", (Throwable)((Object)e));
                theEntries = new LDAPEntry[]{};
            }
            throw e;
        }
        return theEntries;
    }

    private List<LDAPEntry> getChildGroupsEntry(String lds, LDAPEntry theEntry) {
        try {
            LDAPEntry[] entries = LDAPUtility.search1000Plus(lds, theEntry.getDN(), this.driverSettings.getScope(), this.driverSettings.getGroupsFullFilter(), this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes());
            if (entries != null) {
                ArrayList<LDAPEntry> subGroups = new ArrayList<LDAPEntry>();
                for (LDAPEntry entry : entries) {
                    if (entry.getDN().equals(theEntry.getDN())) continue;
                    subGroups.add(entry);
                }
                return subGroups;
            }
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error("GETTING SUBGROUPS FAILED FOR: " + theEntry.getDN(), (Throwable)((Object)e));
        }
        return new ArrayList<LDAPEntry>();
    }

    private String getGroupId(LDAPEntry entry) {
        return LDAPUtility.getFirstAttributeValue(entry, this.driverSettings.getGroupsIdField());
    }

    private String getUserId(LDAPEntry entry) {
        return LDAPUtility.getFirstAttributeValue(entry, this.driverSettings.getUsersIdField());
    }

    private LDAPEntry getUserEntryByUID(String lds, String uid) throws AdminException {
        return LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(uid), this.driverSettings.getUserAttributes());
    }

    private LDAPEntry getUserEntryByDN(String lds, String dn) throws AdminException {
        return LDAPUtility.getFirstEntryFromSearch(lds, dn, this.driverSettings.getScope(), this.driverSettings.getUsersFullFilter(), this.driverSettings.getUserAttributes());
    }

    private LDAPEntry getGroupEntryByDN(String lds, String dn) throws AdminException {
        return LDAPUtility.getFirstEntryFromSearch(lds, dn, this.driverSettings.getScope(), this.driverSettings.getGroupsFullFilter(), this.driverSettings.getGroupAttributes());
    }
}

