/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.domain.driver.ldapdriver;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.admin.domain.driver.DomainDescriptor;
import org.silverpeas.core.security.encryption.EncryptionContentIterator;
import org.silverpeas.core.security.encryption.cipher.CryptoException;
import org.silverpeas.kernel.SilverpeasResourcesLocation;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class LDAPCredentialsEncryptionIterator
implements EncryptionContentIterator {
    private static final String AUT_SERVER = "autServer";
    private static final String LOGIN = "LOGIN";
    private static final String PASSWORD = "PASSWORD";
    private Iterator<DomainDescriptor> domainDescriptors = new Iterator<DomainDescriptor>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public DomainDescriptor next() {
            throw new NoSuchElementException();
        }
    };
    private final Path domainsPath;
    private DomainDescriptor currentDomain;

    public LDAPCredentialsEncryptionIterator() {
        Path root = SilverpeasResourcesLocation.getInstance().getConfigurationFilesRootPath();
        this.domainsPath = root.resolve(Path.of("org", "silverpeas", "domains"));
    }

    @Override
    public void init() {
        Function<Path, DomainDescriptor> loadProperties = p -> {
            String domainName = p.toFile().getName().replaceFirst("domain", "").replace(".properties", "");
            DomainDescriptor descriptor = new DomainDescriptor(domainName);
            descriptor.loadDomainProperties();
            return descriptor;
        };
        Predicate<DomainDescriptor> hasEncryptedCredentials = p -> StringUtil.getBooleanValue((String)p.getDomainProperties().getProperty("database.encryptedCredentials", "false"));
        Predicate<Path> isADomainDescriptor = p -> p.toFile().getName().startsWith("domain");
        try (Stream<Path> streamChildren = Files.list(this.domainsPath);){
            Set domainsWithEncryptedCredentials = streamChildren.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(isADomainDescriptor).map(loadProperties).filter(hasEncryptedCredentials).collect(Collectors.toSet());
            this.domainDescriptors = domainsWithEncryptedCredentials.iterator();
        }
        catch (IOException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    @Override
    public Map<String, String> next() {
        this.currentDomain = this.domainDescriptors.next();
        Properties properties = this.currentDomain.getDomainProperties();
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put(LOGIN, properties.getProperty("database.LDAPAccessLoginDN"));
        credentials.put(PASSWORD, properties.getProperty("database.LDAPAccessPasswd"));
        return credentials;
    }

    @Override
    public boolean hasNext() {
        return this.domainDescriptors.hasNext();
    }

    @Override
    public void update(Map<String, String> updatedContent) {
        String login = updatedContent.get(LOGIN);
        String password = updatedContent.get(PASSWORD);
        Properties properties = new Properties();
        properties.setProperty("database.LDAPAccessLoginDN", login);
        properties.setProperty("database.LDAPAccessPasswd", password);
        this.currentDomain.updateDomainProperties(properties);
        this.currentDomain.loadAuthenticationProperties();
        Properties authProperties = this.currentDomain.getAuthenticationProperties();
        properties.clear();
        int serverCount = Integer.parseInt(authProperties.getProperty("autServersCount"));
        for (int i = 0; i < serverCount; ++i) {
            boolean isCredentialsEncrypted = StringUtil.getBooleanValue((String)authProperties.getProperty(AUT_SERVER + i + ".encryptedCredentials", "false"));
            if (!isCredentialsEncrypted) continue;
            properties.setProperty(AUT_SERVER + i + ".LDAPAccessLogin", login);
            properties.setProperty(AUT_SERVER + i + ".LDAPAccessPasswd", password);
        }
        this.currentDomain.updateAuthenticationProperties(properties);
    }

    @Override
    public void onError(Map<String, String> content, CryptoException ex) {
        SilverLogger.getLogger((Object)this).error(ex.getMessage(), new Object[0]);
    }
}

