/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.component.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.silverpeas.core.admin.component.model.Message;
import org.silverpeas.core.i18n.I18NHelper;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="WarningType", propOrder={"message"})
public class Warning {
    @XmlAttribute
    protected boolean always = false;
    protected List<Message> message = new ArrayList<Message>();
    @XmlTransient
    private Map<String, String> messages;

    public Warning() {
    }

    Warning(Warning other) {
        this.always = other.always;
        this.message = new ArrayList<Message>(other.message);
        this.messages = other.messages != null ? new HashMap<String, String>(other.messages) : null;
    }

    public boolean isAlways() {
        return this.always;
    }

    public void setAlways(boolean always) {
        this.always = always;
    }

    protected Map<String, String> getMessages() {
        if (this.messages == null) {
            this.messages = this.message.stream().collect(Collectors.toMap(Message::getLang, Message::getValue));
        }
        return this.messages;
    }

    public void putMessage(String language, String message) {
        this.messages = null;
        String safeLanguage = I18NHelper.checkLanguage(language);
        this.message.stream().filter(m -> m.getLang().equals(safeLanguage)).findFirst().orElseGet(() -> {
            Message msg = new Message();
            msg.setLang(safeLanguage);
            this.message.add(msg);
            return msg;
        }).setValue(message);
    }
}

