/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin;

import java.io.Serializable;
import java.util.Objects;
import org.silverpeas.core.ResourceIdentifier;
import org.silverpeas.core.admin.ProfiledObjectType;

public class ProfiledObjectId
implements ResourceIdentifier,
Serializable {
    private static final long serialVersionUID = -6252481085153576106L;
    private final String id;
    private final ProfiledObjectType type;
    public static final ProfiledObjectId NOTHING = new ProfiledObjectId();
    public static final String ROOT_ID = "0";

    private ProfiledObjectId() {
        this.id = "-1";
        this.type = ProfiledObjectType.NONE;
    }

    public ProfiledObjectId(ProfiledObjectType type, String id) {
        this.id = id;
        this.type = type;
    }

    public static ProfiledObjectId fromNode(String nodeId) {
        return new ProfiledObjectId(ProfiledObjectType.NODE, nodeId);
    }

    public static ProfiledObjectId from(String expressionId) {
        ProfiledObjectType type = ProfiledObjectType.fromCode(expressionId.substring(0, 1));
        String id = expressionId.substring(1);
        return new ProfiledObjectId(type, id);
    }

    public String getId() {
        return this.id;
    }

    private int getIdAsInt() {
        return Integer.parseInt(this.id);
    }

    public ProfiledObjectType getType() {
        return this.type;
    }

    public boolean isDefined() {
        return this.getType() != null && this.getIdAsInt() > -1;
    }

    public boolean isNotDefined() {
        return this.getType() == null || this.getIdAsInt() == -1;
    }

    public boolean isRootNode() {
        return this.isDefined() && this.type == ProfiledObjectType.NODE && ROOT_ID.equals(this.getId());
    }

    public String asString() {
        return this.type.getCode() + this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfiledObjectId)) {
            return false;
        }
        ProfiledObjectId objectId = (ProfiledObjectId)o;
        return this.id.equals(objectId.id) && this.type == objectId.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type});
    }
}

