/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.jpeg;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.monte.media.color.ICCPackedColorModel;
import org.monte.media.io.ByteArrayImageInputStream;
import org.monte.media.io.ImageInputStreamAdapter;
import org.monte.media.jpeg.CMYKJPEGImageReaderSpi;
import org.monte.media.jpeg.JFIFInputStream;

public class CMYKJPEGImageReader
extends ImageReader {
    private boolean isIgnoreICCProfile = false;
    private boolean isInvertColors = true;
    private static final DirectColorModel RGB = new DirectColorModel(24, 0xFF0000, 65280, 255);
    private BufferedImage image;
    private boolean didReturnImage;
    private static final int SCALEBITS = 16;
    private static final int MAXJSAMPLE = 255;
    private static final int CENTERJSAMPLE = 128;
    private static final int ONE_HALF = 32768;
    private static final int[] Cr_r_tab = new int[256];
    private static final int[] Cb_b_tab = new int[256];
    private static final int[] Cr_g_tab = new int[256];
    private static final int[] Cb_g_tab = new int[256];

    public CMYKJPEGImageReader() {
        this(new CMYKJPEGImageReaderSpi());
    }

    public CMYKJPEGImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.readHeader();
        return this.image.getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.readHeader();
        return this.image.getHeight();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.readHeader();
        LinkedList<ImageTypeSpecifier> l = new LinkedList<ImageTypeSpecifier>();
        l.add(new ImageTypeSpecifier(RGB, RGB.createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight())));
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        if (imageIndex > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.readHeader();
        this.didReturnImage = true;
        return this.image;
    }

    private void readHeader() throws IOException {
        if (this.image == null) {
            ImageInputStream iis = null;
            Object in = this.getInput();
            if (in instanceof byte[]) {
                iis = new ByteArrayImageInputStream((byte[])in);
            } else if (in instanceof ImageInputStream) {
                iis = (ImageInputStream)in;
            } else if (in instanceof InputStream) {
                iis = new MemoryCacheImageInputStream((InputStream)in);
            } else {
                throw new IOException("Can't handle input of type " + String.valueOf(in));
            }
            this.didReturnImage = false;
            this.image = CMYKJPEGImageReader.read(iis, this.isInvertColors, this.isIgnoreICCProfile);
        }
    }

    public boolean isInvertColors() {
        return this.isInvertColors;
    }

    public void setInvertColors(boolean newValue) {
        this.isInvertColors = newValue;
    }

    public boolean isIgnoreICCProfile() {
        return this.isIgnoreICCProfile;
    }

    public void setIgnoreICCProfile(boolean newValue) {
        this.isIgnoreICCProfile = newValue;
    }

    public static BufferedImage read(ImageInputStream in, boolean inverseYCCKColors, boolean isIgnoreColorProfile) throws IOException {
        in.seek(0L);
        int samplePrecision = 0;
        int numberOfLines = 0;
        int numberOfSamplesPerLine = 0;
        int numberOfComponentsInFrame = 0;
        int app14AdobeColorTransform = 0;
        ByteArrayOutputStream app2ICCProfile = new ByteArrayOutputStream();
        JFIFInputStream fifi = new JFIFInputStream(new ImageInputStreamAdapter(in));
        JFIFInputStream.Segment seg = fifi.getNextSegment();
        while (seg != null) {
            DataInputStream dis;
            if (65472 <= seg.marker && seg.marker <= 65475 || 65477 <= seg.marker && seg.marker <= 65479 || 65481 <= seg.marker && seg.marker <= 65483 || 65485 <= seg.marker && seg.marker <= 65487) {
                dis = new DataInputStream(fifi);
                samplePrecision = dis.readUnsignedByte();
                numberOfLines = dis.readUnsignedShort();
                numberOfSamplesPerLine = dis.readUnsignedShort();
                numberOfComponentsInFrame = dis.readUnsignedByte();
                break;
            }
            if (seg.marker == 65506) {
                if (seg.length >= 26 && (dis = new DataInputStream(fifi)).readLong() == 5279137264856878918L && dis.readInt() == 1229735168) {
                    dis.skipBytes(2);
                    byte[] b = new byte[1024];
                    int count = dis.read(b);
                    while (count != -1) {
                        app2ICCProfile.write(b, 0, count);
                        count = dis.read(b);
                    }
                }
            } else if (seg.marker == 65518 && seg.length == 12 && (long)(dis = new DataInputStream(fifi)).readInt() == 1097101154L && dis.readUnsignedShort() == 25856) {
                int version = dis.readUnsignedByte();
                int app14Flags0 = dis.readUnsignedShort();
                int app14Flags1 = dis.readUnsignedShort();
                app14AdobeColorTransform = dis.readUnsignedByte();
            }
            seg = fifi.getNextSegment();
        }
        BufferedImage img = null;
        if (numberOfComponentsInFrame != 4) {
            in.seek(0L);
            img = CMYKJPEGImageReader.readRGBImageFromYCC(new ImageInputStreamAdapter(in), null);
        } else if (numberOfComponentsInFrame == 4) {
            ICC_Profile profile = null;
            if (!isIgnoreColorProfile && app2ICCProfile.size() > 0) {
                try {
                    profile = ICC_Profile.getInstance(new ByteArrayInputStream(app2ICCProfile.toByteArray()));
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
            switch (app14AdobeColorTransform) {
                default: {
                    in.seek(0L);
                    if (inverseYCCKColors) {
                        img = CMYKJPEGImageReader.readImageFromInvertedCMYK(new ImageInputStreamAdapter(in), profile);
                        break;
                    }
                    img = CMYKJPEGImageReader.readImageFromCMYK(new ImageInputStreamAdapter(in), profile);
                    break;
                }
                case 1: {
                    throw new IOException("YCbCr not supported");
                }
                case 2: {
                    if (profile == null) {
                        profile = ICC_Profile.getInstance(CMYKJPEGImageReader.class.getResourceAsStream("Generic CMYK Profile.icc"));
                    }
                    in.seek(0L);
                    img = inverseYCCKColors ? CMYKJPEGImageReader.readImageFromInvertedYCCK(new ImageInputStreamAdapter(in), profile) : CMYKJPEGImageReader.readImageFromYCCK(new ImageInputStreamAdapter(in), profile);
                }
            }
        }
        return img;
    }

    private static ImageReader createNativeJPEGReader() {
        for (ImageReader r : () -> ImageIO.getImageReadersByFormatName("jpeg")) {
            if (!"com.sun.imageio.plugins.jpeg.JPEGImageReader".equals(r.getClass().getName())) continue;
            return r;
        }
        throw new InternalError("could not find native JPEG Reader");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImageFromCMYK(InputStream in, ICC_Profile cmykProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        try {
            BufferedImage image;
            inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
            reader.setInput(inputStream);
            Raster raster = reader.readRaster(0, null);
            BufferedImage bufferedImage = image = CMYKJPEGImageReader.createImageFromCMYK(raster, cmykProfile);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImageFromInvertedCMYK(InputStream in, ICC_Profile rgbaProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        try {
            BufferedImage image;
            inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
            reader.setInput(inputStream);
            Raster raster = reader.readRaster(0, null);
            BufferedImage bufferedImage = image = CMYKJPEGImageReader.createImageFromInvertedCMYK(raster, rgbaProfile);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImageFromRGB(InputStream in, ICC_Profile rgbaProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        try {
            BufferedImage image;
            inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
            reader.setInput(inputStream);
            Raster raster = reader.readRaster(0, null);
            BufferedImage bufferedImage = image = CMYKJPEGImageReader.createImageFromRGB(raster, rgbaProfile);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readRGBImageFromYCC(InputStream in, ICC_Profile rgbaProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        try {
            BufferedImage image;
            inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
            reader.setInput(inputStream);
            Raster raster = reader.readRaster(0, null);
            BufferedImage bufferedImage = image = CMYKJPEGImageReader.createImageFromYCC(raster, rgbaProfile);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImageFromYCCK(InputStream in, ICC_Profile cmykProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        try {
            BufferedImage image;
            inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
            reader.setInput(inputStream);
            Raster raster = reader.readRaster(0, null);
            BufferedImage bufferedImage = image = CMYKJPEGImageReader.createImageFromYCCK(raster, cmykProfile);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImageFromInvertedYCCK(InputStream in, ICC_Profile cmykProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        try {
            BufferedImage image;
            inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
            reader.setInput(inputStream);
            Raster raster = reader.readRaster(0, null);
            BufferedImage bufferedImage = image = CMYKJPEGImageReader.createImageFromInvertedYCCK(raster, cmykProfile);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    public static BufferedImage createImageFromYCCK(Raster ycckRaster, ICC_Profile cmykProfile) {
        return CMYKJPEGImageReader.createImageFromCMYK(CMYKJPEGImageReader.convertYCCKtoCMYK(ycckRaster), cmykProfile);
    }

    public static BufferedImage createImageFromInvertedYCCK(Raster ycckRaster, ICC_Profile cmykProfile) {
        return CMYKJPEGImageReader.createImageFromCMYK(CMYKJPEGImageReader.convertInvertedYCCKToCMYK(ycckRaster), cmykProfile);
    }

    public static BufferedImage createImageFromICCProfile(Raster raster, ICC_Profile profile) {
        ICC_ColorSpace cs = new ICC_ColorSpace(profile);
        WritableRaster r = (WritableRaster)raster;
        ColorModel cm = raster.getSampleModel() instanceof PixelInterleavedSampleModel ? new ComponentColorModel(cs, false, false, 1, raster.getTransferType()) : new ICCPackedColorModel(cs, raster);
        return new BufferedImage(cm, (WritableRaster)raster, cm.isAlphaPremultiplied(), null);
    }

    public static BufferedImage createImageFromCMYK(Raster cmykRaster, ICC_Profile cmykProfile) {
        if (cmykProfile == null) {
            try {
                cmykProfile = ICC_Profile.getInstance(CMYKJPEGImageReader.class.getResourceAsStream("Generic CMYK Profile.icc"));
            }
            catch (IOException ex) {
                System.err.println(String.valueOf(CMYKJPEGImageReader.class) + " resource missing: Generic CMYK Profile.icc");
            }
        }
        if (cmykProfile != null) {
            return CMYKJPEGImageReader.createImageFromICCProfile(cmykRaster, cmykProfile);
        }
        int w = cmykRaster.getWidth();
        int h = cmykRaster.getHeight();
        int[] rgb = new int[w * h];
        int[] C = cmykRaster.getSamples(0, 0, w, h, 0, (int[])null);
        int[] M = cmykRaster.getSamples(0, 0, w, h, 1, (int[])null);
        int[] Y = cmykRaster.getSamples(0, 0, w, h, 2, (int[])null);
        int[] K = cmykRaster.getSamples(0, 0, w, h, 3, (int[])null);
        int BSIZE = 4096;
        IntStream.range(0, (rgb.length + 4096 - 1) / 4096).parallel().parallel().forEach(band -> {
            int m = Math.min(band * 4096 + 4096, rgb.length);
            for (int i = band * 4096; i < m; ++i) {
                int k = K[i];
                rgb[i] = 255 - Math.min(255, C[i] + k) << 16 | 255 - Math.min(255, M[i] + k) << 8 | 255 - Math.min(255, Y[i] + k);
            }
        });
        Hashtable properties = new Hashtable();
        WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255}, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        DirectColorModel cm = RGB;
        return new BufferedImage(cm, rgbRaster, cm.isAlphaPremultiplied(), properties);
    }

    public static BufferedImage createImageFromInvertedCMYK(Raster rgbwRaster, ICC_Profile cmykProfile) {
        int w = rgbwRaster.getWidth();
        int h = rgbwRaster.getHeight();
        try {
            CompletableFuture<int[]> cfR = CompletableFuture.supplyAsync(() -> rgbwRaster.getSamples(0, 0, w, h, 0, (int[])null));
            CompletableFuture<int[]> cfG = CompletableFuture.supplyAsync(() -> rgbwRaster.getSamples(0, 0, w, h, 1, (int[])null));
            CompletableFuture<int[]> cfB = CompletableFuture.supplyAsync(() -> rgbwRaster.getSamples(0, 0, w, h, 2, (int[])null));
            CompletableFuture<int[]> cfW = CompletableFuture.supplyAsync(() -> rgbwRaster.getSamples(0, 0, w, h, 3, (int[])null));
            int[] rgb = new int[w * h];
            int[] R = cfR.get();
            int[] G = cfG.get();
            int[] B = cfB.get();
            int[] W = cfW.get();
            int BSIZE = 4096;
            IntStream.range(0, (rgb.length + 4096 - 1) / 4096).parallel().parallel().forEach(band -> {
                int m = Math.min(band * 4096 + 4096, rgb.length);
                for (int i = band * 4096; i < m; ++i) {
                    rgb[i] = 255 - W[i] << 24 | 255 - R[i] << 16 | 255 - G[i] << 8 | 255 - B[i] << 0;
                }
            });
            WritableRaster packedRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255, -16777216}, null);
            return CMYKJPEGImageReader.createImageFromCMYK(packedRaster, cmykProfile);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InternalError(e);
        }
    }

    public static BufferedImage createImageFromRGB(Raster rgbRaster, ICC_Profile rgbProfile) {
        if (rgbProfile != null) {
            return CMYKJPEGImageReader.createImageFromICCProfile(rgbRaster, rgbProfile);
        }
        int w = rgbRaster.getWidth();
        int h = rgbRaster.getHeight();
        try {
            CompletableFuture<int[]> cfR = CompletableFuture.supplyAsync(() -> rgbRaster.getSamples(0, 0, w, h, 0, (int[])null));
            CompletableFuture<int[]> cfG = CompletableFuture.supplyAsync(() -> rgbRaster.getSamples(0, 0, w, h, 1, (int[])null));
            CompletableFuture<int[]> cfB = CompletableFuture.supplyAsync(() -> rgbRaster.getSamples(0, 0, w, h, 2, (int[])null));
            int[] rgb = new int[w * h];
            int[] R = cfR.get();
            int[] G = cfG.get();
            int[] B = cfB.get();
            int BSIZE = 4096;
            IntStream.range(0, (rgb.length + 4096 - 1) / 4096).parallel().parallel().forEach(band -> {
                int m = Math.min(band * 4096 + 4096, rgb.length);
                for (int i = band * 4096; i < m; ++i) {
                    rgb[i] = 0xFF000000 | R[i] << 16 | G[i] << 8 | B[i];
                }
            });
            WritableRaster packedRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255, -16777216}, null);
            ColorSpace cs = ColorSpace.getInstance(1000);
            ColorModel cm = ColorModel.getRGBdefault();
            Hashtable properties = new Hashtable();
            return new BufferedImage(cm, packedRaster, cm.isAlphaPremultiplied(), properties);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InternalError(e);
        }
    }

    public static BufferedImage createImageFromYCC(Raster yccRaster, ICC_Profile yccProfile) {
        if (yccProfile != null) {
            return CMYKJPEGImageReader.createImageFromICCProfile(yccRaster, yccProfile);
        }
        int w = yccRaster.getWidth();
        int h = yccRaster.getHeight();
        try {
            CompletableFuture<int[]> cfY = CompletableFuture.supplyAsync(() -> yccRaster.getSamples(0, 0, w, h, 0, (int[])null));
            CompletableFuture<int[]> cfCb = CompletableFuture.supplyAsync(() -> yccRaster.getSamples(0, 0, w, h, 1, (int[])null));
            CompletableFuture<int[]> cfCr = CompletableFuture.supplyAsync(() -> yccRaster.getSamples(0, 0, w, h, 2, (int[])null));
            int[] rgb = new int[w * h];
            int[] Y = cfY.get();
            int[] Cb = cfCb.get();
            int[] Cr = cfCr.get();
            int BSIZE = 4096;
            IntStream.range(0, (rgb.length + 4096 - 1) / 4096).parallel().parallel().forEach(band -> {
                int m = Math.min(band * 4096 + 4096, rgb.length);
                for (int i = band * 4096; i < m; ++i) {
                    int Yi = Y[i];
                    int Cbi = Cb[i];
                    int Cri = Cr[i];
                    int R = (1000 * Yi + 1402 * (Cri - 128)) / 1000;
                    int G = (100000 * Yi - 34414 * (Cbi - 128) - 71414 * (Cri - 128)) / 100000;
                    int B = (1000 * Yi + 1772 * (Cbi - 128)) / 1000;
                    R = Math.min(255, Math.max(0, R));
                    G = Math.min(255, Math.max(0, G));
                    B = Math.min(255, Math.max(0, B));
                    rgb[i] = 0xFF000000 | R << 16 | G << 8 | B;
                }
            });
            Hashtable properties = new Hashtable();
            WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255, -16777216}, null);
            ColorSpace cs = ColorSpace.getInstance(1000);
            ColorModel cm = ColorModel.getRGBdefault();
            return new BufferedImage(cm, rgbRaster, cm.isAlphaPremultiplied(), properties);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InternalError(e);
        }
    }

    private static synchronized void buildYCCtoRGBtable() {
        if (Cr_r_tab[0] == 0) {
            int i = 0;
            int x = -128;
            while (i <= 255) {
                CMYKJPEGImageReader.Cr_r_tab[i] = (int)(91881.972 * (double)x + 32768.0) >> 16;
                CMYKJPEGImageReader.Cb_b_tab[i] = (int)(116130.292 * (double)x + 32768.0) >> 16;
                CMYKJPEGImageReader.Cr_g_tab[i] = -46802 * x;
                CMYKJPEGImageReader.Cb_g_tab[i] = -22554 * x + 32768;
                ++i;
                ++x;
            }
        }
    }

    private static Raster convertInvertedYCCKToCMYK(Raster ycckRaster) {
        return CMYKJPEGImageReader.convertInvertedYCCKToCMYK_byBytes(ycckRaster);
    }

    private static Raster convertInvertedYCCKToCMYK_byBytes(Raster ycckRaster) {
        CMYKJPEGImageReader.buildYCCtoRGBtable();
        int w = ycckRaster.getWidth();
        int h = ycckRaster.getHeight();
        if (!(ycckRaster.getDataBuffer() instanceof DataBufferByte)) {
            return CMYKJPEGImageReader.convertInvertedYCCKToCMYK_byPixels(ycckRaster);
        }
        byte[] ycck = ((DataBufferByte)ycckRaster.getDataBuffer()).getData();
        int[] cmyk = new int[w * h];
        int BSIZE = 4096;
        IntStream.range(0, (cmyk.length + 4096 - 1) / 4096).parallel().parallel().forEach(band -> {
            int m = Math.min(band * 4096 + 4096, cmyk.length);
            for (int i = band * 4096; i < m; ++i) {
                int j = i * 4;
                int y = 255 - (ycck[j] & 0xFF);
                int cb = 255 - (ycck[j + 1] & 0xFF);
                int cr = 255 - (ycck[j + 2] & 0xFF);
                int k = 255 - (ycck[j + 3] & 0xFF);
                int cmykC = 255 - (y + Cr_r_tab[cr]);
                int cmykM = 255 - (y + (Cb_g_tab[cb] + Cr_g_tab[cr] >> 16));
                int cmykY = 255 - (y + Cb_b_tab[cb]);
                cmyk[i] = (cmykC < 0 ? 0 : (cmykC > 255 ? 255 : cmykC)) << 24 | (cmykM < 0 ? 0 : (cmykM > 255 ? 255 : cmykM)) << 16 | (cmykY < 0 ? 0 : (cmykY > 255 ? 255 : cmykY)) << 8 | k;
            }
        });
        WritableRaster cmykRaster = Raster.createPackedRaster(new DataBufferInt(cmyk, cmyk.length), w, h, w, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
        return cmykRaster;
    }

    private static Raster convertInvertedYCCKToCMYK_byPixels(Raster ycckRaster) {
        CMYKJPEGImageReader.buildYCCtoRGBtable();
        int w = ycckRaster.getWidth();
        int h = ycckRaster.getHeight();
        int[] ycck = ycckRaster.getPixels(0, 0, w, h, (int[])null);
        int[] cmyk = new int[w * h];
        int BSIZE = 4096;
        IntStream.range(0, (cmyk.length + 4096 - 1) / 4096).parallel().parallel().forEach(band -> {
            int m = Math.min(band * 4096 + 4096, cmyk.length);
            for (int i = band * 4096; i < m; ++i) {
                int j = i * 4;
                int y = 255 - ycck[j];
                int cb = 255 - ycck[j + 1];
                int cr = 255 - ycck[j + 2];
                int cmykC = 255 - (y + Cr_r_tab[cr]);
                int cmykM = 255 - (y + (Cb_g_tab[cb] + Cr_g_tab[cr] >> 16));
                int cmykY = 255 - (y + Cb_b_tab[cb]);
                cmyk[i] = (cmykC < 0 ? 0 : (cmykC > 255 ? 255 : cmykC)) << 24 | (cmykM < 0 ? 0 : (cmykM > 255 ? 255 : cmykM)) << 16 | (cmykY < 0 ? 0 : (cmykY > 255 ? 255 : cmykY)) << 8 | 255 - ycck[j + 3];
            }
        });
        WritableRaster cmykRaster = Raster.createPackedRaster(new DataBufferInt(cmyk, cmyk.length), w, h, w, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
        return cmykRaster;
    }

    private static Raster convertInvertedYCCKToCMYK_bySamples(Raster ycckRaster) {
        CMYKJPEGImageReader.buildYCCtoRGBtable();
        int w = ycckRaster.getWidth();
        int h = ycckRaster.getHeight();
        try {
            CompletableFuture<int[]> cfY = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 0, (int[])null));
            CompletableFuture<int[]> cfCb = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 1, (int[])null));
            CompletableFuture<int[]> cfCr = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 2, (int[])null));
            CompletableFuture<int[]> cfK = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 3, (int[])null));
            int[] cmyk = new int[w * h];
            int[] ycckY = cfY.get();
            int[] ycckCb = cfCb.get();
            int[] ycckCr = cfCr.get();
            int[] ycckK = cfK.get();
            int BSIZE = 4096;
            IntStream.range(0, (cmyk.length + 4096 - 1) / 4096).parallel().parallel().forEach(band -> {
                int m = Math.min(band * 4096 + 4096, cmyk.length);
                for (int i = band * 4096; i < m; ++i) {
                    int y = 255 - ycckY[i];
                    int cb = 255 - ycckCb[i];
                    int cr = 255 - ycckCr[i];
                    int cmykC = 255 - (y + Cr_r_tab[cr]);
                    int cmykM = 255 - (y + (Cb_g_tab[cb] + Cr_g_tab[cr] >> 16));
                    int cmykY = 255 - (y + Cb_b_tab[cb]);
                    cmyk[i] = (cmykC < 0 ? 0 : (cmykC > 255 ? 255 : cmykC)) << 24 | (cmykM < 0 ? 0 : (cmykM > 255 ? 255 : cmykM)) << 16 | (cmykY < 0 ? 0 : (cmykY > 255 ? 255 : cmykY)) << 8 | 255 - ycckK[i];
                }
            });
            WritableRaster cmykRaster = Raster.createPackedRaster(new DataBufferInt(cmyk, cmyk.length), w, h, w, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
            return cmykRaster;
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new InternalError(ex);
        }
    }

    private static Raster convertYCCKtoCMYK(Raster ycckRaster) {
        CMYKJPEGImageReader.buildYCCtoRGBtable();
        int w = ycckRaster.getWidth();
        int h = ycckRaster.getHeight();
        try {
            CompletableFuture<int[]> cfY = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 0, (int[])null));
            CompletableFuture<int[]> cfCb = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 1, (int[])null));
            CompletableFuture<int[]> cfCr = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 2, (int[])null));
            CompletableFuture<int[]> cfK = CompletableFuture.supplyAsync(() -> ycckRaster.getSamples(0, 0, w, h, 3, (int[])null));
            int[] cmyk = new int[w * h];
            int[] ycckY = cfY.get();
            int[] ycckCb = cfCb.get();
            int[] ycckCr = cfCr.get();
            int[] ycckK = cfK.get();
            int BSIZE = 4096;
            IntStream.range(0, (cmyk.length + 4096 - 1) / 4096).parallel().parallel().forEach(band -> {
                int m = Math.min(band * 4096 + 4096, cmyk.length);
                for (int i = band * 4096; i < m; ++i) {
                    int y = ycckY[i];
                    int cb = ycckCb[i];
                    int cr = ycckCr[i];
                    int cmykC = 255 - (y + Cr_r_tab[cr]);
                    int cmykM = 255 - (y + (Cb_g_tab[cb] + Cr_g_tab[cr] >> 16));
                    int cmykY = 255 - (y + Cb_b_tab[cb]);
                    cmyk[i] = (cmykC < 0 ? 0 : (cmykC > 255 ? 255 : cmykC)) << 24 | (cmykM < 0 ? 0 : (cmykM > 255 ? 255 : cmykM)) << 16 | (cmykY < 0 ? 0 : (cmykY > 255 ? 255 : cmykY)) << 8 | ycckK[i];
                }
            });
            return Raster.createPackedRaster(new DataBufferInt(cmyk, cmyk.length), w, h, w, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InternalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImageFromYCCorGray(ImageInputStream in) throws IOException {
        ImageReader r = CMYKJPEGImageReader.createNativeJPEGReader();
        try {
            BufferedImage img;
            r.setInput(in);
            BufferedImage bufferedImage = img = r.read(0);
            return bufferedImage;
        }
        finally {
            r.dispose();
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.image != null && !this.didReturnImage) {
                this.image.flush();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            this.image = null;
        }
    }
}

