/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.wysiwyg;

import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.component.model.SilverpeasComponent;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.http.RequestParameterDecoder;
import org.silverpeas.core.web.mvc.util.WysiwygEditorConfigRegistry;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.web.util.WysiwygEditorConfig;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.webapi.wysiwyg.WysiwygEditorConfigParameters;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="wysiwyg/editor/{componentInstanceId}")
@Authorized
public class WysiwygEditorConfigResource
extends RESTWebService {
    static final String WYSIWYG_CONFIG_BASE_URI = "wysiwyg/editor";
    @PathParam(value="componentInstanceId")
    private String componentInstanceId;
    @QueryParam(value="configName")
    private String configName;

    @GET
    @Path(value="{resourceType}/{resourceId}")
    @Produces(value={"application/json"})
    public Response getWysiwygEditorConfig(@PathParam(value="resourceType") String resourceType, @PathParam(value="resourceId") String resourceId) {
        WysiwygEditorConfigParameters params = (WysiwygEditorConfigParameters)RequestParameterDecoder.decode((HttpRequest)this.getHttpRequest(), WysiwygEditorConfigParameters.class);
        return (Response)this.process(() -> {
            WysiwygEditorConfig config = WysiwygEditorConfigRegistry.get().get(this.getConfigName());
            config.setComponentId(this.getComponentId());
            config.setObjectId(resourceId);
            config.setLanguage(this.getUserPreferences().getLanguage());
            this.setWysiwygEditorSessionContext(resourceType, resourceId, config);
            return Response.ok((Object)params.applyOn(config).toJSON()).build();
        }).lowestAccessRole(SilverpeasRole.WRITER).execute();
    }

    private void setWysiwygEditorSessionContext(String resourceType, String resourceId, WysiwygEditorConfig wysiwygEditorConfig) {
        String styleSheet;
        HttpSession session = this.getHttpRequest().getSession();
        GraphicElementFactory gef = (GraphicElementFactory)session.getAttribute("SessionGraphicElementFactory");
        session.setAttribute("WYSIWYG_ComponentId", (Object)this.getComponentId());
        session.setAttribute("WYSIWYG_ComponentLabel", null);
        session.setAttribute("WYSIWYG_BrowseInfo", null);
        session.setAttribute("WYSIWYG_ObjectId", (Object)resourceId);
        session.setAttribute("WYSIWYG_ObjectType", (Object)resourceType);
        session.setAttribute("WYSIWYG_Language", (Object)wysiwygEditorConfig.getLanguage());
        SettingBundle settings = gef.getFavoriteLookSettings();
        if (settings != null && StringUtil.isDefined((String)(styleSheet = settings.getString("StyleSheet", "")))) {
            wysiwygEditorConfig.setStylesheet(styleSheet);
        }
    }

    private String getConfigName() {
        if (StringUtil.isDefined((String)this.configName)) {
            return this.configName;
        }
        return ((SilverpeasComponent)SilverpeasComponent.getByInstanceId((String)this.getComponentId()).orElseThrow(() -> new WebApplicationException(SilverpeasExceptionMessages.unknown((String)"component behind id", (Object)this.getComponentId()), Response.Status.NOT_FOUND))).getName();
    }

    public String getComponentId() {
        return this.componentInstanceId;
    }

    protected String getResourceBasePath() {
        return WYSIWYG_CONFIG_BASE_URI;
    }
}

