/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.variables;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.variables.Variable;
import org.silverpeas.core.variables.VariableScheduledValue;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.variables.VariableScheduledValueEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class VariableEntity
implements WebEntity {
    private URI uri;
    private String id;
    private String label;
    private String description;
    private String value;
    private List<VariableScheduledValueEntity> values = new ArrayList<VariableScheduledValueEntity>();

    protected VariableEntity() {
    }

    public static VariableEntity fromVariable(Variable variable) {
        VariableEntity entity = new VariableEntity().decorate(variable);
        List<VariableScheduledValueEntity> valueEntities = variable.getVariableValues().stream().map(VariableScheduledValueEntity::fromVariableScheduledValue).collect(Collectors.toList());
        variable.getVariableValues().getCurrent().ifPresent(v -> entity.setValue(v.getValue()));
        entity.setValues(valueEntities);
        return entity;
    }

    public Variable toVariable() {
        Variable variable = new Variable(this.label, this.description);
        variable.getVariableValues().addAll(this.toScheduledValues());
        return variable;
    }

    public List<VariableScheduledValue> toScheduledValues() {
        ArrayList<VariableScheduledValue> result = new ArrayList<VariableScheduledValue>();
        for (VariableScheduledValueEntity entity : this.values) {
            result.add(entity.toVariableScheduledValue());
        }
        return result;
    }

    protected VariableEntity decorate(Variable value) {
        this.id = value.getId();
        this.label = value.getLabel();
        this.description = value.getDescription();
        return this;
    }

    protected void merge(Variable value) {
        value.setLabel(this.getLabel());
        value.setDescription(this.getDescription());
    }

    public URI getURI() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<VariableScheduledValueEntity> getValues() {
        return this.values;
    }

    public void setValues(List<VariableScheduledValueEntity> values) {
        this.values = values;
    }
}

