/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.upload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.function.UnaryOperator;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.admin.component.model.ComponentFileFilterParameter;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.io.upload.UploadSession;
import org.silverpeas.core.io.upload.UploadSessionFile;
import org.silverpeas.core.notification.message.MessageNotifier;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.util.UnitUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.http.RequestParameterDecoder;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.web.util.IFrameAjaxTransportUtil;
import org.silverpeas.core.webapi.upload.ComponentInstanceFileUploadVerification;
import org.silverpeas.core.webapi.upload.FileUploadData;
import org.silverpeas.core.webapi.upload.FileUploadVerifyData;
import org.silverpeas.core.webapi.upload.UploadedRequestFile;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="fileUpload")
@Authenticated
public class FileUploadResource
extends RESTWebService {
    private static final Semaphore requestLimit = new Semaphore(50, true);
    static final String PATH = "fileUpload";
    @Inject
    private ComponentAccessControl componentAccessController;

    @POST
    @Path(value="verify")
    @Consumes(value={"multipart/form-data"})
    public Response verify() {
        FileUploadVerifyData fileUploadVerifyData = (FileUploadVerifyData)RequestParameterDecoder.decode((HttpRequest)this.getHttpRequest(), FileUploadVerifyData.class);
        this.checkMaximumFileSize(fileUploadVerifyData.getName(), fileUploadVerifyData.getSize());
        this.checkAuthorizedMimeTypes(fileUploadVerifyData.getName());
        this.checkSpecificComponentVerifications(fileUploadVerifyData, null);
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    public Response uploadFiles() {
        UploadedRequestFile uploadedRequestFile = (UploadedRequestFile)RequestParameterDecoder.decode((HttpRequest)this.getHttpRequest(), UploadedRequestFile.class);
        try {
            UnaryOperator<JSONCodec.JSONObject> builder = this.uploadFile(FileUploadData.from(uploadedRequestFile), uploadedRequestFile.getRequestFile().getInputStream());
            String jsonFiles = IFrameAjaxTransportUtil.packJSonArrayWithHtmlContainer(a -> a.addJSONObject(builder));
            return Response.ok().entity((Object)jsonFiles).build();
        }
        catch (WebApplicationException ex) {
            if ("IFrame".equals(uploadedRequestFile.getXRequestedWith()) && ex.getResponse().getStatus() == Response.Status.PRECONDITION_FAILED.getStatusCode()) {
                ex = IFrameAjaxTransportUtil.createWebApplicationExceptionWithJSonErrorInHtmlContainer(ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)((Object)this)).silent((Throwable)ex);
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"text/html"})
    public Response uploadFile(InputStream inputStream) {
        try {
            String jsonFile = IFrameAjaxTransportUtil.packJSonObjectWithHtmlContainer(this.uploadFile(FileUploadData.from(this.getHttpServletRequest()), inputStream));
            return Response.ok().entity((Object)jsonFile).build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)((Object)this)).silent((Throwable)ex);
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnaryOperator<JSONCodec.JSONObject> uploadFile(FileUploadData fileUploadData, InputStream inputStream) throws InterruptedException {
        if (StringUtil.isNotDefined((String)fileUploadData.getFullPath())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        requestLimit.acquire();
        try {
            UploadSession uploadSession = UploadSession.from((String)fileUploadData.getUploadSessionId());
            if (StringUtil.isDefined((String)fileUploadData.getComponentInstanceId()) && !this.componentAccessController.isUserAuthorized(this.getUser().getId(), (Object)fileUploadData.getComponentInstanceId())) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (StringUtil.isDefined((String)uploadSession.getComponentInstanceId())) {
                if (!uploadSession.getComponentInstanceId().equals(fileUploadData.getComponentInstanceId())) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
            } else if (StringUtil.isDefined((String)fileUploadData.getComponentInstanceId())) {
                uploadSession.forComponentInstanceId(fileUploadData.getComponentInstanceId());
            }
            UploadSessionFile uploadSessionFile = uploadSession.getUploadSessionFile(fileUploadData.getFullPath());
            try {
                uploadSessionFile.write(inputStream);
            }
            catch (IOException ioe) {
                throw new WebApplicationException((Throwable)ioe, Response.Status.CONFLICT);
            }
            try {
                this.checkMaximumFileSize(fileUploadData.getName(), uploadSessionFile.getServerFile().length());
                this.checkAuthorizedMimeTypes(uploadSessionFile.getServerFile().getPath());
                this.checkSpecificComponentVerifications(null, uploadSessionFile.getServerFile());
            }
            catch (Exception e) {
                uploadSession.remove(fileUploadData.getFullPath());
                throw e;
            }
            UnaryOperator<JSONCodec.JSONObject> unaryOperator = this.asJSON(uploadSessionFile);
            return unaryOperator;
        }
        finally {
            requestLimit.release();
        }
    }

    private void checkMaximumFileSize(String fileName, long fileSize) {
        long maximumFileSize = FileRepositoryManager.getUploadMaximumFileSize();
        if (fileSize > maximumFileSize) {
            LocalizationBundle bundle = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.attachment.multilang.attachment", (String)this.getUserPreferences().getLanguage());
            Object errorMessage = bundle.getString("attachment.dialog.errorFileSize") + " " + bundle.getString("attachment.dialog.maximumFileSize") + " (" + UnitUtil.formatMemSize((long)maximumFileSize) + ")";
            errorMessage = MessageFormat.format((String)errorMessage, fileName);
            MessageNotifier.addError((String)errorMessage, (Object[])new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(errorMessage).build());
        }
    }

    private void checkAuthorizedMimeTypes(String fileName) {
        String componentInstanceId = this.getComponentId();
        if (StringUtil.isDefined((String)componentInstanceId)) {
            ComponentFileFilterParameter componentFileFilter = ComponentFileFilterParameter.from((SilverpeasComponentInstance)this.getOrganisationController().getComponentInstance(componentInstanceId).orElse(null));
            try {
                componentFileFilter.verifyFileAuthorized(new File(fileName));
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e, Response.Status.PRECONDITION_FAILED);
            }
        }
    }

    private void checkSpecificComponentVerifications(FileUploadVerifyData fileUploadData, File uploadedFile) {
        String componentInstanceId = this.getComponentId();
        if (StringUtil.isDefined((String)componentInstanceId)) {
            try {
                Optional<ComponentInstanceFileUploadVerification> verification = ComponentInstanceFileUploadVerification.get(componentInstanceId);
                if (fileUploadData != null) {
                    verification.ifPresent(i -> i.verify(componentInstanceId, fileUploadData));
                } else {
                    verification.ifPresent(i -> i.verify(componentInstanceId, uploadedFile));
                }
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e, Response.Status.PRECONDITION_FAILED);
            }
        }
    }

    private UnaryOperator<JSONCodec.JSONObject> asJSON(UploadSessionFile uploadSessionFile) {
        return o -> o.put("uploadSessionId", uploadSessionFile.getUploadSession().getId()).put("fullPath", uploadSessionFile.getFullPath()).put("name", uploadSessionFile.getServerFile().getName()).put("size", Long.valueOf(uploadSessionFile.getServerFile().length())).put("formattedSize", UnitUtil.formatMemSize((BigDecimal)new BigDecimal(String.valueOf(uploadSessionFile.getServerFile().length())))).put("iconUrl", FileRepositoryManager.getFileIcon((String)FilenameUtils.getExtension((String)uploadSessionFile.getServerFile().getName())));
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response delete() {
        try {
            UploadSession uploadSession = UploadSession.from((HttpServletRequest)this.getHttpServletRequest());
            FileUploadData fileToDelete = FileUploadData.from(this.getHttpServletRequest());
            if (StringUtil.isDefined((String)fileToDelete.getFullPath())) {
                if (!uploadSession.remove(fileToDelete.getFullPath())) {
                    SilverLogger.getLogger((Object)((Object)this)).error("Trying to delete non existing file with session id '" + uploadSession.getId() + "' and fullPath '" + fileToDelete.getFullPath() + "'", new Object[0]);
                }
            } else {
                uploadSession.clear();
            }
            return Response.ok().build();
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return this.getHttpRequest().getHeader("X-COMPONENT-INSTANCE-ID");
    }
}

