/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.subscribe;

import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionFactory;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractSubscriptionResource
extends RESTWebService {
    @PathParam(value="componentId")
    private String componentId;

    public String getComponentId() {
        return this.componentId;
    }

    protected SubscriptionResourceType decodeSubscriptionResourceType(String type) {
        return SubscriptionResourceType.from((String)type.toUpperCase());
    }

    protected SubscriptionResource getSubscriptionResource(SubscriptionResourceType type, String resourceId) {
        if (type == null || !type.isValid()) {
            throw new WebApplicationException("type not found", Response.Status.BAD_REQUEST);
        }
        if (type != CommonSubscriptionResourceConstants.COMPONENT) {
            this.checkResourceId(resourceId);
        }
        return SubscriptionFactory.get().createSubscriptionResourceInstance(type, resourceId, null, this.componentId);
    }

    protected Subscription getSubscription(SubscriptionSubscriber subscriber, SubscriptionResourceType type, String resourceId) {
        if (type == null || !type.isValid()) {
            throw new WebApplicationException("type not found", Response.Status.BAD_REQUEST);
        }
        if (type != CommonSubscriptionResourceConstants.COMPONENT) {
            this.checkResourceId(resourceId);
        }
        SubscriptionResource resource = this.getSubscriptionResource(type, resourceId);
        return SubscriptionFactory.get().createSubscriptionInstance(subscriber, resource, this.getUser().getId());
    }

    private void checkResourceId(String resourceId) {
        if (StringUtil.isNotDefined((String)resourceId)) {
            throw new WebApplicationException("resource identifier not found", Response.Status.BAD_REQUEST);
        }
    }
}

