/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.publication;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.contribution.attachment.util.SharingContext;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.sharing.security.AccessControlContext;
import org.silverpeas.core.sharing.services.SharingServiceProvider;
import org.silverpeas.core.webapi.attachment.AttachmentEntity;
import org.silverpeas.core.webapi.publication.AbstractPublicationResource;
import org.silverpeas.core.webapi.publication.PublicationEntity;

@WebService
@Path(value="sharing/publications/{token}")
public class SharedPublicationResource
extends AbstractPublicationResource {
    static final String PATH = "sharing/publications";
    @PathParam(value="token")
    private String token;
    private Ticket ticket;

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return this.ticket.getComponentId();
    }

    @GET
    @Produces(value={"application/json"})
    public PublicationEntity getPublication() {
        this.ticket = this.getTicketByToken(this.token);
        PublicationPK pk = new PublicationPK(String.valueOf(this.ticket.getSharedObjectId()), this.getComponentId());
        PublicationDetail publication = super.getPublicationService().getDetail(pk);
        String baseUri = this.getUri().getBaseUri().toString();
        SharingContext context = new SharingContext(baseUri, this.token);
        PublicationEntity entity = super.getPublicationEntity(publication, true).withSharedContent(context);
        this.setSharedURIToAttachments(entity);
        return entity;
    }

    @GET
    @Path(value="node/{node}")
    @Produces(value={"application/json"})
    public List<PublicationEntity> listPublications(@PathParam(value="node") String nodeId, @QueryParam(value="withAttachments") boolean withAttachments) {
        this.ticket = this.getTicketByToken(this.token);
        List<PublicationEntity> publications = this.getPublications(nodeId, false, withAttachments);
        this.setSharedURIToAttachments(publications);
        return publications;
    }

    private void setSharedURIToAttachments(List<PublicationEntity> publications) {
        if (publications != null) {
            for (PublicationEntity publication : publications) {
                this.setSharedURIToAttachments(publication);
            }
        }
    }

    private void setSharedURIToAttachments(PublicationEntity publication) {
        List<AttachmentEntity> attachments = publication.getAttachments();
        if (attachments != null) {
            for (AttachmentEntity attachment : attachments) {
                attachment.withSharedUri(this.getUri().getBaseUri().toString(), this.token);
            }
        }
    }

    @Override
    protected boolean isNodeReadable(NodePK nodePK) {
        nodePK.setComponentName(this.getComponentId());
        NodeDetail node = this.getNodeService().getDetail(nodePK);
        return this.ticket.getAccessControl().isReadable(AccessControlContext.about((NodeDetail)node));
    }

    private Ticket getTicketByToken(String token) {
        Ticket theTicket = SharingServiceProvider.getSharingTicketService().getTicket(token);
        if (theTicket == null || !theTicket.isValid()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return theTicket;
    }
}

