/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.publication;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.attachment.AttachmentService;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.SimpleDocumentAccessControl;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.webapi.publication.PublicationEntity;

public abstract class AbstractPublicationResource
extends RESTWebService {
    protected List<PublicationEntity> getPublications(String nodeId, boolean includingAliases, boolean withAttachments) {
        NodePK nodePK = new NodePK(nodeId, this.getComponentId());
        if (!this.isNodeReadable(nodePK)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Collection publications = this.getPublicationService().getVisiblePublicationsIn(nodePK);
        ArrayList<PublicationEntity> entities = new ArrayList<PublicationEntity>();
        for (PublicationDetail publication : publications) {
            PublicationEntity entity;
            if (!includingAliases && publication.isAlias() || (entity = this.getPublicationEntity(publication, withAttachments)) == null) continue;
            entities.add(entity);
        }
        return entities;
    }

    protected PublicationEntity getPublicationEntity(PublicationDetail publication, boolean withAttachments) {
        if (publication.isValid()) {
            URI uri = this.getPublicationUri(publication);
            PublicationEntity entity = PublicationEntity.fromPublicationDetail(publication, uri);
            if (withAttachments) {
                AttachmentService attachmentService = AttachmentServiceProvider.getAttachmentService();
                SimpleDocumentList attachments = attachmentService.listDocumentsByForeignKey(publication.getPK().toResourceReference(), null);
                attachments.addAll(attachmentService.listDocumentsByForeignKeyAndType(publication.getPK().toResourceReference(), DocumentType.form, null));
                List<SimpleDocument> accessibleAttachments = attachments.stream().filter(this::isAttachmentAuthorized).collect(Collectors.toList());
                entity.withAttachments(accessibleAttachments);
            }
            return entity;
        }
        return null;
    }

    protected abstract boolean isNodeReadable(NodePK var1);

    private URI getPublicationUri(PublicationDetail publication) {
        return this.getUri().getAbsolutePathBuilder().path("publication").path(publication.getPK().getId()).build(new Object[0]);
    }

    protected NodeService getNodeService() {
        try {
            return NodeService.get();
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected PublicationService getPublicationService() {
        try {
            return PublicationService.get();
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean isAttachmentAuthorized(SimpleDocument attachment) {
        boolean authorized;
        if (this.isUserDefined()) {
            User user = this.getUser();
            authorized = SimpleDocumentAccessControl.get().isUserAuthorized(user.getId(), (Object)attachment, AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.DOWNLOAD}));
        } else {
            authorized = attachment.isDownloadAllowedForReaders();
        }
        return authorized;
    }
}

