/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.profile;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.webapi.profile.UserProfileEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class UserProfileExtendedEntity
extends UserProfileEntity {
    private static final long serialVersionUID = 3852818013944136146L;
    private final UserFull user;

    public static UserProfileExtendedEntity fromUser(UserFull user) {
        return new UserProfileExtendedEntity(user);
    }

    private UserProfileExtendedEntity(UserFull user) {
        super((UserDetail)user);
        this.user = user;
    }

    @Override
    public UserProfileExtendedEntity withAsUri(URI userUri) {
        super.withAsUri(userUri);
        return this;
    }

    @XmlElement
    public Map<String, String> getMoreLabelData() {
        String[] propertyNames = this.user.getPropertiesNames();
        Map labels = this.user.getSpecificLabels(this.getLanguage());
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String propertyName : propertyNames) {
            result.put(propertyName, (String)labels.get(propertyName));
        }
        result.putAll(PublicationTemplateManager.getInstance().getDirectoryFormLabels(this.user.getId(), this.user.getDomainId(), this.getLanguage()));
        return result;
    }

    @XmlElement
    public Map<String, String> getMoreData() {
        String[] propertyNames = this.user.getPropertiesNames();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String propertyName : propertyNames) {
            result.put(propertyName, this.user.getValue(propertyName));
        }
        result.putAll(this.user.getDefinedExtraFormValues(this.getLanguage()));
        return result;
    }

    public UserFull toUserFull() {
        return this.user;
    }

    protected UserProfileExtendedEntity() {
        this.user = new UserFull();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof UserProfileExtendedEntity) {
            return this.user.equals((Object)((UserProfileExtendedEntity)((Object)other)).user);
        }
        return this.user.equals(other);
    }

    @Override
    public int hashCode() {
        return this.user.hashCode();
    }
}

