/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.pdc;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.pdc.pdc.model.AxisValueCriterion;

public class PdcFilterCriteria {
    private List<String> componentInstanceIds;
    private String workspaceId;
    private Set<AxisValueCriterion> axisValues = new HashSet<AxisValueCriterion>();
    private boolean secondaryAxisInclusion = false;
    private UserDetail user;

    public PdcFilterCriteria onWorkspace(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    public PdcFilterCriteria onComponentInstances(List<String> instanceIds) {
        this.componentInstanceIds = instanceIds;
        return this;
    }

    public PdcFilterCriteria onAxisValue(AxisValueCriterion criterion) {
        this.axisValues.add(criterion);
        return this;
    }

    public PdcFilterCriteria onAxisValues(List<AxisValueCriterion> criteria) {
        this.axisValues.addAll(criteria);
        return this;
    }

    public PdcFilterCriteria onUser(UserDetail user) {
        this.user = user;
        return this;
    }

    public PdcFilterCriteria onSecondaryAxisInclusion(boolean includeSecondaryAxis) {
        this.secondaryAxisInclusion = includeSecondaryAxis;
        return this;
    }

    public boolean hasCriterionOnComponentInstance() {
        return this.componentInstanceIds != null;
    }

    public boolean hasCriterionOnWorkspace() {
        return this.workspaceId != null;
    }

    public boolean hasCriterionOnAxisValues() {
        return !this.axisValues.isEmpty();
    }

    public boolean hasCriterionOnUser() {
        return this.user != null;
    }

    public List<String> getComponentInstanceIds() {
        return this.componentInstanceIds;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public Set<AxisValueCriterion> getAxisValues() {
        return this.axisValues;
    }

    public UserDetail getUser() {
        return this.user;
    }

    public boolean hasSecondaryAxisToBeIncluded() {
        return this.secondaryAxisInclusion;
    }
}

