/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.notification.sse;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.sse.AbstractServerEvent;
import org.silverpeas.core.notification.sse.ServerEvent;
import org.silverpeas.core.notification.sse.ServerEventDispatcherTask;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContext;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContextManager;
import org.silverpeas.core.notification.sse.SseLogger;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.webapi.notification.sse.InitializationServerEvent;
import org.silverpeas.core.webapi.notification.sse.RetryServerEvent;
import org.silverpeas.kernel.util.Pair;

interface SilverpeasServerEventWebAccess {
    default public void prepareEventsOnOpening(WebAccessContext wac, Long initialLastServerEventId) {
        AbstractServerEvent serverEvent;
        Long lastServerEventId = initialLastServerEventId;
        String userSessionId = wac.getUserSessionId();
        if (lastServerEventId != null) {
            SseLogger.get().debug(() -> MessageFormat.format("Sending emitted events since disconnection for sessionId {0} on URI {1}", wac.getSessionId(), wac.getRequestURI()));
            serverEvent = RetryServerEvent.createFor(userSessionId, lastServerEventId);
            Pair result = ServerEventDispatcherTask.getLastServerEventsFromId((long)lastServerEventId);
            lastServerEventId = (Long)result.getFirst();
            wac.getNotConsumedServerEvent().addAll((Collection)result.getSecond());
        } else {
            serverEvent = InitializationServerEvent.createFor(userSessionId);
        }
        wac.setLastServerEventId(lastServerEventId);
        wac.setInitialServerEvent((ServerEvent)serverEvent);
    }

    default public void send(WebAccessContext wac, SilverpeasServerEventContext context) throws IOException {
        String sessionId = context.getSessionId();
        User user = context.getUser();
        ServerEvent initialServerEvent = wac.getInitialServerEvent();
        initialServerEvent.send(context, sessionId, user);
        for (ServerEvent toSendAgain : wac.getNotConsumedServerEvent()) {
            boolean sent = toSendAgain.send(context, sessionId, user);
            if (!sent) continue;
            SseLogger.get().debug(() -> MessageFormat.format("Send of not consumed {0}", toSendAgain));
        }
        if (NotificationManagerSettings.isCheckPreviousAsyncContextEnabled()) {
            Optional.of(initialServerEvent).filter(InitializationServerEvent.class::isInstance).stream().flatMap(s -> SilverpeasServerEventContextManager.get().getContextSnapshot().stream()).filter(c -> sessionId.equals(c.getSessionId())).forEach(SilverpeasServerEventContext::closeOnPreviousCheckFailure);
        }
        ServerEventDispatcherTask.registerContext((SilverpeasServerEventContext)context);
    }

    public static class WebAccessContext {
        private final String requestUri;
        private final String sessionId;
        private final String userSessionId;
        private final User user;
        private Long lastServerEventId = null;
        private final List<ServerEvent> notConsumedServerEvent = new ArrayList<ServerEvent>();
        private ServerEvent initialServerEvent = null;

        WebAccessContext(String requestUri, String sessionId, String userSessionId, User user) {
            this.requestUri = requestUri;
            this.sessionId = sessionId;
            this.userSessionId = userSessionId;
            this.user = user;
        }

        public String getRequestURI() {
            return this.requestUri;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getUserSessionId() {
            return this.userSessionId;
        }

        public User getUser() {
            return this.user;
        }

        public Long getLastServerEventId() {
            return this.lastServerEventId;
        }

        public void setLastServerEventId(Long lastServerEventId) {
            this.lastServerEventId = lastServerEventId;
        }

        public List<ServerEvent> getNotConsumedServerEvent() {
            return this.notConsumedServerEvent;
        }

        public ServerEvent getInitialServerEvent() {
            return this.initialServerEvent;
        }

        public void setInitialServerEvent(ServerEvent initialServerEvent) {
            this.initialServerEvent = initialServerEvent;
        }
    }
}

