/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.notification;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.notification.message.MessageManager;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.notification.AbstractMessageResource;
import org.silverpeas.core.webapi.notification.MessageContainerEntity;

@WebService
@Path(value="messages")
@Authenticated
public class MessageResource
extends AbstractMessageResource {
    protected String getResourceBasePath() {
        return "messages";
    }

    public void validateUserAuthentication(UserPrivilegeValidation validation) throws WebApplicationException {
        block2: {
            try {
                super.validateUserAuthentication(validation.skipLastUserAccessTimeRegistering(this.getHttpServletRequest()));
            }
            catch (WebApplicationException wae) {
                if (Response.Status.UNAUTHORIZED.getStatusCode() == wae.getResponse().getStatus()) break block2;
                throw wae;
            }
        }
    }

    @GET
    @Path(value="{registredKey}")
    @Produces(value={"application/json"})
    public MessageContainerEntity getMessageContainer(@PathParam(value="registredKey") String registredKey) {
        try {
            MessageContainerEntity messageContainerEntity = this.asWebEntity(MessageManager.getMessageContainer((String)registredKey));
            return messageContainerEntity;
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
        finally {
            MessageManager.clear((String)registredKey);
        }
    }
}

