/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.node;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.webapi.node.NodeType;
import org.silverpeas.core.webapi.profile.UserProfileEntity;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

@XmlRootElement
public class NodeAttrEntity {
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement(defaultValue="")
    private String id;
    @XmlElement(required=true)
    private String componentId;
    @XmlElement(defaultValue="")
    private URI childrenURI;
    @XmlElement(defaultValue="")
    private String nbItems;
    @XmlElement(defaultValue="")
    private String status;
    @XmlElement(defaultValue="0")
    private int order = 0;
    @XmlElement(defaultValue="")
    private String role;
    @XmlElement(defaultValue="")
    private String creatorId;
    @XmlElement
    private UserProfileEntity creator;
    @XmlElement(defaultValue="")
    private String description;
    @XmlElement(defaultValue="")
    private Date creationDate;
    @XmlElement
    private boolean specificRights;

    public NodeAttrEntity() {
    }

    public static NodeAttrEntity fromNodeDetail(NodeDetail node, URI uri, String lang) {
        return new NodeAttrEntity(node, uri, lang);
    }

    public static NodeAttrEntity fromNodeDetail(NodeDetail node, String uri, String lang) {
        return NodeAttrEntity.fromNodeDetail(node, NodeAttrEntity.toURI(uri), lang);
    }

    private NodeAttrEntity(NodeDetail node, URI uri, String lang) {
        this.componentId = node.getNodePK().getInstanceId();
        this.id = node.getNodePK().getId();
        this.uri = uri;
        if (node.getNbObjects() != -1) {
            this.nbItems = String.valueOf(node.getNbObjects());
        }
        this.status = node.getStatus();
        this.role = node.getUserRole();
        this.creatorId = node.getCreatorId();
        this.description = Encode.forHtml((String)node.getDescription(lang));
        UserDetail user = UserDetail.getById((String)node.getCreatorId());
        if (user != null) {
            this.creator = UserProfileEntity.fromUser((User)user);
        }
        this.creationDate = node.getCreationDate();
        if (!this.id.equalsIgnoreCase(NodeType.TO_VALIDATE.value()) && !this.id.equalsIgnoreCase(NodeType.NOT_VISIBLE_CONTRIBUTIONS.value())) {
            this.specificRights = node.haveLocalRights();
        }
    }

    private static URI toURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException ex) {
            SilverLogger.getLogger(NodeAttrEntity.class).error(ex.getMessage(), (Throwable)ex);
            throw new SilverpeasRuntimeException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setChildrenURI(URI childrenURI) {
        this.childrenURI = childrenURI;
    }

    public URI getChildrenURI() {
        return this.childrenURI;
    }

    public void setNbItems(String nbItems) {
        this.nbItems = nbItems;
    }

    public String getNbItems() {
        return this.nbItems;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setCreator(UserProfileEntity creator) {
        this.creator = creator;
    }

    public UserProfileEntity getCreator() {
        return this.creator;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public boolean isSpecificRights() {
        return this.specificRights;
    }

    public void setSpecificRights(boolean specificRights) {
        this.specificRights = specificRights;
    }
}

