/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.media;

import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.plugins.providers.html.View;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.io.media.Definition;
import org.silverpeas.core.web.http.RequestParameterDecoder;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.webapi.media.EmbedMediaPlayerParams;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="media/player/embed")
public class EmbedMediaPlayerResource
extends RESTWebService {
    private static final int DEFAULT_WIDTH = 600;
    private static final int DEFAULT_HEIGHT = 400;
    static final String PATH = "media/player/embed";

    protected String getResourceBasePath() {
        return PATH;
    }

    @GET
    public View getEmbedContent() {
        EmbedMediaPlayerParams params = (EmbedMediaPlayerParams)RequestParameterDecoder.decode((ServletRequest)this.getHttpServletRequest(), EmbedMediaPlayerParams.class);
        try {
            this.checkMandatoryParams(params);
            Definition definition = params.getDefinition();
            if (definition == Definition.NULL) {
                definition = Definition.of((int)600, (int)400);
            }
            this.getHttpServletRequest().setAttribute("mediaUrl", (Object)params.getUrl());
            this.getHttpServletRequest().setAttribute("posterUrl", (Object)params.getPosterUrl());
            this.getHttpServletRequest().setAttribute("playerType", (Object)params.getPlayerType());
            this.getHttpServletRequest().setAttribute("mimeType", (Object)params.getMimeType());
            this.getHttpServletRequest().setAttribute("definition", (Object)definition);
            this.getHttpServletRequest().setAttribute("backgroundColor", (Object)params.getBackgroundColor());
            this.getHttpServletRequest().setAttribute("autoPlay", (Object)params.getAutoPlay());
            return new View("/media/jsp/embed.jsp");
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    public String getComponentId() {
        return null;
    }

    private void checkMandatoryParams(EmbedMediaPlayerParams params) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (StringUtil.isNotDefined((String)params.getUrl())) {
            errorMessages.add("url is not defined");
        }
        if (StringUtil.isNotDefined((String)params.getMimeType())) {
            errorMessages.add("player type is not defined");
        }
        if (!"video".equals(params.getPlayerType()) && !"audio".equals(params.getPlayerType())) {
            errorMessages.add("player type is not rightly defined");
        }
        if (!errorMessages.isEmpty()) {
            throw new WebApplicationException(errorMessages.stream().collect(Collectors.joining(", ")), Response.Status.BAD_REQUEST);
        }
    }
}

