/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.attachment;

import java.util.Optional;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class AbstractAttachmentResource
extends RESTWebService {
    @PathParam(value="componentId")
    protected String componentId;

    public String getComponentId() {
        return this.componentId;
    }

    protected Response getAttachmentContent(String attachmentId) {
        SimpleDocument attachment = AttachmentServiceProvider.getAttachmentService().searchDocumentById(new SimpleDocumentPK(attachmentId), null);
        if (attachment == null) {
            SilverLogger.getLogger((Object)((Object)this)).warn("Resource not found from request {0} with user {1}", new Object[]{this.getHttpRequest().getRequestURI(), Optional.ofNullable(this.getUser()).map(User::getId).orElse("N/A")});
            return Response.noContent().status(Response.Status.NOT_FOUND).build();
        }
        SimpleDocument lastPublicVersion = attachment.getLastPublicVersion();
        if (!this.isFileReadable(lastPublicVersion)) {
            SilverLogger.getLogger((Object)((Object)this)).warn("Resource not authorized from request {0} with user {1}", new Object[]{this.getHttpRequest().getRequestURI(), Optional.ofNullable(this.getUser()).map(User::getId).orElse("N/A")});
            return Response.noContent().status(Response.Status.UNAUTHORIZED).build();
        }
        StreamingOutput data = output -> {
            try {
                AttachmentServiceProvider.getAttachmentService().getBinaryContent(output, lastPublicVersion.getPk(), lastPublicVersion.getLanguage());
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
            }
        };
        return Response.ok().entity((Object)data).type(lastPublicVersion.getContentType()).build();
    }

    protected abstract boolean isFileReadable(SimpleDocument var1);
}

