/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.list;

import java.io.Serializable;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.div;
import org.silverpeas.core.web.util.viewgenerator.html.buttonpanes.ButtonPaneTag;
import org.silverpeas.core.web.util.viewgenerator.html.buttons.ButtonTag;
import org.silverpeas.core.web.util.viewgenerator.html.list.AbstractListPaneTag;
import org.silverpeas.kernel.util.StringUtil;

public class AccumulativeListPaneTag
extends AbstractListPaneTag {
    private static final long serialVersionUID = -237212701930752379L;
    static final String NEXT_PARAMETER_NAME = "AccListNextAction";
    private String targetListId;
    private String nextActionLabel;
    private int batchSize = 10;
    private boolean moreItems = false;

    public void setTargetListId(String targetListId) {
        this.targetListId = targetListId;
        this.setId(targetListId + "-pane");
    }

    public void setNextActionLabel(String nextActionLabel) {
        this.nextActionLabel = nextActionLabel;
    }

    String getNextActionLabel() {
        return this.nextActionLabel;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    void setMoreItems(boolean moreItems) {
        this.moreItems = moreItems;
    }

    @Override
    public int doStartTag() throws JspException {
        if (!StringUtil.getBooleanValue((String)this.getRequest().getParameter(NEXT_PARAMETER_NAME))) {
            this.clearState();
        }
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        div listPane = new div();
        listPane.setID(this.getId());
        listPane.setClass("acc-list-pane");
        listPane.addElement(this.getBodyContent().getString());
        if (this.moreItems) {
            listPane.addElement((Element)this.getActionPane());
        }
        new ElementContainer().addElement((Element)listPane).output((Writer)this.pageContext.getOut());
        return super.doEndTag();
    }

    private ElementContainer getActionPane() throws JspException {
        State state = this.getState();
        String baseUrl = this.getRoutingAddress();
        StringBuilder url = new StringBuilder(baseUrl);
        if (baseUrl.indexOf(63) < 0) {
            url.append("?");
        } else {
            url.append("&");
        }
        url.append(NEXT_PARAMETER_NAME).append("=true");
        url.append("&").append("ItemsPerPage").append("=").append(state.getBatchSize());
        url.append("&").append("PaginationPaneIndex").append("=").append(state.getNextStartIndex());
        String nextAction = String.format("sp.accListPane.nextItems('%s', '%s')", url, this.targetListId);
        ButtonPaneTag buttonPaneTag = new ButtonPaneTag();
        buttonPaneTag.setPageContext(this.pageContext);
        buttonPaneTag.setParent((Tag)this);
        buttonPaneTag.setCssClass("acc-list-pane-actions");
        ButtonTag buttonTag = new ButtonTag();
        buttonTag.setPageContext(this.pageContext);
        buttonTag.setParent((Tag)buttonPaneTag);
        buttonTag.setClasses("acc-list-pane-next-action");
        buttonTag.setLabel(this.getNextActionLabel());
        buttonTag.setAction("javascript:" + nextAction);
        buttonTag.doEndTag();
        return buttonPaneTag.getContent();
    }

    State getState() {
        String sessionKey = ((Object)((Object)this)).getClass().getSimpleName() + this.getVar();
        State state = (State)this.getSession().getAttribute(sessionKey);
        if (state == null) {
            state = new State(this.batchSize);
            this.getSession().setAttribute(sessionKey, (Object)state);
        }
        return state;
    }

    private void clearState() {
        String sessionKey = ((Object)((Object)this)).getClass().getSimpleName() + this.getVar();
        this.getSession().removeAttribute(sessionKey);
    }

    static class State
    implements Serializable {
        private static final long serialVersionUID = 2766488468504645179L;
        private final int batchSize;
        private int currentListSize = -1;
        private int currentStartIndex = -1;
        private int nextStartIndex = -1;

        State(int batchSize) {
            this.batchSize = batchSize;
        }

        int getBatchSize() {
            return this.batchSize;
        }

        int getCurrentListSize() {
            return this.currentListSize;
        }

        void setCurrentListSize(int currentListSize) {
            this.currentListSize = currentListSize;
        }

        int getCurrentStartIndex() {
            return this.currentStartIndex;
        }

        void setCurrentStartIndex(int previousStartIndex) {
            this.currentStartIndex = previousStartIndex;
        }

        int getNextStartIndex() {
            return this.nextStartIndex;
        }

        void setNextStartIndex(int nextStartIndex) {
            this.nextStartIndex = nextStartIndex;
        }

        boolean isFirstDisplay() {
            return this.currentListSize == -1;
        }
    }
}

