/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.UriBuilder;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.script;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.look.LookHelper;
import org.silverpeas.core.web.look.SilverpeasLook;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.web.util.viewgenerator.html.JavascriptPluginInclusion;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

class WebCommonLookAndFeel {
    public static final String LOOK_CONTEXT_MANAGER_CALLBACK_ONLY_ATTR = "lookContextManagerCallbackOnly";
    public static final String NO_LOOK_CONTEXT_MANAGER_CALLBACK_ATTR = "noLookContextManagerCallback";
    private static final String SILVERPEAS_JS = "silverpeas.js";
    private static final String STANDARD_CSS = "/util/styleSheets/silverpeas-main.css";
    private static final String STR_NEW_LINE = "\n";
    private static final WebCommonLookAndFeel instance = new WebCommonLookAndFeel();
    private static final String LOOK_CONTEXT_MANAGER_SPACE_ID = "LookContextManager.spaceId";
    private static final String LOOK_CONTEXT_MANAGER_COMPONENT_ID = "LookContextManager.componentId";

    private WebCommonLookAndFeel() {
    }

    public static WebCommonLookAndFeel getInstance() {
        return instance;
    }

    String getCommonHeader(HttpServletRequest req) {
        String componentId;
        String spaceId;
        HttpRequest request = HttpRequest.decorate((HttpServletRequest)req);
        HttpSession session = request.getSession();
        MainSessionController controller = (MainSessionController)session.getAttribute("SilverSessionController");
        GraphicElementFactory gef = (GraphicElementFactory)session.getAttribute("SessionGraphicElementFactory");
        String[] context = (String[])request.getAttribute("browseContext");
        String lookContextManagerSpaceId = request.getParameter(LOOK_CONTEXT_MANAGER_SPACE_ID);
        if (StringUtil.isDefined((String)lookContextManagerSpaceId)) {
            spaceId = lookContextManagerSpaceId;
            componentId = request.getParameter(LOOK_CONTEXT_MANAGER_COMPONENT_ID);
        } else if (this.isDefined(context)) {
            spaceId = context[2];
            componentId = context[3];
        } else if (context != null) {
            spaceId = null;
            componentId = null;
        } else {
            spaceId = gef.getSpaceIdOfCurrentRequest();
            componentId = gef.getComponentIdOfCurrentRequest();
        }
        if (request.getAttributeAsBoolean(LOOK_CONTEXT_MANAGER_CALLBACK_ONLY_ATTR) && !request.getAttributeAsBoolean(NO_LOOK_CONTEXT_MANAGER_CALLBACK_ATTR)) {
            return Optional.of(this.generateSpWindowLookContextUpdate(controller, this.getLookSettings(controller, spaceId), spaceId, componentId)).filter(StringUtil::isDefined).map(JavascriptPluginInclusion::scriptContent).map(Object::toString).orElse("");
        }
        return this.getCommonHeader(request, controller, spaceId, componentId);
    }

    private boolean isDefined(String[] context) {
        return context != null && StringUtil.isDefined((String)String.join((CharSequence)"", context));
    }

    private String getCommonHeader(HttpRequest request, MainSessionController controller, String spaceId, String componentId) {
        String cssUploadedOnSpace;
        String language = controller.getFavoriteLanguage();
        SettingBundle lookSettings = this.getLookSettings(controller, spaceId);
        String silverpeasUrl = URLUtil.getFullApplicationURL((HttpServletRequest)request);
        String contextPath = ResourceLocator.getGeneralSettingBundle().getString("ApplicationURL");
        String charset = ResourceLocator.getGeneralSettingBundle().getString("charset", Charsets.UTF_8.name());
        StringBuilder code = new StringBuilder();
        code.append("<link rel=\"icon\" href=\"").append(lookSettings.getString("favicon", request.getContextPath() + "/util/icons/favicon.ico")).append("\"/>");
        code.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
        code.append(charset);
        code.append("\"/>\n");
        code.append(JavascriptPluginInclusion.includeJQueryCss(new ElementContainer()));
        code.append(this.getCSSLinkTag(contextPath + STANDARD_CSS));
        Mutable specificJS = Mutable.empty();
        Mutable defaultComponentCSS = Mutable.empty();
        Mutable specificComponentCSS = Mutable.empty();
        this.computeComponentStuffs(lookSettings, contextPath, componentId, (Mutable<String>)specificJS, (Mutable<String>)defaultComponentCSS, (Mutable<String>)specificComponentCSS);
        defaultComponentCSS.ifPresent(code::append);
        String css = lookSettings.getString("StyleSheet", "");
        if (StringUtil.isDefined((String)css)) {
            code.append(this.getCSSLinkTag(css));
        }
        if (StringUtil.isDefined((String)spaceId) && StringUtil.isDefined((String)(cssUploadedOnSpace = SilverpeasLook.getSilverpeasLook().getCSSOfSpace(spaceId)))) {
            code.append(this.getCSSLinkTag(cssUploadedOnSpace));
        }
        specificComponentCSS.ifPresent(code::append);
        code.append(JavascriptPluginInclusion.includePolyfills(new ElementContainer())).append(STR_NEW_LINE);
        code.append(this.getJavaScriptTag(contextPath + "/util/javaScript/mousetrap.min.js"));
        code.append(this.getJavaScriptTag(contextPath + "/util/javaScript/mousetrap-global-bind.min.js"));
        code.append(this.getJavaScriptTag(contextPath + "/util/javaScript/mousetrap-pause.min.js"));
        code.append(this.getJavaScriptTag(contextPath + "/util/javaScript/moment-with-locales.min.js"));
        code.append(this.getJavaScriptTag(contextPath + "/util/javaScript/moment-timezone-with-data.min.js"));
        code.append("<script type=\"text/javascript\">var webContext='").append(contextPath).append("';").append(STR_NEW_LINE).append("var silverpeasUrl = '").append(silverpeasUrl).append("';").append(STR_NEW_LINE);
        if (request.getRequestURI().endsWith(lookSettings.getString("FrameJSP"))) {
            code.append("var __spWindow_main_frame = true;").append(STR_NEW_LINE);
        }
        code.append(this.addGlobalJSVariable(controller)).append("</script>\n");
        code.append(this.getJavaScriptTagWithVersion(contextPath + "/util/javaScript/silverpeas.js"));
        code.append(JavascriptPluginInclusion.includeJQuery(new ElementContainer())).append(STR_NEW_LINE);
        code.append(this.getJavaScriptTag(contextPath + "/util/javaScript/silverpeas-i18n.js"));
        code.append(this.getJavaScriptTag(contextPath + "/util/javaScript/jquery/jquery.cookie.js"));
        code.append(JavascriptPluginInclusion.includeChat(new ElementContainer())).append(STR_NEW_LINE);
        code.append(JavascriptPluginInclusion.includeLayout(new ElementContainer(), LookHelper.getLookHelper(controller.getHttpSession())).toString()).append(STR_NEW_LINE);
        if (!request.getAttributeAsBoolean(NO_LOOK_CONTEXT_MANAGER_CALLBACK_ATTR)) {
            Optional.of(this.generateSpWindowLookContextUpdate(controller, lookSettings, spaceId, componentId)).filter(StringUtil::isDefined).ifPresent(c -> code.append(JavascriptPluginInclusion.scriptContent(c)));
        }
        code.append(JavascriptPluginInclusion.includeAngular(new ElementContainer(), language)).append(STR_NEW_LINE);
        code.append(JavascriptPluginInclusion.includeVueJs(new ElementContainer())).append(STR_NEW_LINE);
        code.append(JavascriptPluginInclusion.includeA11y(new ElementContainer(), language)).append(STR_NEW_LINE);
        code.append(JavascriptPluginInclusion.includeSecurityTokenizing(new ElementContainer())).append(STR_NEW_LINE);
        code.append(JavascriptPluginInclusion.includeNotifier(new ElementContainer())).append(STR_NEW_LINE);
        code.append(JavascriptPluginInclusion.includeSelectize(new ElementContainer())).append(STR_NEW_LINE);
        code.append(JavascriptPluginInclusion.includePopup(new ElementContainer())).append(STR_NEW_LINE);
        code.append(JavascriptPluginInclusion.includeUserZoom(new ElementContainer(), language)).append(STR_NEW_LINE);
        code.append(JavascriptPluginInclusion.includeCkeditorAddOns(new ElementContainer())).append(STR_NEW_LINE);
        code.append(JavascriptPluginInclusion.includeMessager(new ElementContainer(), language)).append(STR_NEW_LINE);
        specificJS.ifPresent(code::append);
        if (lookSettings.getString("OperationPane").toLowerCase().endsWith("web20")) {
            code.append(this.getYahooElements());
            code.append(JavascriptPluginInclusion.includeResponsibles(new ElementContainer(), language)).append(STR_NEW_LINE);
            code.append(JavascriptPluginInclusion.includeMylinks(new ElementContainer())).append(STR_NEW_LINE);
        }
        code.append(JavascriptPluginInclusion.includeVirtualKeyboard(new ElementContainer(), language)).append(STR_NEW_LINE);
        return code.toString();
    }

    private String generateSpWindowLookContextUpdate(MainSessionController controller, SettingBundle lookSettings, String spaceId, String componentId) {
        String wallpaper;
        String css;
        String look;
        List spacePathIds;
        StringBuilder code = new StringBuilder();
        String mainFrameUrl = Optional.of(lookSettings.getString("FrameJSP")).map(f -> {
            Object url = f;
            if (StringUtil.isDefined((String)spaceId)) {
                url = UriBuilder.fromUri((String)url).queryParam(LOOK_CONTEXT_MANAGER_SPACE_ID, new Object[]{spaceId}).build(new Object[0]).toString();
            }
            if (StringUtil.isDefined((String)componentId)) {
                url = UriBuilder.fromUri((String)url).queryParam(LOOK_CONTEXT_MANAGER_COMPONENT_ID, new Object[]{componentId}).build(new Object[0]).toString();
            }
            if (!((String)url).startsWith(URLUtil.getApplicationURL())) {
                url = URLUtil.getApplicationURL() + (String)(((String)url).startsWith("/") ? url : "/" + (String)url);
            }
            return url;
        }).orElse(null);
        String defaultLook = controller.getFavoriteLook();
        if (StringUtil.isDefined((String)spaceId)) {
            spacePathIds = OrganizationController.get().getPathToSpace(spaceId).stream().map(SpaceInstLight::getId).collect(Collectors.toList());
            SilverpeasLook silverpeasLook = SilverpeasLook.getSilverpeasLook();
            look = StringUtil.defaultStringIfNotDefined((String)silverpeasLook.getSpaceLook(spaceId), (String)defaultLook);
            css = Optional.ofNullable(silverpeasLook.getCSSOfSpace(spaceId)).map(JavascriptPluginInclusion::normalizeWebResourceUrl).orElse(null);
            wallpaper = Optional.ofNullable(silverpeasLook.getWallpaperOfSpace(spaceId)).map(JavascriptPluginInclusion::normalizeWebResourceUrl).orElse(null);
        } else {
            spacePathIds = Collections.emptyList();
            look = defaultLook;
            css = null;
            wallpaper = null;
        }
        code.append("if(top.spWindow){");
        code.append("top.spWindow.updateLookContext(");
        code.append(JSONCodec.encodeObject(o -> o.put("mainFrameUrl", mainFrameUrl).putJSONArray("currentSpacePathIds", a2 -> {
            spacePathIds.forEach(arg_0 -> ((JSONCodec.JSONArray)a2).add(arg_0));
            return a2;
        }).put("currentComponentId", StringUtil.defaultStringIfNotDefined((String)componentId)).put("defaultLook", defaultLook).put("look", look).put("bannerHeight", lookSettings.getString("banner.height", "115") + "px").put("footerHeight", lookSettings.getString("footer.height", "26") + "px").put("css", css).put("wallpaper", wallpaper).put("defaultWallpaper", Optional.ofNullable(lookSettings.getString("banner.wallPaper", null)).filter(StringUtil::isDefined).orElse("imgDesign/bandeau.jpg"))));
        code.append(");}");
        code.append(STR_NEW_LINE);
        return code.toString();
    }

    private void computeComponentStuffs(SettingBundle lookSettings, String contextPath, String componentId, Mutable<String> specificJS, Mutable<String> defaultComponentCSS, Mutable<String> specificComponentCSS) {
        SilverpeasComponentInstance component;
        if (StringUtil.isDefined((String)componentId) && (component = (SilverpeasComponentInstance)OrganizationControllerProvider.getOrganisationController().getComponentInstance(componentId).orElse(null)) != null) {
            String specificJs;
            String componentName = component.getName();
            String genericComponentName = this.getGenericComponentName(componentName);
            if (component.isWorkflow()) {
                genericComponentName = "processManager";
            }
            defaultComponentCSS.set((Object)this.getCSSLinkTag(contextPath + "/" + genericComponentName + "/jsp/styleSheets/" + genericComponentName + ".css"));
            String specificStyle = lookSettings.getString("StyleSheet." + componentName, "");
            if (StringUtil.isDefined((String)specificStyle)) {
                specificComponentCSS.set((Object)this.getCSSLinkTag(specificStyle));
            }
            if (StringUtil.isDefined((String)(specificJs = lookSettings.getString("JavaScript." + componentName, "")))) {
                specificJS.set((Object)this.getJavaScriptTagWithVersion(specificJs));
            }
        }
    }

    private SettingBundle getLookSettings(MainSessionController controller, String spaceId) {
        String spaceLook;
        String userLookName = controller.getFavoriteLook();
        SettingBundle lookSettings = GraphicElementFactory.getLookSettings(userLookName);
        if (StringUtil.isDefined((String)spaceId) && StringUtil.isDefined((String)(spaceLook = SilverpeasLook.getSilverpeasLook().getSpaceLook(spaceId)))) {
            lookSettings = GraphicElementFactory.getLookSettings(spaceLook);
        }
        return lookSettings;
    }

    private String getCSSLinkTag(String href) {
        return JavascriptPluginInclusion.link(href).toString();
    }

    private String getJavaScriptTag(String src) {
        String normalizedUrl = URLUtil.getMinifiedWebResourceUrl((String)src);
        return new script().setType("text/javascript").setSrc(normalizedUrl).toString() + STR_NEW_LINE;
    }

    private String getJavaScriptTagWithVersion(String src) {
        String normalizedUrl = URLUtil.getMinifiedWebResourceUrl((String)src);
        return this.getJavaScriptTag(URLUtil.addFingerprintVersionOn((String)normalizedUrl));
    }

    private String getGenericComponentName(String componentName) {
        if ("toolbox".equalsIgnoreCase(componentName) || "kmax".equalsIgnoreCase(componentName)) {
            return "kmelia";
        }
        if ("pollingstation".equalsIgnoreCase(componentName)) {
            return "survey";
        }
        return componentName;
    }

    private String addGlobalJSVariable(MainSessionController controller) {
        String language = controller.getFavoriteLanguage();
        ZoneId zoneId = controller.getFavoriteZoneId();
        StringBuilder globalJSVariableBuilder = new StringBuilder();
        globalJSVariableBuilder.append("moment.locale('").append(language).append("');").append(STR_NEW_LINE);
        globalJSVariableBuilder.append("var userLanguage = '").append(language).append("';").append(STR_NEW_LINE);
        globalJSVariableBuilder.append("function getUserLanguage() { return userLanguage;").append(" }").append(STR_NEW_LINE);
        globalJSVariableBuilder.append("function getString(key) { return sp.i18n.get(key); }").append(STR_NEW_LINE);
        globalJSVariableBuilder.append("var currentUserId = '").append(controller.getUserId()).append("';").append(STR_NEW_LINE);
        globalJSVariableBuilder.append("var currentUser = ").append(JSONCodec.encodeObject(j -> {
            UserDetail currentUserDetail = controller.getCurrentUserDetail();
            if (currentUserDetail != null) {
                j.put("id", currentUserDetail.getId()).put("domainId", currentUserDetail.getDomainId()).put("language", language).put("zoneId", zoneId.getId());
            }
            return j;
        })).append(";").append(STR_NEW_LINE);
        return globalJSVariableBuilder.toString();
    }

    private String getYahooElements() {
        String contextPath = ResourceLocator.getGeneralSettingBundle().getString("ApplicationURL");
        StringBuilder code = new StringBuilder();
        code.append("<!-- CSS for Menu -->\n");
        code.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        code.append(GraphicElementFactory.getSettings().getString("YUIMenuCss", contextPath + "/util/yui/menu/assets/menu.css"));
        code.append("\"/>\n");
        code.append("<!-- Page-specific styles -->\n");
        code.append("<style type=\"text/css\">\n");
        code.append("    div.yuimenu {\n");
        code.append("    position:dynamic;\n");
        code.append("    visibility:hidden;\n");
        code.append("    }\n");
        code.append("</style>\n");
        code.append(this.getJavaScriptTag(contextPath + "/util/yui/yahoo-dom-event/yahoo-dom-event.js"));
        code.append(this.getJavaScriptTag(contextPath + "/util/yui/container/container_core-min.js"));
        code.append(this.getJavaScriptTag(contextPath + "/util/yui/menu/menu-min.js"));
        return code.toString();
    }
}

