/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.Input;
import org.apache.ecs.html.Label;
import org.apache.ecs.html.Option;
import org.apache.ecs.html.Select;
import org.apache.ecs.html.Span;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.i18n.I18NLanguage;
import org.silverpeas.kernel.bundle.ResourceLocator;

public class LanguageSelectorTag
extends TagSupport {
    private static final long serialVersionUID = -6521946554686125224L;
    private String currentLangCode = I18NHelper.DEFAULT_LANGUAGE;
    private String elementId;
    private String elementName;
    private boolean includeLabel;
    private boolean readOnly = false;

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public void setIncludeLabel(boolean includeLabel) {
        this.includeLabel = includeLabel;
    }

    public String getLangCode() {
        return this.currentLangCode;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int doStartTag() throws JspException {
        ElementContainer xhtml = new ElementContainer();
        if (I18NHelper.isI18nContentActivated) {
            Span langElement;
            String userLanguage = null;
            Locale locale = (Locale)Config.find((PageContext)this.pageContext, (String)"javax.servlet.jsp.jstl.fmt.locale");
            if (locale != null) {
                userLanguage = locale.getLanguage();
            }
            if (!this.isReadOnly()) {
                Select langSelector = new Select();
                langSelector.setID(this.elementId);
                langSelector.setName(this.elementName);
                ArrayList<Option> options = new ArrayList<Option>(I18NHelper.getNumberOfLanguages());
                for (I18NLanguage language : I18NHelper.getAllUserTranslationsOfContentLanguages((String)userLanguage)) {
                    Option option = new Option(language.getLabel(), language.getCode());
                    option.addElement(language.getLabel());
                    if (this.getLangCode().equalsIgnoreCase(language.getCode())) {
                        option.setSelected(true);
                    }
                    options.add(option);
                }
                langSelector.addElement(options.toArray(new Option[options.size()]));
                langElement = langSelector;
            } else {
                Span readOnlyLanguage = new Span();
                readOnlyLanguage.setID(this.elementId);
                readOnlyLanguage.addElement(I18NHelper.getLanguageLabel((String)this.getLangCode(), (String)userLanguage));
                langElement = readOnlyLanguage;
            }
            if (this.includeLabel) {
                Label label = new Label(this.elementId);
                label.setStyle("margin-right: 5px");
                label.addElement(ResourceLocator.getGeneralLocalizationBundle((String)userLanguage).getString("GML.language"));
                xhtml.addElement((Element)label);
            }
            xhtml.addElement((Element)langElement);
        } else {
            Input hidden = new Input();
            hidden.setID(this.elementId);
            hidden.setName(this.elementName);
            hidden.setType("hidden");
            xhtml.addElement((Element)hidden);
        }
        xhtml.output((Writer)this.pageContext.getOut());
        return 0;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    public void setLangCode(String currentLang) {
        this.currentLangCode = I18NHelper.checkLanguage((String)currentLang);
    }
}

