/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.portlets.context.window.impl;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.EntityID;
import com.sun.portal.container.PortletLang;
import com.sun.portal.container.PortletType;
import com.sun.portal.container.PortletWindowContext;
import com.sun.portal.container.PortletWindowContextException;
import com.sun.portal.container.service.EventHolder;
import com.sun.portal.container.service.PortletDescriptorHolder;
import com.sun.portal.container.service.PortletDescriptorHolderFactory;
import com.sun.portal.container.service.PublicRenderParameterHolder;
import com.sun.portal.container.service.policy.DistributionType;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryContext;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryContextAbstractFactory;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryContextFactory;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.web.portlets.context.window.impl.PortletPreferencesImpl;
import org.silverpeas.kernel.util.StringUtil;

public class PortletWindowContextImpl
implements PortletWindowContext {
    private PortletRegistryContext portletRegistryContext;
    private HttpServletRequest request;
    private static final String ENC = "UTF-8";
    private static final String PORTLET_HANDLE_PREF_NAME = "portletHandle";
    private static String AUTHLESS_USER_ID = "NONE";
    private static final String IS_WSRP_REQ = "is.wsrp.request";
    private static final Logger logger = ContainerLogger.getLogger(PortletWindowContextImpl.class, (String)"org.silverpeas.portlets.PCCTXLogMessages");
    private static List<String> roles = Arrays.asList("role1", "role2", "role3", "role4", "role5", "role6", "role7", "role8", "role9");
    private String elementId = null;

    public PortletWindowContextImpl() {
    }

    public PortletWindowContextImpl(String userID) {
        this.elementId = userID;
    }

    public void init(HttpServletRequest request) {
        String spaceId;
        this.request = request;
        this.elementId = spaceId = (String)request.getAttribute("SpaceId");
        if (!StringUtil.isDefined((String)this.elementId)) {
            this.elementId = (String)request.getAttribute("UserId");
        }
        try {
            PortletRegistryContextAbstractFactory afactory = new PortletRegistryContextAbstractFactory();
            PortletRegistryContextFactory factory = afactory.getPortletRegistryContextFactory();
            this.portletRegistryContext = factory.getPortletRegistryContext(this.elementId);
        }
        catch (PortletRegistryException pre) {
            logger.log(Level.SEVERE, "PSPL_PCCTXCSPPCI0012", pre);
        }
    }

    public String getDesktopURL(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        return requestURL.toString();
    }

    public String getDesktopURL(HttpServletRequest request, String query, boolean escape) {
        StringBuilder urlBuffer = new StringBuilder(this.getDesktopURL(request));
        if (query != null && query.length() != 0) {
            urlBuffer.append("?").append(query);
        }
        String url = urlBuffer.toString();
        if (escape) {
            try {
                url = URLEncoder.encode(url, ENC);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return url;
    }

    public String getLocaleString() {
        Locale locale = this.request.getLocale();
        return locale.toString();
    }

    public String getContentType() {
        String contentType = "text/html";
        return contentType;
    }

    public String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, ENC);
        }
        catch (UnsupportedEncodingException usee) {
            return url;
        }
    }

    public boolean isAuthless(HttpServletRequest request) {
        return false;
    }

    public String getAuthenticationType() {
        return this.request.getAuthType();
    }

    public Object getProperty(String name) {
        HttpSession session;
        Object value = null;
        if (this.request != null && (session = this.request.getSession(false)) != null) {
            value = session.getAttribute(name);
        }
        return value;
    }

    public void setProperty(String name, Object value) {
        if (this.request != null) {
            this.request.getSession(true).setAttribute(name, value);
        }
    }

    public List getRoles() {
        ArrayList<String> currentRoles = new ArrayList<String>();
        for (String role : roles) {
            if (!this.request.isUserInRole(role)) continue;
            currentRoles.add(role);
        }
        return currentRoles;
    }

    public Map<String, String> getUserInfo() {
        return Collections.EMPTY_MAP;
    }

    public List getMarkupTypes(String portletName) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getMarkupTypes(portletName);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public String getDescription(String portletName, String desiredLocale) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getDescription(portletName, desiredLocale);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public String getShortTitle(String portletName, String desiredLocale) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getShortTitle(portletName, desiredLocale);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public String getTitle(String portletName, String desiredLocale) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getTitle(portletName, desiredLocale);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public List getKeywords(String portletName, String desiredLocale) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getKeywords(portletName, desiredLocale);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public String getDisplayName(String portletName, String desiredLocale) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getDisplayName(portletName, desiredLocale);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public String getPortletName(String portletWindowName) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getPortletName(portletWindowName);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public List<EntityID> getPortletWindows(PortletType portletType, DistributionType distributionType) throws PortletWindowContextException {
        ArrayList<EntityID> portletList = new ArrayList<EntityID>();
        try {
            List portlets = null;
            if (DistributionType.ALL_PORTLETS.equals((Object)distributionType)) {
                portlets = this.getAllPortletWindows(portletType);
            } else if (DistributionType.ALL_PORTLETS_ON_PAGE.equals((Object)distributionType)) {
                portlets = this.getAvailablePortletWindows(portletType);
            } else if (DistributionType.VISIBLE_PORTLETS_ON_PAGE.equals((Object)distributionType)) {
                portlets = this.getVisiblePortletWindows(portletType);
            }
            if (portlets != null) {
                for (String portletWindowName : portlets) {
                    portletList.add(this.getEntityID(portletWindowName));
                }
            }
        }
        catch (PortletWindowContextException pre) {
            logger.log(Level.SEVERE, "PSPL_PCCTXCSPPCI0011", pre);
        }
        return portletList;
    }

    private List getVisiblePortletWindows(PortletType portletType) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getVisiblePortletWindows(portletType);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    private List getAvailablePortletWindows(PortletType portletType) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getAllPortletWindows(portletType);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    private List getAllPortletWindows(PortletType portletType) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getAllPortletWindows(portletType);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public EntityID getEntityID(String portletWindowName) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getEntityId(portletWindowName);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public String getPortletWindowTitle(String portletWindowName, String locale) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getPortletWindowTitle(portletWindowName);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public Map getRoleMap(String portletWindowName) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getRoleMap(portletWindowName);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public Map getUserInfoMap(String portletWindowName) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getUserInfoMap(portletWindowName);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public PortletPreferences getPreferences(String portletWindowName, ResourceBundle bundle, boolean isReadOnly) throws PortletWindowContextException {
        String userId = this.checkUserID();
        return new PortletPreferencesImpl(this.request, this.portletRegistryContext, this.getEntityID(portletWindowName), userId, bundle, isReadOnly);
    }

    private String checkUserID() {
        String userId = this.getUserRepresentation();
        if (userId == null) {
            userId = AUTHLESS_USER_ID;
        }
        if (this.isWSRPRequest()) {
            return StringUtil.asBase64((byte[])userId.getBytes());
        }
        return userId;
    }

    private boolean isWSRPRequest() {
        Object isWSRPReq = this.request.getAttribute(IS_WSRP_REQ);
        return isWSRPReq != null;
    }

    public EventHolder verifySupportedPublishingEvent(EntityID portletEntityId, EventHolder eventHolder) {
        PortletDescriptorHolder portletDescriptorHolder = this.getPortletDescriptorHolder();
        if (portletDescriptorHolder == null) {
            return null;
        }
        return portletDescriptorHolder.verifySupportedPublishingEvent(portletEntityId, eventHolder);
    }

    public List<EventHolder> getSupportedPublishingEventHolders(EntityID portletEntityId) {
        PortletDescriptorHolder portletDescriptorHolder = this.getPortletDescriptorHolder();
        if (portletDescriptorHolder == null) {
            return null;
        }
        return portletDescriptorHolder.getSupportedPublishingEventHolders(portletEntityId);
    }

    public EventHolder verifySupportedProcessingEvent(EntityID portletEntityId, EventHolder eventHolder) {
        PortletDescriptorHolder portletDescriptorHolder = this.getPortletDescriptorHolder();
        if (portletDescriptorHolder == null) {
            return null;
        }
        return portletDescriptorHolder.verifySupportedProcessingEvent(portletEntityId, eventHolder);
    }

    public List<EventHolder> getSupportedProcessingEventHolders(EntityID portletEntityId) {
        PortletDescriptorHolder portletDescriptorHolder = this.getPortletDescriptorHolder();
        if (portletDescriptorHolder == null) {
            return null;
        }
        return portletDescriptorHolder.getSupportedProcessingEventHolders(portletEntityId);
    }

    public Map<String, String> verifySupportedPublicRenderParameters(EntityID portletEntityId, List<PublicRenderParameterHolder> publicRenderParameterHolders) {
        PortletDescriptorHolder portletDescriptorHolder = this.getPortletDescriptorHolder();
        if (portletDescriptorHolder == null) {
            return Collections.emptyMap();
        }
        return portletDescriptorHolder.verifySupportedPublicRenderParameters(portletEntityId, publicRenderParameterHolders);
    }

    public List<PublicRenderParameterHolder> getSupportedPublicRenderParameterHolders(EntityID portletEntityId, Map<String, String[]> renderParameters) {
        PortletDescriptorHolder portletDescriptorHolder = this.getPortletDescriptorHolder();
        if (portletDescriptorHolder == null) {
            return Collections.emptyList();
        }
        return portletDescriptorHolder.getSupportedPublicRenderParameterHolders(portletEntityId, renderParameters);
    }

    private PortletDescriptorHolder getPortletDescriptorHolder() {
        PortletDescriptorHolder portletDescriptorHolder = null;
        try {
            portletDescriptorHolder = PortletDescriptorHolderFactory.getPortletDescriptorHolder();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSPL_PCCTXCSPPCI0010", ex);
            return null;
        }
        return portletDescriptorHolder;
    }

    public String getPortletID(String portletWindowName) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getPortletID(portletWindowName);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public String getConsumerID(String portletWindowName) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getConsumerID(portletWindowName);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public String getPortletHandle(String portletWindowName) throws PortletWindowContextException {
        PortletPreferences prefs = this.getPreferences(portletWindowName, null, true);
        return prefs.getValue(PORTLET_HANDLE_PREF_NAME, null);
    }

    public void setPortletHandle(String portletWindowName, String portletHandle) throws PortletWindowContextException {
        PortletPreferences prefs = this.getPreferences(portletWindowName, null, false);
        try {
            prefs.setValue(PORTLET_HANDLE_PREF_NAME, portletHandle);
            prefs.store();
        }
        catch (PortletException pe) {
            throw new PortletWindowContextException((Throwable)pe);
        }
        catch (IOException ioe) {
            throw new PortletWindowContextException((Throwable)ioe);
        }
    }

    public String getProducerEntityID(String portletWindowName) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getProducerEntityID(portletWindowName);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public PortletLang getPortletLang(String portletWindowName) throws PortletWindowContextException {
        try {
            return this.portletRegistryContext.getPortletLang(portletWindowName);
        }
        catch (PortletRegistryException pre) {
            throw new PortletWindowContextException(pre.getMessage());
        }
    }

    public void store() throws PortletWindowContextException {
    }

    public String getUserRepresentation() {
        if (this.elementId == null) {
            Principal principal = this.request.getUserPrincipal();
            this.elementId = principal != null ? principal.getName() : this.request.getParameter("wsrp.userID");
        }
        return this.elementId;
    }
}

