/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.webcomponent;

import java.lang.annotation.Annotation;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.util.ContributionManagementContext;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.mvc.controller.AbstractComponentSessionController;
import org.silverpeas.core.web.mvc.util.RoutingException;
import org.silverpeas.core.web.mvc.util.WysiwygRouting;
import org.silverpeas.core.web.mvc.webcomponent.Navigation;
import org.silverpeas.core.web.mvc.webcomponent.NavigationContext;
import org.silverpeas.core.web.mvc.webcomponent.WebComponentController;
import org.silverpeas.core.web.mvc.webcomponent.WebMessager;
import org.silverpeas.core.web.mvc.webcomponent.annotation.RedirectTo;
import org.silverpeas.core.web.mvc.webcomponent.annotation.RedirectToInternal;
import org.silverpeas.core.web.mvc.webcomponent.annotation.RedirectToInternalJsp;
import org.silverpeas.core.web.mvc.webcomponent.annotation.RedirectToNavigationStep;
import org.silverpeas.core.web.mvc.webcomponent.annotation.RedirectToPreviousNavigationStep;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.bundle.LocalizationBundle;

public abstract class WebComponentRequestContext<T extends WebComponentController> {
    private static final Pattern REDIRECT_VARIABLE_MATCHER = Pattern.compile("(\\{[\\w_]+\\})+");
    private Class<? extends Annotation> httpMethodClass;
    private HttpRequest request;
    private HttpServletResponse response;
    private T controller = null;
    private boolean comingFromRedirect = false;
    private NavigationContext navigationContext;
    private boolean navigationStepContextPerformed = false;
    private Map<String, String> pathVariables = new LinkedHashMap<String, String>();
    private Map<String, String> redirectVariables = new LinkedHashMap<String, String>();
    private Collection<SilverpeasRole> userRoles;
    private SilverpeasRole highestUserRole;

    public void beforeRequestProcessing() {
    }

    void setHttpMethodClass(Class<? extends Annotation> httpMethodClass) {
        this.httpMethodClass = httpMethodClass;
    }

    void setRequest(HttpRequest request) {
        this.request = request;
    }

    void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    void setController(T controller) {
        this.controller = controller;
    }

    public Class<? extends Annotation> getHttpMethodClass() {
        return this.httpMethodClass;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public NavigationContext getNavigationContext() {
        if (this.navigationContext == null) {
            this.navigationContext = NavigationContext.get(this);
        }
        return this.navigationContext;
    }

    T getController() {
        return this.controller;
    }

    public Map<String, String> getPathVariables() {
        return Collections.unmodifiableMap(this.pathVariables);
    }

    void addPathVariable(String variableName, String variableValue) {
        if (this.pathVariables.containsKey(variableName) && !this.pathVariables.get(variableName).equals(variableValue)) {
            this.pathVariables.clear();
            throw new IllegalArgumentException("trying to set different values for the same variable: " + variableName);
        }
        this.pathVariables.put(variableName, variableValue);
    }

    public void addRedirectVariable(String variableName, String variableValue) {
        if (this.pathVariables.containsKey(variableName) && !this.pathVariables.get(variableName).equals(variableValue) || this.redirectVariables.containsKey(variableName) && !this.redirectVariables.get(variableName).equals(variableValue)) {
            this.pathVariables.clear();
            this.redirectVariables.clear();
            throw new IllegalArgumentException("trying to set different values for the same variable: " + variableName);
        }
        this.redirectVariables.put(variableName, variableValue);
    }

    public ZoneId getZoneId() {
        return ((AbstractComponentSessionController)this.controller).getZoneId();
    }

    public LocalizationBundle getMultilang() {
        return ((AbstractComponentSessionController)this.controller).getMultilang();
    }

    public WebMessager getMessager() {
        return WebMessager.getInstance();
    }

    public String getComponentUriBase() {
        return ((AbstractComponentSessionController)this.controller).getComponentUrl();
    }

    public String getComponentInstanceId() {
        return ((AbstractComponentSessionController)this.controller).getComponentId();
    }

    public String getComponentInstanceLabel() {
        return ((AbstractComponentSessionController)this.controller).getComponentLabel();
    }

    public String getComponentName() {
        return ((AbstractComponentSessionController)this.controller).getComponentName();
    }

    public String getInstanceParameterValue(String parameterName) {
        return ((AbstractComponentSessionController)this.controller).getComponentParameterValue(parameterName);
    }

    public String getSpaceId() {
        return ((AbstractComponentSessionController)this.controller).getSpaceId();
    }

    public String getSpaceLabel() {
        return ((AbstractComponentSessionController)this.controller).getSpaceLabel();
    }

    public UserDetail getUser() {
        return ((AbstractComponentSessionController)this.controller).getUserDetail();
    }

    public Collection<SilverpeasRole> getUserRoles() {
        if (this.userRoles == null) {
            this.userRoles = ((AbstractComponentSessionController)this.controller).getSilverpeasUserRoles();
        }
        return this.userRoles;
    }

    public SilverpeasRole getHighestUserRole() {
        if (this.highestUserRole == null) {
            this.highestUserRole = SilverpeasRole.getHighestFrom(this.getUserRoles());
            if (this.highestUserRole == null) {
                this.highestUserRole = SilverpeasRole.READER;
            }
        }
        return this.highestUserRole;
    }

    public boolean isComingFromRedirect() {
        return this.comingFromRedirect;
    }

    boolean isNavigationStepContextPerformed() {
        return this.navigationStepContextPerformed;
    }

    void markNavigationStepContextPerformed() {
        this.navigationStepContextPerformed = true;
    }

    Navigation redirectTo(Annotation redirectToAnnotation) {
        if (redirectToAnnotation instanceof RedirectToInternalJsp) {
            return this.redirectToInternalJsp(((RedirectToInternalJsp)redirectToAnnotation).value());
        }
        if (redirectToAnnotation instanceof RedirectToInternal) {
            return this.redirectToInternal(((RedirectToInternal)redirectToAnnotation).value());
        }
        if (redirectToAnnotation instanceof RedirectToNavigationStep) {
            return this.redirectToNavigationStep(((RedirectToNavigationStep)redirectToAnnotation).value());
        }
        if (redirectToAnnotation instanceof RedirectToPreviousNavigationStep) {
            return this.redirectToNavigationStep("previous");
        }
        RedirectTo redirectTo = (RedirectTo)redirectToAnnotation;
        switch (redirectTo.type()) {
            case INTERNAL_JSP: {
                return this.redirectToInternalJsp(redirectTo.value());
            }
            case INTERNAL: {
                return this.redirectToInternal(redirectTo.value());
            }
        }
        return this.redirectTo(this.normalizeRedirectPath(UriBuilder.fromUri((String)"/"), ((RedirectTo)redirectToAnnotation).value()).build(new Object[0]).toString());
    }

    private Navigation redirectToNavigationStep(String navigationStepIdentifier) {
        NavigationContext.NavigationStep navigationStep = null;
        if (!"previous".equals(navigationStepIdentifier)) {
            navigationStep = this.getNavigationContext().findNavigationStepFrom(navigationStepIdentifier);
        }
        if (navigationStep == null) {
            navigationStep = this.getNavigationContext().getPreviousNavigationStep();
        }
        return this.redirectTo(navigationStep.getUri().toString());
    }

    private Navigation redirectToInternal(String internalPath) {
        return this.redirectTo(this.normalizeRedirectPath(UriBuilder.fromUri((String)this.getComponentUriBase()), internalPath).build(new Object[0]).toString());
    }

    private Navigation redirectToInternalJsp(String jspPathname) {
        return this.redirectTo(this.normalizeRedirectPath(UriBuilder.fromUri((String)"/").path(this.getComponentName()).path("jsp"), jspPathname).build(new Object[0]).toString());
    }

    private Navigation redirectTo(String path) {
        this.comingFromRedirect = true;
        return new Navigation(path);
    }

    private UriBuilder normalizeRedirectPath(UriBuilder uriBuilder, String path) {
        int indexOfUriParamSplit = path.indexOf(63);
        if (indexOfUriParamSplit >= 0) {
            String uriPart = path.substring(0, indexOfUriParamSplit);
            uriBuilder.path(this.replaceRedirectVariables(uriPart.replaceAll("/\\s*$", "")));
            String paramPart = path.substring(indexOfUriParamSplit + 1);
            StringTokenizer paramPartTokenizer = new StringTokenizer(paramPart, "&");
            while (paramPartTokenizer.hasMoreTokens()) {
                String param = paramPartTokenizer.nextToken();
                int indexOfEqual = param.indexOf(61);
                if (indexOfEqual > 0) {
                    String paramName = param.substring(0, indexOfEqual);
                    String paramValue = param.substring(indexOfEqual + 1);
                    uriBuilder.queryParam(paramName, new Object[]{this.replaceRedirectVariables(paramValue)});
                    continue;
                }
                uriBuilder.queryParam(this.replaceRedirectVariables(param), new Object[0]);
            }
        } else {
            uriBuilder.path(this.replaceRedirectVariables(path.replaceAll("/\\s*$", "")));
        }
        return uriBuilder;
    }

    private String replaceRedirectVariables(String redirectPath) {
        String newPath = redirectPath;
        Matcher variableMatcher = REDIRECT_VARIABLE_MATCHER.matcher(redirectPath);
        while (variableMatcher.find()) {
            String variableName = variableMatcher.group(1).replaceAll("[\\{\\}]", "");
            String variableValue = this.pathVariables.containsKey(variableName) ? this.pathVariables.get(variableName) : this.redirectVariables.get(variableName);
            if (variableValue == null) continue;
            newPath = newPath.replace(variableMatcher.group(1), variableValue);
        }
        return newPath;
    }

    public Navigation redirectToHtmlEditor(String objectId, String objectType, String returnPath, boolean indexIt) {
        return this.redirectToHtmlEditor(null, objectId, objectType, returnPath, indexIt);
    }

    public Navigation redirectToHtmlEditor(WysiwygRouting.WysiwygRoutingContext wysiwygContext) {
        return this.redirectToHtmlEditor(null, wysiwygContext);
    }

    public Navigation redirectToHtmlEditor(ContributionManagementContext contributionManagementContext, String objectId, String objectType, String returnPath, boolean indexIt) {
        WysiwygRouting.WysiwygRoutingContext context = new WysiwygRouting.WysiwygRoutingContext().withSpaceLabel(this.getSpaceLabel()).withComponentLabel(this.getComponentInstanceLabel()).withContributionId(ContributionIdentifier.from((String)this.getComponentInstanceId(), (String)objectId, (String)objectType)).withLanguage(((AbstractComponentSessionController)this.controller).getLanguage()).withComeBackUrl(URLUtil.getApplicationURL() + URLUtil.getURL((String)this.getComponentName(), (String)"useless", (String)this.getComponentInstanceId()) + returnPath).withIndexation(indexIt);
        return this.redirectToHtmlEditor(contributionManagementContext, context);
    }

    public Navigation redirectToHtmlEditor(ContributionManagementContext contributionManagementContext, WysiwygRouting.WysiwygRoutingContext wysiwygContext) {
        try {
            this.getRequest().setAttribute("contributionManagementContext", (Object)contributionManagementContext);
            return this.redirectTo(new WysiwygRouting().getWysiwygEditorPath(wysiwygContext, (HttpServletRequest)this.getRequest()));
        }
        catch (RoutingException e) {
            throw new SilverpeasRuntimeException((Throwable)((Object)e));
        }
    }
}

