/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.processor;

import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.web.selection.Selection;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.util.StringUtil;

@Technical
@Bean
public class UserAndGroupSelectionProcessor {
    private static final String SELECTION_PARAMETER = "SELECTION";
    private static final String USER_GROUP_SELECTION_PARAMETER = "UserOrGroupSelection";
    private static final String USER_SELECTION_PARAMETER = "UserSelection";
    private static final String GROUP_SELECTION_PARAMETER = "GroupSelection";
    private static final String SELECTION_FORM_PATH = "/selection/jsp/userpanel.jsp";

    protected UserAndGroupSelectionProcessor() {
    }

    public void prepareSelection(Selection selection, HttpServletRequest request) {
        request.setAttribute(SELECTION_PARAMETER, (Object)selection);
    }

    public String processSelection(Selection selection, HttpServletRequest request) {
        if (this.isSelectionValidated(request)) {
            String userSelection = request.getParameter(USER_SELECTION_PARAMETER);
            String[] selectedUsers = null;
            if (StringUtil.isDefined((String)userSelection)) {
                selectedUsers = userSelection.split(",");
            }
            String groupSelection = request.getParameter(GROUP_SELECTION_PARAMETER);
            String[] selectedGroups = null;
            if (StringUtil.isDefined((String)groupSelection)) {
                selectedGroups = groupSelection.split(",");
            }
            selection.setSelectedElements(selectedUsers);
            selection.setSelectedSets(selectedGroups);
            if (!selection.isHotSetting() && selection.isPopupMode()) {
                request.setAttribute("RedirectionURL", (Object)selection.getGoBackURL());
                return "/selection/jsp/redirect.jsp";
            }
        } else if (!selection.isHotSetting() && selection.isPopupMode()) {
            request.setAttribute("RedirectionURL", (Object)selection.getCancelURL());
            return "/selection/jsp/redirect.jsp";
        }
        return null;
    }

    public boolean isSelectionAsked(String destination) {
        return StringUtil.isDefined((String)destination) && destination.endsWith(SELECTION_FORM_PATH);
    }

    public boolean isSelectionValidated(HttpServletRequest request) {
        String selectionDone = request.getParameter(USER_GROUP_SELECTION_PARAMETER);
        return StringUtil.isDefined((String)selectionDone) && StringUtil.getBooleanValue((String)selectionDone);
    }

    public boolean isComeFromSelectionPanel(HttpServletRequest request) {
        String selectionDone = request.getParameter(USER_GROUP_SELECTION_PARAMETER);
        return StringUtil.isDefined((String)selectionDone);
    }
}

