/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.look.proxy;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.UUID;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.look.proxy.SpaceHomepageProxy;

@RequestScoped
public class SpaceHomepageProxyManager {
    @Inject
    private HttpServletRequest request;
    private static final String URL_PARAM_NAME = "spaceHomepageProxy";
    private SpaceHomepageProxy spaceHomePageProxy;

    public static SpaceHomepageProxyManager get() {
        return (SpaceHomepageProxyManager)ServiceProvider.getService(SpaceHomepageProxyManager.class, (Annotation[])new Annotation[0]);
    }

    public String setParameterForUrlRedirect(String url) {
        if (this.spaceHomePageProxy != null && this.spaceHomePageProxy.isEffective()) {
            String cacheKey = UUID.randomUUID().toString();
            CacheAccessorProvider.getSessionCacheAccessor().getCache().put((Object)cacheKey, (Object)this.spaceHomePageProxy);
            return UriBuilder.fromUri((String)url).queryParam(URL_PARAM_NAME, new Object[]{cacheKey}).build(new Object[0]).toString();
        }
        return url;
    }

    public SpaceHomepageProxy getProxyBySpaceId(String spaceId) {
        return this.getProxyOf(OrganizationController.get().getSpaceInstById(spaceId));
    }

    public SpaceHomepageProxy getProxyOf(SpaceInst space) {
        if (this.spaceHomePageProxy == null) {
            this.spaceHomePageProxy = Optional.ofNullable(this.request.getParameter(URL_PARAM_NAME)).map(k -> (SpaceHomepageProxy)CacheAccessorProvider.getSessionCacheAccessor().getCache().remove(k, SpaceHomepageProxy.class)).orElse(null);
        }
        if (this.spaceHomePageProxy == null || !this.spaceHomePageProxy.getSpace().equals((Object)space)) {
            this.spaceHomePageProxy = new SpaceHomepageProxy(space);
        }
        return this.spaceHomePageProxy;
    }
}

