/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.look;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.service.SpaceProfile;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.personalization.UserMenuDisplay;
import org.silverpeas.core.personalization.service.PersonalizationService;
import org.silverpeas.core.security.session.SessionManagement;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.look.DefaultLayoutConfiguration;
import org.silverpeas.core.web.look.DefaultSpaceHomePage;
import org.silverpeas.core.web.look.LayoutConfiguration;
import org.silverpeas.core.web.look.LookHelper;
import org.silverpeas.core.web.look.PublicationHelper;
import org.silverpeas.core.web.look.PublicationUpdateDateComparator;
import org.silverpeas.core.web.look.Shortcut;
import org.silverpeas.core.web.look.SilverpeasLook;
import org.silverpeas.core.web.look.TickerSettings;
import org.silverpeas.core.web.look.TopItem;
import org.silverpeas.core.web.look.proxy.SpaceHomepageProxy;
import org.silverpeas.core.web.look.proxy.SpaceHomepageProxyManager;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class LookSilverpeasV5Helper
extends LookHelper {
    private static final Object MUTEX = new Object();
    private static final String TO_BE_DEFINED = "toBeDefined";
    private OrganizationController organizationController;
    private SettingBundle resources = null;
    private LocalizationBundle messages = null;
    private LocalizationBundle defaultMessages = null;
    private MainSessionController mainSC = null;
    private boolean displayPDCInNav = false;
    private boolean shouldDisplayPDCFrame = false;
    private boolean shouldDisplayContextualPDC = true;
    private boolean shouldDisplaySpaceIcons = true;
    private boolean shouldDisplayConnectedUsers = true;
    private boolean displayPDCInHomePage = true;
    private List<String> topSpaceIds = null;
    private String mainFrame = "silverpeas-main.jsp";
    private String spaceId = null;
    private String subSpaceId = null;
    private String componentId = null;
    private SimpleDateFormat formatter = null;
    private PublicationHelper kmeliaTransversal = null;
    private PublicationService publicationService = null;
    private UserMenuDisplay displayUserMenu = UserMenuDisplay.DISABLE;
    private boolean enableUFSContainsState = false;
    private final HttpSession session;
    private String currentLookName = null;
    private LayoutConfiguration layoutConfiguration;

    @Override
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    @Override
    public String getSubSpaceId() {
        return this.subSpaceId;
    }

    @Override
    public void setSubSpaceId(String subSpaceId) {
        this.subSpaceId = subSpaceId;
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    @Override
    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSpaceIdAndSubSpaceId(String spaceId) {
        Object object = MUTEX;
        synchronized (object) {
            if (StringUtil.isDefined((String)spaceId)) {
                List spacePath = this.organizationController.getPathToSpace(spaceId);
                if (!spacePath.isEmpty()) {
                    SpaceInstLight space = (SpaceInstLight)spacePath.get(spacePath.size() - 1);
                    this.setSpaceAndSubSpaceContext(space.getId(), space.isPersonalSpace(), space.getId());
                }
                this.setComponentId(null);
            } else {
                this.setSpaceAndSubSpaceContext(null, false, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComponentIdAndSpaceIds(String spaceId, String subSpaceId, String componentId) {
        Object object = MUTEX;
        synchronized (object) {
            boolean isPersonalSpace = false;
            String finalSpaceId = "";
            String finalSubSpaceId = "";
            if (!StringUtil.isDefined((String)spaceId) && PersonalComponentInstance.from((String)componentId).isEmpty()) {
                List spacePath = this.organizationController.getPathToComponent(componentId);
                if (!spacePath.isEmpty()) {
                    SpaceInstLight space = (SpaceInstLight)spacePath.get(spacePath.size() - 1);
                    isPersonalSpace = space.isPersonalSpace();
                    finalSpaceId = space.getId();
                    finalSubSpaceId = space.getId();
                }
            } else {
                finalSpaceId = spaceId;
                finalSubSpaceId = subSpaceId;
            }
            this.setSpaceAndSubSpaceContext(finalSpaceId, isPersonalSpace, finalSubSpaceId);
            this.setComponentId(componentId);
            if (StringUtil.isDefined((String)componentId)) {
                this.getGraphicElementFactory().ifPresent(f -> f.setComponentIdForCurrentRequest(componentId));
            }
        }
    }

    private void setSpaceAndSubSpaceContext(String spaceId, boolean isPersonalSpace, String subSpaceId) {
        boolean isPortletHomePage = this.getGraphicElementFactory().map(f -> {
            Optional.ofNullable(StringUtil.defaultStringIfNotDefined((String)subSpaceId, (String)spaceId)).filter(StringUtil::isDefined).ifPresent(f::setSpaceIdForCurrentRequest);
            return f.isPortletMainPage();
        }).orElse(false);
        if (isPersonalSpace || "-10".equalsIgnoreCase(spaceId) || isPortletHomePage) {
            this.reloadProperties(null, true);
            this.setSpaceId(null);
            this.setSubSpaceId(null);
        } else {
            this.reloadProperties(spaceId, false);
            this.setSpaceId(spaceId);
            this.setSubSpaceId(subSpaceId);
        }
    }

    protected LookSilverpeasV5Helper(HttpSession session) {
        this.session = session;
        this.getGraphicElementFactory().map(GraphicElementFactory::getFavoriteLookSettings).ifPresent(this::init);
    }

    @Override
    public final void init(MainSessionController mainSessionController, SettingBundle resources) {
        this.mainSC = mainSessionController;
        this.init(resources);
    }

    private void init(SettingBundle resources) {
        this.organizationController = OrganizationControllerProvider.getOrganisationController();
        this.publicationService = PublicationService.get();
        this.resources = resources;
        this.defaultMessages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.lookSilverpeasV5.multilang.lookBundle", (String)this.getMainSessionController().getFavoriteLanguage());
        if (StringUtil.isDefined((String)resources.getString("MessageBundle", ""))) {
            this.messages = ResourceLocator.getLocalizationBundle((String)resources.getString("MessageBundle"), (String)this.getMainSessionController().getFavoriteLanguage());
        }
        this.initProperties();
        this.initLayoutConfiguration();
        this.getTopItems();
    }

    private void initProperties() {
        this.displayPDCInNav = this.resources.getBoolean("displayPDCInNav", false);
        this.shouldDisplayPDCFrame = this.resources.getBoolean("displayPDCFrame", false);
        this.shouldDisplayContextualPDC = this.resources.getBoolean("displayContextualPDC", true);
        this.shouldDisplaySpaceIcons = this.resources.getBoolean("displaySpaceIcons", true);
        this.shouldDisplayConnectedUsers = this.resources.getBoolean("displayConnectedUsers", true);
        this.displayPDCInHomePage = this.resources.getBoolean("displayPDCInHomePage", true);
        if (this.isAnonymousUser()) {
            this.displayUserMenu = UserMenuDisplay.DISABLE;
        } else {
            this.displayUserMenu = UserMenuDisplay.valueOf((String)this.resources.getString("displayUserFavoriteSpace", PersonalizationService.DEFAULT_MENU_DISPLAY_MODE.name()).toUpperCase());
            if (this.isMenuPersonalisationEnabled() && this.getMainSessionController().getPersonalization().getDisplay().isNotDefault()) {
                this.displayUserMenu = this.getMainSessionController().getPersonalization().getDisplay();
            }
            this.enableUFSContainsState = this.resources.getBoolean("enableUFSContainsState", false);
        }
    }

    private void reloadProperties(String spaceId, boolean force) {
        block5: {
            String spaceLook;
            block4: {
                if (StringUtil.isDefined((String)spaceId)) break block4;
                if (!force) break block5;
            }
            if ((spaceLook = Optional.ofNullable(spaceId).filter(StringUtil::isDefined).map(SilverpeasLook.getSilverpeasLook()::getSpaceLook).filter(StringUtil::isDefined).orElseGet(() -> Optional.ofNullable(this.getMainSessionController()).map(MainSessionController::getFavoriteLook).orElse(null))) != null && !spaceLook.equals(this.currentLookName)) {
                this.currentLookName = this.getGraphicElementFactory().map(f -> {
                    String look = f.setLook(spaceLook);
                    this.init(f.getFavoriteLookSettings());
                    return look;
                }).orElse(null);
            }
        }
    }

    @Override
    public void initLayoutConfiguration() {
        this.layoutConfiguration = new DefaultLayoutConfiguration(this.resources);
    }

    @Override
    public LayoutConfiguration getLayoutConfiguration() {
        return this.layoutConfiguration;
    }

    @Override
    public boolean isMenuPersonalisationEnabled() {
        return UserMenuDisplay.DISABLE != UserMenuDisplay.valueOf((String)this.resources.getString("displayUserFavoriteSpace", PersonalizationService.DEFAULT_MENU_DISPLAY_MODE.name()).toUpperCase());
    }

    protected MainSessionController getMainSessionController() {
        if (this.session != null) {
            return (MainSessionController)this.session.getAttribute("SilverSessionController");
        }
        return this.mainSC;
    }

    protected OrganizationController getOrganisationController() {
        return this.organizationController;
    }

    protected Optional<GraphicElementFactory> getGraphicElementFactory() {
        if (this.session != null) {
            return Optional.ofNullable((GraphicElementFactory)this.session.getAttribute("SessionGraphicElementFactory"));
        }
        return Optional.empty();
    }

    @Override
    public String getUserFullName(String userId) {
        return this.organizationController.getUserDetail(userId).getDisplayedName();
    }

    @Override
    public String getUserFullName() {
        return this.getUserDetail().getDisplayedName();
    }

    @Override
    public String getUserId() {
        return this.getMainSessionController().getUserId();
    }

    @Override
    public UserDetail getUserDetail() {
        return UserDetail.getById((String)this.getUserId());
    }

    public UserFull getUserFull() {
        return this.organizationController.getUserFull(this.getUserId());
    }

    @Override
    public String getLanguage() {
        return this.getMainSessionController().getFavoriteLanguage();
    }

    @Override
    public ZoneId getZoneId() {
        return this.getMainSessionController().getFavoriteZoneId();
    }

    @Override
    public boolean isAnonymousUser() {
        return UserDetail.isAnonymousUser((String)this.getUserId());
    }

    @Override
    public boolean isAccessGuest() {
        return this.getUserDetail().isAccessGuest();
    }

    @Override
    public boolean displayPDCInNavigationFrame() {
        return this.displayPDCInNav;
    }

    @Override
    public boolean displayPDCFrame() {
        return this.shouldDisplayPDCFrame;
    }

    @Override
    public boolean displayContextualPDC() {
        return this.shouldDisplayContextualPDC;
    }

    @Override
    public boolean displaySpaceIcons() {
        return this.shouldDisplaySpaceIcons;
    }

    @Override
    public String getSpaceId(String componentId) {
        ComponentInstLight component = this.organizationController.getComponentInstLight(componentId);
        if (component != null) {
            return component.getDomainFatherId();
        }
        return null;
    }

    @Override
    public String getWallPaper(String spaceId) {
        String hasWallpaper = "0";
        if (StringUtil.isDefined((String)spaceId) && SilverpeasLook.getSilverpeasLook().hasSpaceWallpaper(spaceId)) {
            hasWallpaper = "1";
        }
        return hasWallpaper;
    }

    @Override
    public int getNBConnectedUsers() {
        int nbConnectedUsers = 0;
        if (this.shouldDisplayConnectedUsers) {
            SessionManagement sessionManagement = SessionManagementProvider.getSessionManagement();
            nbConnectedUsers = sessionManagement.getNbConnectedUsersList((User)this.getMainSessionController().getCurrentUserDetail()) - 1;
        }
        return nbConnectedUsers;
    }

    @Override
    public boolean isAnonymousAccess() {
        return this.isAnonymousUser();
    }

    @Override
    public boolean getSettings(String key) {
        return this.resources.getBoolean(key, false);
    }

    @Override
    public boolean getSettings(String key, boolean defaultValue) {
        return this.resources.getBoolean(key, defaultValue);
    }

    @Override
    public String getSettings(String key, String defaultValue) {
        return this.resources.getString(key, defaultValue);
    }

    @Override
    public int getSettings(String key, int defaultValue) {
        return this.resources.getInteger(key, defaultValue);
    }

    public LocalizationBundle getLocalizedBundle() {
        return this.messages != null ? this.messages : this.defaultMessages;
    }

    @Override
    public String getString(String key) {
        if (key.startsWith("lookSilverpeasV5")) {
            return this.defaultMessages.getString(key);
        }
        return this.messages.getString(key);
    }

    @Override
    public boolean isBackOfficeVisible() {
        return this.getMainSessionController().isBackOfficeVisible();
    }

    @Override
    public List<TopItem> getTopItems() {
        ArrayList<TopItem> topItems = new ArrayList<TopItem>();
        this.topSpaceIds = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.resources.getString("componentsTop", ""), ",");
        while (tokenizer.hasMoreTokens()) {
            String itemId = tokenizer.nextToken();
            if (itemId.startsWith("WA")) {
                if (!this.organizationController.isSpaceAvailable(itemId, this.getUserId())) continue;
                SpaceInstLight space = this.organizationController.getSpaceInstLightById(itemId);
                SpaceInstLight rootSpace = this.organizationController.getRootSpace(itemId);
                TopItem item = new TopItem();
                item.setLabel(space.getName(this.getLanguage()));
                item.setSpaceId(rootSpace.getId());
                item.setSubSpaceId(itemId);
                topItems.add(item);
                this.topSpaceIds.add(item.getSpaceId());
                continue;
            }
            if (!this.organizationController.isComponentAvailableToUser(itemId, this.getUserId())) continue;
            ComponentInstLight component = this.organizationController.getComponentInstLight(itemId);
            String currentSpaceId = component.getDomainFatherId();
            SpaceInstLight rootSpace = this.organizationController.getRootSpace(currentSpaceId);
            TopItem item = new TopItem();
            item.setLabel(component.getLabel(this.getLanguage()));
            item.setComponentId(itemId);
            item.setSpaceId(rootSpace.getId());
            item.setSubSpaceId(currentSpaceId);
            topItems.add(item);
        }
        return topItems;
    }

    @Override
    public List<String> getTopSpaceIds() {
        return this.topSpaceIds;
    }

    @Override
    public String getMainFrame() {
        return this.mainFrame;
    }

    @Override
    public void setMainFrame(String newMainFrame) {
        if (StringUtil.isDefined((String)newMainFrame)) {
            this.mainFrame = newMainFrame;
        }
    }

    @Override
    public String getSpaceWallPaper() {
        String theSpaceId = this.getCurrentDeepestSpaceId();
        if (StringUtil.isDefined((String)theSpaceId)) {
            return SilverpeasLook.getSilverpeasLook().getWallpaperOfSpace(theSpaceId);
        }
        return null;
    }

    @Override
    public String getSpaceWithCSSToApply() {
        String theSpaceId = this.getCurrentDeepestSpaceId();
        if (StringUtil.isDefined((String)theSpaceId)) {
            return SilverpeasLook.getSilverpeasLook().getSpaceWithCSS(theSpaceId);
        }
        return null;
    }

    private String getCurrentDeepestSpaceId() {
        String theSpaceId = this.getSpaceId();
        if (StringUtil.isDefined((String)theSpaceId) && StringUtil.isDefined((String)this.getSubSpaceId())) {
            theSpaceId = this.getSubSpaceId();
        }
        return theSpaceId;
    }

    public String getComponentURL(String key, String function) {
        String currentFunction = function;
        String currentComponentId = this.resources.getString(key);
        if (!StringUtil.isDefined((String)function)) {
            currentFunction = "Main";
        }
        return URLUtil.getApplicationURL() + URLUtil.getURL((String)"useless", (String)currentComponentId) + currentFunction;
    }

    @Override
    public String getComponentURL(String key) {
        return this.getComponentURL(key, "Main");
    }

    @Override
    public String getDate() {
        if (this.formatter == null) {
            this.formatter = new SimpleDateFormat(this.resources.getString("DateFormat", "dd/MM/yyyy"), new Locale(this.getMainSessionController().getFavoriteLanguage()));
        }
        return this.formatter.format(new Date());
    }

    @Override
    public String getDefaultSpaceId() {
        String defaultSpaceId = this.resources.getString("DefaultSpaceId", "");
        if (!StringUtil.isDefined((String)defaultSpaceId)) {
            defaultSpaceId = this.getMainSessionController().getFavoriteSpace();
        }
        return defaultSpaceId;
    }

    protected PublicationHelper getPublicationHelper() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.kmeliaTransversal == null) {
            String helperClassName = this.getSettings("publicationHelper", "org.silverpeas.components.kmelia.KmeliaTransversal");
            Class<?> helperClass = Class.forName(helperClassName);
            try {
                Constructor<?> constructor = helperClass.getConstructor(new Class[0]);
                this.kmeliaTransversal = (PublicationHelper)constructor.newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new InstantiationException(e.getMessage());
            }
            this.kmeliaTransversal.setMainSessionController(this.getMainSessionController());
        }
        return this.kmeliaTransversal;
    }

    @Override
    public List<PublicationDetail> getLatestPublications(String spaceId, int nbPublis) {
        try {
            return this.getPublicationHelper().getPublications(spaceId, nbPublis);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error((Throwable)ex);
            return new ArrayList<PublicationDetail>();
        }
    }

    @Override
    public List<PublicationDetail> getLatestPublications(String spaceId, List<String> excludedComponents, int nbPublis) {
        try {
            return this.getPublicationHelper().getPublications(spaceId, excludedComponents, nbPublis);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error((Throwable)ex);
            return new ArrayList<PublicationDetail>();
        }
    }

    @Override
    public List<PublicationDetail> getValidPublications(NodePK nodePK) {
        List publis = (List)this.getPublicationService().getDetailsByFatherPK(nodePK, null, true);
        ArrayList<PublicationDetail> filteredPublis = new ArrayList<PublicationDetail>();
        for (int i = 0; publis != null && i < publis.size(); ++i) {
            PublicationDetail publi = (PublicationDetail)publis.get(i);
            if (!"Valid".equalsIgnoreCase(publi.getStatus())) continue;
            filteredPublis.add(publi);
        }
        return filteredPublis;
    }

    public PublicationService getPublicationService() {
        return this.publicationService;
    }

    public String getSpaceHomePage(String spaceId, HttpServletRequest request) throws UnsupportedEncodingException {
        SpaceHomepageProxy spaceStruct = SpaceHomepageProxyManager.get().getProxyOf(this.getOrganisationController().getSpaceInstById(spaceId));
        if (this.isComponentAsSpaceHome(spaceStruct) && this.getOrganisationController().isComponentAvailableToUser(spaceStruct.getFirstPageExtraParam(), this.getUserId())) {
            return URLUtil.getSimpleURL((int)1, (String)spaceStruct.getFirstPageExtraParam());
        }
        if (spaceStruct != null && spaceStruct.getFirstPageType() == SpaceInst.FP_TYPE_HTML_PAGE && spaceStruct.getFirstPageExtraParam() != null && spaceStruct.getFirstPageExtraParam().length() > 0) {
            String destination = spaceStruct.getFirstPageExtraParam();
            destination = this.getParsedDestination(destination, "%ST_USER_LOGIN%", this.getMainSessionController().getCurrentUserDetail().getLogin());
            destination = this.getParsedDestination(destination, "%ST_USER_FULLNAME%", URLEncoder.encode(this.getMainSessionController().getCurrentUserDetail().getDisplayedName(), Charsets.UTF_8.name()));
            destination = this.getParsedDestination(destination, "%ST_USER_ID%", URLEncoder.encode(this.getMainSessionController().getUserId(), Charsets.UTF_8.name()));
            destination = this.getParsedDestination(destination, "%ST_SESSION_ID%", URLEncoder.encode(request.getSession().getId(), Charsets.UTF_8.name()));
            HttpSession theSession = request.getSession();
            return this.getParsedDestination(destination, "%ST_USER_PASSWORD%", (String)theSession.getAttribute("Silverpeas_pwdForHyperlink"));
        }
        return null;
    }

    private boolean isComponentAsSpaceHome(SpaceHomepageProxy spaceStruct) {
        return spaceStruct != null && spaceStruct.getFirstPageType() == SpaceInst.FP_TYPE_COMPONENT_INST && spaceStruct.getFirstPageExtraParam() != null && spaceStruct.getFirstPageExtraParam().length() > 0;
    }

    private String getParsedDestination(String sDestination, String sKeyword, String sValue) {
        Object parsedDestination = sDestination;
        int nLoginIndex = sDestination.indexOf(sKeyword);
        if (nLoginIndex != -1) {
            Object sParsed = sDestination.substring(0, nLoginIndex);
            sParsed = (String)sParsed + sValue;
            if (sDestination.length() > nLoginIndex + sKeyword.length()) {
                sParsed = (String)sParsed + sDestination.substring(nLoginIndex + sKeyword.length());
            }
            parsedDestination = sParsed;
        }
        return parsedDestination;
    }

    @Override
    public UserMenuDisplay getDisplayUserMenu() {
        return this.displayUserMenu;
    }

    @Override
    public void setDisplayUserMenu(UserMenuDisplay displayUserMenu) {
        this.displayUserMenu = displayUserMenu;
    }

    @Override
    public boolean isEnableUFSContainsState() {
        return this.enableUFSContainsState;
    }

    public List<Shortcut> getShortcuts(String id, int nb) {
        ArrayList<Shortcut> shortcuts = new ArrayList<Shortcut>();
        for (int i = 1; i <= nb; ++i) {
            String prefix = "Shortcut." + id + "." + i;
            String url = this.getSettings(prefix + ".Url", TO_BE_DEFINED);
            String target = this.getSettings(prefix + ".Target", TO_BE_DEFINED);
            String altText = this.getSettings(prefix + ".AltText", TO_BE_DEFINED);
            String iconUrl = this.getSettings(prefix + ".IconUrl", TO_BE_DEFINED);
            Shortcut shortcut = new Shortcut(iconUrl, target, url, altText);
            shortcuts.add(shortcut);
        }
        return shortcuts;
    }

    @Override
    public boolean isDisplayPDCInHomePage() {
        return this.displayPDCInHomePage;
    }

    @Override
    public DefaultSpaceHomePage getSpaceHomePage(String spaceId) {
        this.setSpaceIdAndSubSpaceId(spaceId);
        String currentSpaceId = this.getSubSpaceId();
        DefaultSpaceHomePage homepage = new DefaultSpaceHomePage();
        SpaceInstLight space = this.organizationController.getSpaceInstLightById(currentSpaceId);
        homepage.setSpace(space);
        if (this.resources.getBoolean("space.homepage.latestpublications", true)) {
            this.setLatestPublicationsInHomePage(currentSpaceId, homepage);
        }
        if (this.resources.getBoolean("space.homepage.news", true)) {
            homepage.setNews(this.getNews(currentSpaceId));
        }
        if (this.resources.getBoolean("space.homepage.subspaces", true)) {
            String[] subspaceIds = this.getOrganisationController().getAllowedSubSpaceIds(this.getUserId(), currentSpaceId);
            ArrayList<SpaceInstLight> subspaces = new ArrayList<SpaceInstLight>();
            for (String subspaceId : subspaceIds) {
                subspaces.add(this.getOrganisationController().getSpaceInstLightById(subspaceId));
            }
            homepage.setSubSpaces(subspaces);
        }
        boolean displayApps = this.resources.getBoolean("space.homepage.apps", true);
        boolean displayEvents = this.resources.getBoolean("space.homepage.events", true);
        if (displayApps || displayEvents) {
            this.setApplicationsInHomePage(currentSpaceId, homepage, displayApps, displayEvents);
        }
        if (this.resources.getBoolean("space.homepage.admins", true)) {
            homepage.setAdmins(this.getSpaceAdmins(currentSpaceId));
        }
        return homepage;
    }

    private void setApplicationsInHomePage(String currentSpaceId, DefaultSpaceHomePage homepage, boolean displayApps, boolean displayEvents) {
        String[] appIds = this.getOrganisationController().getAvailCompoIdsAtRoot(currentSpaceId, this.getUserId());
        ArrayList<ComponentInstLight> apps = new ArrayList<ComponentInstLight>();
        for (String appId : appIds) {
            ComponentInstLight app = this.getOrganisationController().getComponentInstLight(appId);
            if (displayApps && !app.isHidden()) {
                apps.add(app);
            }
            if (!displayEvents || !app.getName().equals("almanach") || StringUtil.isDefined((String)homepage.getNextEventsURL())) continue;
            homepage.setNextEventsURL(URLUtil.getApplicationURL() + URLUtil.getURL(null, (String)appId) + "portlet");
        }
        homepage.setApps(apps);
    }

    private void setLatestPublicationsInHomePage(String currentSpaceId, DefaultSpaceHomePage homepage) {
        try {
            homepage.setPublications(this.getPublicationHelper().getUpdatedPublications(currentSpaceId, 0, this.resources.getInteger("space.homepage.latestpublications.nb", 5)));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    public List<UserDetail> getSpaceAdmins(String spaceId) {
        ArrayList<UserDetail> admins = new ArrayList<UserDetail>();
        SpaceProfile spaceProfile = this.getOrganisationController().getSpaceProfile(spaceId, SilverpeasRole.MANAGER);
        Set userIds = spaceProfile.getAllUserIdsIncludingAllGroups();
        for (String userId : userIds) {
            admins.add(UserDetail.getById((String)userId));
        }
        return admins;
    }

    public List<PublicationDetail> getNews(String spaceId) {
        String[] cIds;
        ArrayList<String> appIds = new ArrayList<String>();
        for (String id : cIds = this.getOrganisationController().getAvailCompoIds(spaceId, this.getUserId())) {
            if (!StringUtil.startsWithIgnoreCase((String)id, (String)"quickinfo")) continue;
            appIds.add(id);
        }
        ArrayList<PublicationDetail> news = new ArrayList<PublicationDetail>();
        for (String appId : appIds) {
            Collection someNews = this.getPublicationService().getOrphanPublications(appId);
            for (PublicationDetail aNews : someNews) {
                if (!this.isVisibleNews(aNews)) continue;
                news.add(aNews);
            }
        }
        news.sort(PublicationUpdateDateComparator.comparator);
        int nbNews = this.getSettings("space.homepage.news.nb", 10);
        if (news.size() > nbNews) {
            return news.subList(0, nbNews);
        }
        return news;
    }

    private boolean isVisibleNews(PublicationDetail news) {
        return news.isValid() && news.getVisibility().isActive();
    }

    @Override
    public TickerSettings getTickerSettings() {
        TickerSettings tickerSettings = new TickerSettings(this.resources);
        String labelParam = this.getSettings("ticker.label", "");
        if (labelParam.equalsIgnoreCase("default")) {
            tickerSettings.setLabel(this.getString("lookSilverpeasV5.ticker.label"));
        }
        return tickerSettings;
    }

    @Override
    public String getURLOfLastVisitedCollaborativeSpace() {
        String theSpaceId = this.getSpaceId();
        if (StringUtil.isDefined((String)this.getSubSpaceId())) {
            theSpaceId = this.getSubSpaceId();
        }
        if (StringUtil.isDefined((String)theSpaceId)) {
            return URLUtil.getSimpleURL((int)0, (String)theSpaceId) + "?Fallback=true";
        }
        return null;
    }

    public SettingBundle getSettingsBundle() {
        return this.resources;
    }
}

