/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.jstl.constant.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.silverpeas.core.web.jstl.constant.reflect.FieldPathParser;

public class ClassConstantInspector {
    private Field field;

    public ClassConstantInspector(String constantPath) throws ClassNotFoundException, NoSuchFieldException {
        FieldPathParser parser = new FieldPathParser(constantPath);
        Class currentClass = Class.forName(parser.getDeclaringClassName());
        HashMap innerClasses = null;
        for (String fieldOrClassName : parser.getFieldOrClassNames()) {
            if (innerClasses == null) {
                innerClasses = new HashMap();
                for (Class<?> innerClass : currentClass.getClasses()) {
                    innerClasses.put(innerClass.getSimpleName(), innerClass);
                }
            }
            if (innerClasses.containsKey(fieldOrClassName)) {
                currentClass = (Class)innerClasses.get(fieldOrClassName);
                innerClasses = null;
                continue;
            }
            this.field = currentClass.getField(fieldOrClassName);
        }
        if (!(this.field != null && Modifier.isPublic(this.field.getModifiers()) && Modifier.isStatic(this.field.getModifiers()) && Modifier.isFinal(this.field.getModifiers()))) {
            throw new IllegalArgumentException("Field " + constantPath + " is not a public static final field");
        }
    }

    public Object getValue() throws IllegalAccessException, InstantiationException {
        return this.field.get(null);
    }

    public static Object getValue(String constantName) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return new ClassConstantInspector(constantName).getValue();
    }
}

