/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.http;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.web.http.FileResponse;
import org.silverpeas.kernel.util.StringUtil;

public class RestFileResponse
extends FileResponse {
    RestFileResponse(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
    }

    public Response.ResponseBuilder silverpeasFile(SilverpeasFile file) {
        if (StringUtil.isNotDefined((String)this.forcedMimeType)) {
            this.forceMimeType(file.getMimeType());
        }
        return this.path(Paths.get(file.toURI()));
    }

    private Response.ResponseBuilder path(Path path) {
        try {
            Path absoluteFilePath = path.toAbsolutePath();
            String fileName = this.getFileName(absoluteFilePath);
            String fileMimeType = this.getMimeType(absoluteFilePath);
            int fullContentLength = (int)Files.size(absoluteFilePath);
            Matcher partialMatcher = this.getPartialMatcher();
            boolean isPartialRequest = partialMatcher.matches();
            Response.ResponseBuilder responseBuilder = isPartialRequest ? this.getPartialResponseBuilder(partialMatcher, absoluteFilePath, fullContentLength) : this.getFullResponseBuilder(absoluteFilePath, fullContentLength);
            String filename = RestFileResponse.encodeAttachmentFilenameAsUtf8(fileName);
            return responseBuilder.type(fileMimeType).header("Content-Disposition", (Object)filename);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @Override
    public RestFileResponse forceFileId(String fileId) {
        super.forceFileId(fileId);
        return this;
    }

    @Override
    public RestFileResponse forceMimeType(String mimeType) {
        super.forceMimeType(mimeType);
        return this;
    }

    @Override
    public RestFileResponse forceCharacterEncoding(String forcedCharacterEncoding) {
        super.forceCharacterEncoding(forcedCharacterEncoding);
        return this;
    }

    @Override
    public RestFileResponse forceFileName(String fileName) {
        super.forceFileName(fileName);
        return this;
    }

    @Override
    public RestFileResponse noCache() {
        super.noCache();
        return this;
    }

    private Response.ResponseBuilder getPartialResponseBuilder(Matcher partialHeaders, Path path, int fullContentLength) throws IOException {
        FileResponse.ContentRangeData data = this.getContentRangeData(partialHeaders, fullContentLength);
        return Response.status((Response.Status)Response.Status.PARTIAL_CONTENT).entity((Object)this.getPartialOutputStream(path, data)).header("Content-Length", (Object)data.partContentLength).header("Accept-Ranges", (Object)"bytes").header("ETag", (Object)this.getFileIdentifier(path)).lastModified(this.getLastModifiedDate(path)).expires(this.getExpirationDate()).header("Content-Range", (Object)data.headerValue);
    }

    private StreamingOutput getPartialOutputStream(Path path, FileResponse.ContentRangeData partialData) {
        return output -> this.partialOutputStream(path, partialData, output);
    }

    private Response.ResponseBuilder getFullResponseBuilder(Path path, int fullContentLength) {
        StreamingOutput streamingOutput = output -> this.fullOutputStream(path, output);
        return Response.ok((Object)streamingOutput).header("Content-Length", (Object)fullContentLength);
    }
}

