/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar.ical;

import com.rometools.rome.feed.synd.SyndFeed;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import org.silverpeas.core.web.calendar.ical.FeedUtilities;
import org.silverpeas.core.web.calendar.ical.ImportIcalManager;
import org.silverpeas.core.web.calendar.ical.StringUtils;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.logging.SilverLogger;

public final class SyncEngine {
    public static final String REMOTE_CONNECT_SUCCEEDED = "0";
    public static final String AUTHENT_LOGIN_FAILED = "1";
    public static final String AUTHENT_PWD_FAILED = "2";
    public static final String REMOTE_CONNECT_FAILED = "3";

    public final String synchronize(File localCalendar, URL remoteCalendar, String username, String password) throws SilverpeasException {
        if (username == null || username.length() == 0) {
            return AUTHENT_LOGIN_FAILED;
        }
        if (password == null || password.length() == 0) {
            return AUTHENT_PWD_FAILED;
        }
        String returnCode = REMOTE_CONNECT_FAILED;
        byte[] feedBytes = FeedUtilities.loadFeed(remoteCalendar.toString(), username, password);
        try (FileOutputStream fileOutputStream = new FileOutputStream(localCalendar);
             OutputStreamWriter fileOutput = new OutputStreamWriter((OutputStream)fileOutputStream, ImportIcalManager.getCharset());){
            if (feedBytes != null) {
                if (this.isRssFeed(feedBytes)) {
                    long eventLength = 100000000L;
                    CalendarOutputter outputter = new CalendarOutputter();
                    SyndFeed feed = FeedUtilities.parseFeed(feedBytes);
                    Calendar feedCalendar = FeedUtilities.convertFeedToCalendar(feed, 100000000L);
                    outputter.output(feedCalendar, (Writer)fileOutput);
                } else {
                    fileOutput.write(StringUtils.decodeToString(feedBytes, ImportIcalManager.getCharset()));
                    fileOutput.flush();
                }
                returnCode = REMOTE_CONNECT_SUCCEEDED;
            } else {
                returnCode = REMOTE_CONNECT_FAILED;
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
            returnCode = REMOTE_CONNECT_FAILED;
        }
        return returnCode;
    }

    private boolean isRssFeed(byte[] bytes) {
        boolean isRssFeed = false;
        SyndFeed syndFeed = FeedUtilities.parseFeed(bytes);
        if (syndFeed != null && syndFeed.getFeedType() != null) {
            isRssFeed = true;
        }
        return isRssFeed;
    }
}

