/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.UserRegistrationService;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.io.file.SilverpeasFileProvider;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUploadUtil;
import org.silverpeas.core.web.authentication.credentials.CredentialsFunctionHandler;
import org.silverpeas.core.web.authentication.credentials.RegistrationSettings;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class RegisterHandler
extends CredentialsFunctionHandler {
    private final RegistrationSettings settings = RegistrationSettings.getSettings();
    @Inject
    private UserRegistrationService userRegistrationService;
    @Inject
    private PublicationTemplateManager publicationTemplateManager;

    @Override
    public String getFunction() {
        return "Register";
    }

    @Override
    public String doAction(HttpServletRequest request) {
        HttpRequest req = HttpRequest.decorate((HttpServletRequest)request);
        String firstName = req.getParameter("firstName");
        String lastName = req.getParameter("lastName");
        String email = req.getParameter("email");
        String domainId = this.settings.userSelfRegistrationDomainId();
        if (this.settings.isUserSelfRegistrationEnabled()) {
            try {
                String userId = this.userRegistrationService.registerUser(firstName, lastName, email, domainId);
                this.processDataOfExtraTemplate(userId, req);
                this.saveAvatar(req, UserFull.getById((String)userId).getAvatarFileName());
            }
            catch (AdminException e) {
                return "/admin/jsp/registrationFailed.jsp";
            }
            return "/admin/jsp/registrationSuccess.jsp";
        }
        SilverLogger.getLogger((Object)this).warn("A user is trying to register himself although this capability is deactived! Registration information: [firstname: {0}, lastname: {1}, email: {2}]", new Object[]{firstName, lastName, email});
        return "";
    }

    private void processDataOfExtraTemplate(String userId, HttpRequest request) {
        PagesContext context = this.getTemplateContext(userId);
        context.setDomainId(this.settings.userSelfRegistrationDomainId());
        PublicationTemplate template = this.publicationTemplateManager.getDirectoryTemplate();
        if (template != null) {
            try {
                this.publicationTemplateManager.saveData(template.getFileName(), context, request.getFileItems());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }

    private PagesContext getTemplateContext(String userId) {
        return PagesContext.getDirectoryContext((String)userId, (String)userId, (String)I18NHelper.DEFAULT_LANGUAGE);
    }

    private void saveAvatar(HttpRequest request, String nameAvatar) {
        List parameters = request.getFileItems();
        FileItem file = FileUploadUtil.getFile((List)parameters, (String)"avatar");
        if (file != null && StringUtil.isDefined((String)file.getName())) {
            String extension = FileRepositoryManager.getFileExtension((String)file.getName());
            if (extension != null && extension.equalsIgnoreCase("jpeg")) {
                extension = "jpg";
            }
            if ("gif".equalsIgnoreCase(extension) || "jpg".equalsIgnoreCase(extension) || "png".equalsIgnoreCase(extension)) {
                try (InputStream fis = file.getInputStream();){
                    SilverpeasFile image = SilverpeasFileProvider.newFile((String)this.getImagePath(nameAvatar));
                    image.writeFrom(fis);
                }
                catch (IOException e) {
                    SilverLogger.getLogger((Object)this).error((Throwable)e);
                }
            }
        }
    }

    private String getImagePath(String fileName) {
        return FileRepositoryManager.getAvatarPath() + File.separatorChar + fileName;
    }
}

