/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.web.authentication.credentials.ChangePasswordFunctionHandler;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class ChangeExpiredPasswordHandler
extends ChangePasswordFunctionHandler {
    @Override
    public String getFunction() {
        return "ChangeExpiredPassword";
    }

    @Override
    public String doAction(HttpServletRequest request) {
        String login = request.getParameter("login");
        String domainId = request.getParameter("domainId");
        String oldPassword = request.getParameter("oldPassword");
        String newPassword = request.getParameter("newPassword");
        String checkId = request.getParameter("checkId");
        AuthenticationCredential credential = null;
        try {
            this.assertPasswordHasBeenCorrectlyChecked(checkId, newPassword);
            credential = AuthenticationCredential.newWithAsLogin((String)login).withAsPassword(oldPassword).withAsDomainId(domainId);
            this.getAuthenticator().changePassword(credential, newPassword);
            return "/AuthenticationServlet?Login=" + login + "&Password=" + newPassword + "&DomainId=" + domainId;
        }
        catch (AuthenticationException e) {
            SilverLogger.getLogger((Object)this).error("login=" + login, (Throwable)e);
            SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.authentication.settings.passwordExpiration");
            return this.performUrlChangePasswordError(request, settings.getString("passwordExpiredURL") + "?login=" + login + "&domainId=" + domainId, credential);
        }
    }
}

