/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.attachment;

import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.documenttemplate.DocumentTemplate;
import org.silverpeas.core.io.upload.FileUploadManager;
import org.silverpeas.core.io.upload.UploadedFile;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.http.RequestFile;
import org.silverpeas.core.web.http.RequestParameterDecoder;
import org.silverpeas.core.webapi.documenttemplate.DocumentTemplateWebManager;
import org.silverpeas.kernel.util.StringUtil;

public class SimpleDocumentUploadData {
    @FormParam(value="file_upload")
    private RequestFile requestFile;
    @FormParam(value="X-Requested-With")
    private String xRequestedWith;
    @FormParam(value="documentTemplateId")
    private String documentTemplateId;
    @FormParam(value="fileLang")
    private String language;
    @FormParam(value="fileTitle")
    private String title;
    @FormParam(value="fileDescription")
    private String description;
    @FormParam(value="foreignId")
    private String foreignId;
    @FormParam(value="indexIt")
    private boolean indexIt;
    @FormParam(value="versionType")
    private Integer versionType;
    @FormParam(value="commentMessage")
    private String comment;
    @FormParam(value="context")
    private String context;

    public static SimpleDocumentUploadData decode(HttpRequest request) {
        List uploadedFiles;
        SimpleDocumentUploadData uploadData = (SimpleDocumentUploadData)RequestParameterDecoder.decode((HttpRequest)request, SimpleDocumentUploadData.class);
        if (uploadData.requestFile == null && (uploadedFiles = FileUploadManager.getUploadedFiles((HttpServletRequest)request, (User)User.getCurrentRequester())).size() == 1) {
            uploadData.requestFile = new RequestFile(((UploadedFile)uploadedFiles.get(0)).asFileItem());
        }
        return uploadData;
    }

    public RequestFile getRequestFile() {
        return this.requestFile;
    }

    public String getXRequestedWith() {
        return this.xRequestedWith;
    }

    public Optional<DocumentTemplate> getDocumentTemplate() {
        return Optional.ofNullable(this.documentTemplateId).filter(StringUtil::isDefined).map(DocumentTemplateWebManager.get()::getDocumentTemplate);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public boolean getIndexIt() {
        return this.indexIt;
    }

    public Integer getVersionType() {
        return this.versionType;
    }

    public String getComment() {
        return this.comment;
    }

    public String getContext() {
        return this.context;
    }
}

