/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin.registry;

import com.sun.portal.portletcontainer.admin.registry.AbstractPortletRegistryElement;
import com.sun.portal.portletcontainer.admin.registry.XMLDocumentHelper;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PortletWindow
extends AbstractPortletRegistryElement {
    private static Logger logger = Logger.getLogger("com.sun.portal.portletcontainer.admin.registry", "org.silverpeas.portlets.PALogMessages");

    public int getRow() {
        String row = this.getStringProperty("row");
        int rowNumber = -1;
        if (row != null) {
            try {
                rowNumber = Integer.parseInt(row);
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "PSPL_CSPPAM0002", row);
            }
        }
        return rowNumber;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("PortletName:");
        buffer.append(this.getPortletName());
        buffer.append(";Name:");
        buffer.append(this.getName());
        buffer.append(";Collections(Map):");
        buffer.append(this.getMapCollectionTable());
        buffer.append(";Collections(String):");
        buffer.append(this.getStringCollectionTable());
        return buffer.toString();
    }

    @Override
    protected void populateValues(Element portletWindowTag) {
        Map<String, String> portletWindowAttributes = XMLDocumentHelper.createAttributeTable(portletWindowTag);
        this.setName(portletWindowAttributes.get("name"));
        this.setPortletName(portletWindowAttributes.get("portletName"));
        this.setRemote(portletWindowAttributes.get("remote"));
        this.setLang(portletWindowAttributes.get("lang"));
        super.populateValues(portletWindowTag);
    }

    @Override
    protected void create(Document document, Element rootTag) {
        Element portletWindowTag = XMLDocumentHelper.createElement(document, "PortletWindow");
        portletWindowTag.setAttribute("name", this.getName());
        portletWindowTag.setAttribute("portletName", this.getPortletName());
        portletWindowTag.setAttribute("remote", this.getRemote());
        portletWindowTag.setAttribute("lang", this.getLang());
        rootTag.appendChild(portletWindowTag);
        Element propertiesTag = XMLDocumentHelper.createElement(document, "Properties");
        portletWindowTag.appendChild(propertiesTag);
        super.create(document, propertiesTag);
    }
}

