/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.mem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.ConnectionSignUp;
import org.springframework.social.connect.NoSuchConnectionException;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.connect.mem.InMemoryConnectionRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryUsersConnectionRepository
implements UsersConnectionRepository {
    private ConnectionFactoryLocator connectionFactoryLocator;
    private Map<String, ConnectionRepository> connectionRepositories;
    private ConnectionSignUp connectionSignUp;

    public InMemoryUsersConnectionRepository(ConnectionFactoryLocator connectionFactoryLocator) {
        this.connectionFactoryLocator = connectionFactoryLocator;
        this.connectionRepositories = new HashMap<String, ConnectionRepository>();
    }

    public void setConnectionSignUp(ConnectionSignUp connectionSignUp) {
        this.connectionSignUp = connectionSignUp;
    }

    @Override
    public List<String> findUserIdsWithConnection(Connection<?> connection) {
        String newUserId;
        ArrayList<String> localUserIds = new ArrayList<String>();
        Set<Map.Entry<String, ConnectionRepository>> connectionRepositoryEntries = this.connectionRepositories.entrySet();
        for (Map.Entry<String, ConnectionRepository> connectionRepositoryEntry : connectionRepositoryEntries) {
            try {
                connectionRepositoryEntry.getValue().getConnection(connection.getKey());
                localUserIds.add(connectionRepositoryEntry.getKey());
            }
            catch (NoSuchConnectionException e) {}
        }
        if (localUserIds.size() == 0 && this.connectionSignUp != null && (newUserId = this.connectionSignUp.execute(connection)) != null) {
            this.createConnectionRepository(newUserId).addConnection(connection);
            return Arrays.asList(newUserId);
        }
        return localUserIds;
    }

    @Override
    public Set<String> findUserIdsConnectedTo(String providerId, Set<String> providerUserIds) {
        ArrayList<String> localUserIds = new ArrayList<String>();
        Set<Map.Entry<String, ConnectionRepository>> connectionRepositoryEntries = this.connectionRepositories.entrySet();
        for (Map.Entry<String, ConnectionRepository> connectionRepositoryEntry : connectionRepositoryEntries) {
            String localUserId = connectionRepositoryEntry.getKey();
            List<Connection<?>> providerConnections = connectionRepositoryEntry.getValue().findConnections(providerId);
            for (Connection<?> connection : providerConnections) {
                if (!providerUserIds.contains(connection.getKey().getProviderUserId())) continue;
                localUserIds.add(localUserId);
            }
        }
        return new HashSet<String>(localUserIds);
    }

    @Override
    public ConnectionRepository createConnectionRepository(String userId) {
        if (!this.connectionRepositories.containsKey(userId)) {
            this.connectionRepositories.put(userId, new InMemoryConnectionRepository(this.connectionFactoryLocator));
        }
        return this.connectionRepositories.get(userId);
    }
}

