/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chat.servers;

import javax.ws.rs.core.Response;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.chat.ChatServerException;
import org.silverpeas.core.chat.ChatSettings;
import org.silverpeas.core.chat.ChatUser;
import org.silverpeas.core.chat.servers.ChatServer;
import org.silverpeas.core.chat.servers.HttpRequester;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class OpenfireServer
implements ChatServer {
    private static final String XMPP_USER = "XMPP user";
    private static final String XMPP_RELATIONSHIP = "XMPP relationship";
    private static final String BETWEEN = " <-> ";
    private static final String ERROR_USER_ADD_PATTERN = "Error while creating XMPP user: {0}";
    private static final String ERROR_USER_DEL_PATTERN = "Error while deleting XMPP user: {0}";
    private static final String ERROR_RELATIONSHIP_ADD_PATTERN = "Error while creating XMPP relationship: {0}";
    private static final String ERROR_RELATIONSHIP_DEL_PATTERN = "Error while deleting XMPP relationship: {0}";
    private final SilverLogger logger = SilverLogger.getLogger((Object)this);
    private final String url;
    private final HttpRequester theRequester;

    public OpenfireServer() {
        ChatSettings settings = ChatServer.getChatSettings();
        this.url = settings.getRestApiUrl() + "/users";
        String key = settings.getRestApiAuthToken();
        this.theRequester = new HttpRequester(key);
    }

    @Override
    public void createUser(User user) {
        ChatUser chatUser = ChatUser.fromUser(user);
        try (HttpRequester requester = this.request(this.url, new String[0]);
             Response response = requester.post(o -> {
            o.put("username", chatUser.getChatLogin()).put("password", chatUser.getChatPassword()).put("name", chatUser.getDisplayedName());
            if (StringUtil.isDefined((String)chatUser.getEmailAddress())) {
                o.put("email", chatUser.getEmailAddress());
            }
            return o;
        });){
            if (response.getStatus() != 200) {
                this.logger.error(ERROR_USER_ADD_PATTERN, new Object[]{response.getStatusInfo().getReasonPhrase()});
                throw new ChatServerException(SilverpeasExceptionMessages.failureOnAdding((String)XMPP_USER, (Object)chatUser.getId()));
            }
        }
        catch (Exception e) {
            this.logger.error(ERROR_USER_ADD_PATTERN, new Object[]{e.getMessage()});
            throw new ChatServerException(SilverpeasExceptionMessages.failureOnAdding((String)XMPP_USER, (Object)chatUser.getId()), e);
        }
    }

    @Override
    public void deleteUser(User user) {
        ChatUser chatUser = ChatUser.fromUser(user);
        try (HttpRequester requester = this.request(this.url, chatUser.getChatLogin());
             Response response = requester.delete();){
            if (response.getStatus() != 200) {
                this.logger.error(ERROR_USER_DEL_PATTERN, new Object[]{response.getStatusInfo().getReasonPhrase()});
                throw new ChatServerException(SilverpeasExceptionMessages.failureOnDeleting((String)XMPP_USER, (Object)chatUser.getId()));
            }
        }
        catch (Exception e) {
            this.logger.error(ERROR_USER_DEL_PATTERN, new Object[]{e.getMessage()});
            throw new ChatServerException(SilverpeasExceptionMessages.failureOnDeleting((String)XMPP_USER, (Object)chatUser.getId()), e);
        }
    }

    @Override
    public void createRelationShip(User user1, User user2) {
        ChatUser chatUser1 = ChatUser.fromUser(user1);
        ChatUser chatUser2 = ChatUser.fromUser(user2);
        try (HttpRequester requester = this.request(this.url, chatUser1.getChatLogin(), "roster");
             Response response = requester.post(o -> o.put("jid", chatUser2.getChatId()).put("subscriptionType", "3"));){
            if (response.getStatus() == 409) {
                this.logger.warn("The XMPP relationship between users {0} and {1} already exists!", new Object[]{chatUser1.getId(), chatUser2.getId()});
            } else if (response.getStatus() != 201) {
                this.logger.error(ERROR_RELATIONSHIP_ADD_PATTERN, new Object[]{response.getStatusInfo().getReasonPhrase()});
                throw new ChatServerException(SilverpeasExceptionMessages.failureOnAdding((String)XMPP_RELATIONSHIP, (Object)(chatUser1.getId() + BETWEEN + chatUser2.getId())));
            }
        }
        catch (Exception e) {
            this.logger.error(ERROR_RELATIONSHIP_ADD_PATTERN, new Object[]{e.getMessage()});
            throw new ChatServerException(SilverpeasExceptionMessages.failureOnAdding((String)XMPP_RELATIONSHIP, (Object)(chatUser1.getId() + BETWEEN + chatUser2.getId())), e);
        }
    }

    @Override
    public void deleteRelationShip(User user1, User user2) {
        ChatUser chatUser1 = ChatUser.fromUser(user1);
        ChatUser chatUser2 = ChatUser.fromUser(user2);
        try (HttpRequester requester = this.request(chatUser1.getChatLogin(), "roster", chatUser2.getChatId());
             Response response = requester.delete();){
            if (response.getStatus() != 200) {
                this.logger.error(ERROR_RELATIONSHIP_DEL_PATTERN, new Object[]{response.getStatusInfo().getReasonPhrase()});
                throw new ChatServerException(SilverpeasExceptionMessages.failureOnDeleting((String)XMPP_RELATIONSHIP, (Object)(chatUser1.getId() + BETWEEN + chatUser2.getId())));
            }
        }
        catch (Exception e) {
            this.logger.error(ERROR_RELATIONSHIP_ADD_PATTERN, new Object[]{e.getMessage()});
            throw new ChatServerException(SilverpeasExceptionMessages.failureOnAdding((String)XMPP_RELATIONSHIP, (Object)(chatUser1.getId() + BETWEEN + chatUser2.getId())), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUserExisting(User user) {
        ChatUser chatUser = ChatUser.fromUser(user);
        try (HttpRequester requester = this.request(this.url, chatUser.getChatLogin());){
            boolean bl;
            block14: {
                Response response = requester.head();
                try {
                    boolean bl2 = bl = response.getStatus() == 200;
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return bl;
        }
        catch (Exception e) {
            this.logger.error("Error while checking XMPP user: ", new Object[]{e.getMessage()});
            throw new ChatServerException(SilverpeasExceptionMessages.failureOnGetting((String)XMPP_USER, (Object)chatUser.getId()));
        }
    }

    private HttpRequester request(String url, String ... path) {
        return this.theRequester.at(url, path);
    }
}

