/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.inject.Singleton;
import org.apache.commons.text.StringTokenizer;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.silverstatistics.volume.dao.SilverStatisticsDAO;
import org.silverpeas.core.silverstatistics.volume.dao.SilverStatisticsManagerDAO;
import org.silverpeas.core.silverstatistics.volume.model.SilverStatisticsConfigException;
import org.silverpeas.core.silverstatistics.volume.model.StatType;
import org.silverpeas.core.silverstatistics.volume.model.StatisticsConfig;
import org.silverpeas.core.silverstatistics.volume.model.StatisticsRuntimeException;
import org.silverpeas.core.silverstatistics.volume.service.SilverStatistics;
import org.silverpeas.core.silverstatistics.volume.service.SilverStatisticsVolumeAlimentation;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
public class SilverStatisticsService
implements SilverStatistics {
    private final StatisticsConfig myStatsConfig = new StatisticsConfig();

    @Override
    public void putStats(StatType type, String data) {
        StringTokenizer stData = new StringTokenizer(data, "&&&");
        List dataArray = stData.getTokenList();
        if (this.myStatsConfig.areGoodData(type, dataArray)) {
            try (Connection myCon = DBUtil.openConnection();){
                SilverStatisticsDAO.putDataStats(myCon, type, dataArray, this.myStatsConfig);
                if (!myCon.getAutoCommit()) {
                    myCon.commit();
                }
            }
            catch (SQLException | StatisticsRuntimeException e) {
                SilverLogger.getLogger((Object)this).error("typeOfStats={0}, dataArray={1}", new Object[]{type, dataArray}, (Throwable)e);
            }
        } else {
            SilverLogger.getLogger((Object)this).error("input data={0} for {1}", new Object[]{data, type});
        }
    }

    @Override
    public void makeVolumeAlimentationForAllComponents() {
        SilverStatisticsVolumeAlimentation.makeVolumeAlimentationForAllComponents();
    }

    @Override
    public void makeStatAllCumul() {
        SilverStatisticsManagerDAO.makeStatAllCumul(this.myStatsConfig);
    }

    public SilverStatisticsService() {
        try {
            this.myStatsConfig.init();
        }
        catch (SilverStatisticsConfigException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)((Object)e));
        }
    }
}

