/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.silverpeas.core.silverstatistics.volume.model.SilverStatisticsTypeStatisticsException;
import org.silverpeas.core.silverstatistics.volume.model.StatDataType;
import org.silverpeas.core.silverstatistics.volume.model.StatisticMode;
import org.silverpeas.kernel.util.StringUtil;

public class TypeStatistics {
    public static final String STATISTIC_DATE_KEY = "dateStat";
    private String name = "";
    private String tableName = "";
    private int purgeInMonth = 3;
    private final List<String> allKeysName = new ArrayList<String>();
    private final List<StatDataType> allKeysValue = new ArrayList<StatDataType>();
    private final List<String> cumulKeysName = new ArrayList<String>();
    private boolean isRun = true;
    private boolean isAsynchron = true;
    private StatisticMode modeCumul = StatisticMode.Add;

    TypeStatistics() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws SilverStatisticsTypeStatisticsException {
        if (!StringUtil.isDefined((String)name)) {
            throw new SilverStatisticsTypeStatisticsException("Statistics name empty", name);
        }
        this.name = name;
    }

    public StatisticMode getModeCumul() {
        return this.modeCumul;
    }

    public void setModeCumul(StatisticMode mode) {
        this.modeCumul = mode;
    }

    public void setIsRun(boolean value) {
        this.isRun = value;
    }

    public boolean isRun() {
        return this.isRun;
    }

    public void setIsAsynchron(boolean value) {
        this.isAsynchron = value;
    }

    public boolean isAsynchron() {
        return this.isAsynchron;
    }

    public int getPurge() {
        return this.purgeInMonth;
    }

    public void setPurge(int purgeInMonth) throws SilverStatisticsTypeStatisticsException {
        if (purgeInMonth <= 0) {
            throw new SilverStatisticsTypeStatisticsException("Purge bad value", this.name);
        }
        this.purgeInMonth = purgeInMonth;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) throws SilverStatisticsTypeStatisticsException {
        if (!StringUtil.isDefined((String)tableName)) {
            throw new SilverStatisticsTypeStatisticsException("The statistics table name is empty", tableName);
        }
        this.tableName = tableName;
    }

    public List<String> getAllKeys() {
        return this.allKeysName;
    }

    public void setAllKeys(Collection<String> allTags) {
        this.allKeysName.addAll(allTags);
    }

    public void addKey(String keyName, StatDataType keyType) throws SilverStatisticsTypeStatisticsException {
        if (!StringUtil.isDefined((String)keyName)) {
            throw new SilverStatisticsTypeStatisticsException("The statistics key name is empty", this.name);
        }
        if (keyType == null) {
            throw new SilverStatisticsTypeStatisticsException("The statistics type name is empty", this.name);
        }
        this.allKeysName.add(keyName);
        this.allKeysValue.add(keyType);
    }

    public void addCumulKey(String keyName) throws SilverStatisticsTypeStatisticsException {
        if (!StringUtil.isDefined((String)keyName)) {
            throw new SilverStatisticsTypeStatisticsException("The statistics cumulative key name is empty", this.name);
        }
        if (!this.hasACumulType(keyName)) {
            throw new SilverStatisticsTypeStatisticsException("The statistics cumulative type name is empty", this.name, keyName);
        }
        this.cumulKeysName.add(keyName);
    }

    public int indexOfKey(String keyName) {
        return this.allKeysName.indexOf(keyName);
    }

    public boolean isCumulKey(String keyName) {
        return this.cumulKeysName.contains(keyName);
    }

    public boolean isDateStatKeyExist() {
        return this.allKeysName.contains(STATISTIC_DATE_KEY);
    }

    public boolean hasACumulType(String cumulKeyName) {
        StatDataType type = this.allKeysValue.get(this.allKeysName.indexOf(cumulKeyName));
        return StatDataType.INTEGER == type || StatDataType.DECIMAL == type;
    }

    public boolean hasGoodCumulKey() {
        return !this.cumulKeysName.isEmpty();
    }

    public StatDataType getKeyType(String keyName) {
        return this.allKeysValue.get(this.allKeysName.indexOf(keyName));
    }

    public int numberOfKeys() {
        return this.allKeysName.size();
    }
}

