/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar.binaries;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.CRC32;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.BinaryReferencesIndex;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.Generation;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.InvalidBinaryReferencesIndexException;
import org.apache.jackrabbit.oak.segment.util.ReaderAtEnd;

class BinaryReferencesIndexLoaderV1 {
    static final int MAGIC = 170934794;
    static final int FOOTER_SIZE = 16;

    BinaryReferencesIndexLoaderV1() {
    }

    static Buffer loadBinaryReferencesIndex(ReaderAtEnd reader) throws IOException, InvalidBinaryReferencesIndexException {
        Buffer meta = reader.readAtEnd(16, 16);
        int crc32 = meta.getInt();
        int count = meta.getInt();
        int size = meta.getInt();
        int magic = meta.getInt();
        if (magic != 170934794) {
            throw new InvalidBinaryReferencesIndexException("Invalid magic number");
        }
        if (count < 0) {
            throw new InvalidBinaryReferencesIndexException("Invalid count");
        }
        if (size < count * 22 + 16) {
            throw new InvalidBinaryReferencesIndexException("Invalid size");
        }
        return reader.readAtEnd(size, size);
    }

    public static BinaryReferencesIndex parseBinaryReferencesIndex(Buffer buffer) throws InvalidBinaryReferencesIndexException {
        Buffer data = buffer.slice();
        data.limit(data.limit() - 16);
        buffer.position(buffer.limit() - 16);
        Buffer meta = buffer.slice();
        int crc32 = meta.getInt();
        int count = meta.getInt();
        int size = meta.getInt();
        int magic = meta.getInt();
        if (magic != 170934794) {
            throw new InvalidBinaryReferencesIndexException("Invalid magic number");
        }
        if (count < 0) {
            throw new InvalidBinaryReferencesIndexException("Invalid count");
        }
        if (size < count * 22 + 16) {
            throw new InvalidBinaryReferencesIndexException("Invalid size");
        }
        CRC32 checksum = new CRC32();
        data.mark();
        data.update(checksum);
        data.reset();
        if ((int)checksum.getValue() != crc32) {
            throw new InvalidBinaryReferencesIndexException("Invalid checksum");
        }
        return new BinaryReferencesIndex(BinaryReferencesIndexLoaderV1.parseBinaryReferencesIndex(count, data));
    }

    private static Map<Generation, Map<UUID, Set<String>>> parseBinaryReferencesIndex(int count, Buffer buffer) {
        HashMap<Generation, Map<UUID, Set<String>>> result = new HashMap<Generation, Map<UUID, Set<String>>>(count);
        for (int i = 0; i < count; ++i) {
            Generation k = BinaryReferencesIndexLoaderV1.parseGeneration(buffer);
            Map<UUID, Set<String>> v = BinaryReferencesIndexLoaderV1.parseEntriesBySegment(buffer);
            result.put(k, v);
        }
        return result;
    }

    private static Generation parseGeneration(Buffer buffer) {
        int generation = buffer.getInt();
        return new Generation(generation, generation, true);
    }

    private static Map<UUID, Set<String>> parseEntriesBySegment(Buffer buffer) {
        return BinaryReferencesIndexLoaderV1.parseEntriesBySegment(buffer.getInt(), buffer);
    }

    private static Map<UUID, Set<String>> parseEntriesBySegment(int count, Buffer buffer) {
        HashMap<UUID, Set<String>> result = new HashMap<UUID, Set<String>>(count);
        for (int i = 0; i < count; ++i) {
            UUID k = BinaryReferencesIndexLoaderV1.parseUUID(buffer);
            Set<String> v = BinaryReferencesIndexLoaderV1.parseEntries(buffer);
            result.put(k, v);
        }
        return result;
    }

    private static UUID parseUUID(Buffer buffer) {
        long msb = buffer.getLong();
        long lsb = buffer.getLong();
        return new UUID(msb, lsb);
    }

    private static Set<String> parseEntries(Buffer buffer) {
        return BinaryReferencesIndexLoaderV1.parseEntries(buffer.getInt(), buffer);
    }

    private static Set<String> parseEntries(int count, Buffer buffer) {
        HashSet<String> entries = new HashSet<String>(count);
        for (int i = 0; i < count; ++i) {
            entries.add(BinaryReferencesIndexLoaderV1.parseString(buffer));
        }
        return entries;
    }

    private static String parseString(Buffer buffer) {
        return BinaryReferencesIndexLoaderV1.parseString(buffer.getInt(), buffer);
    }

    private static String parseString(int length, Buffer buffer) {
        byte[] data = new byte[length];
        buffer.get(data);
        return new String(data, StandardCharsets.UTF_8);
    }
}

