/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.jackrabbit.guava.common.util.concurrent.UncheckedExecutionException;
import org.apache.jackrabbit.oak.commons.pio.Closer;
import org.apache.jackrabbit.oak.segment.DefaultSegmentWriterBuilder;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.AbstractFileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyRevisions;
import org.apache.jackrabbit.oak.segment.file.Reclaimers;
import org.apache.jackrabbit.oak.segment.file.tar.TarFiles;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyFileStore
extends AbstractFileStore {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyFileStore.class);
    private final TarFiles tarFiles;
    @NotNull
    private final SegmentWriter writer;
    private final int gcRetainedGenerations;
    private ReadOnlyRevisions revisions;
    private RecordId currentHead;

    ReadOnlyFileStore(FileStoreBuilder builder) throws InvalidFileStoreVersionException, IOException {
        super(builder);
        ReadOnlyFileStore.newManifestChecker(builder.getPersistence(), builder.getStrictVersionCheck()).checkManifest();
        this.tarFiles = TarFiles.builder().withDirectory(this.directory).withTarRecovery(this.recovery).withIOMonitor(this.ioMonitor).withRemoteStoreMonitor(this.remoteStoreMonitor).withMemoryMapping(this.memoryMapping).withReadOnly().withPersistence(builder.getPersistence()).withInitialisedReadersAndWriters(false).build();
        this.tarFiles.init();
        this.writer = DefaultSegmentWriterBuilder.defaultSegmentWriterBuilder("read-only").withoutCache().build(this);
        this.gcRetainedGenerations = builder.getGcOptions().getRetainedGenerations();
        log.info("TarMK ReadOnly opened: {} (mmap={})", (Object)this.directory, (Object)this.memoryMapping);
    }

    ReadOnlyFileStore bind(@NotNull ReadOnlyRevisions revisions) throws IOException {
        this.revisions = revisions;
        this.revisions.bind(this, this.tracker);
        this.currentHead = revisions.getHead();
        return this;
    }

    public void setRevision(String revision) {
        RecordId newHead = RecordId.fromString(this.tracker, revision);
        if (this.revisions.setHead(this.currentHead, newHead, new Revisions.Option[0])) {
            this.currentHead = newHead;
        }
    }

    @Override
    public void writeSegment(SegmentId id, byte[] data, int offset, int length) {
        throw new UnsupportedOperationException("Read Only Store");
    }

    @Override
    public boolean containsSegment(SegmentId id) {
        return this.tarFiles.containsSegment(id.getMostSignificantBits(), id.getLeastSignificantBits());
    }

    @Override
    @NotNull
    public Segment readSegment(final SegmentId id) {
        try {
            return this.segmentCache.getSegment(id, new Callable<Segment>(){

                @Override
                public Segment call() throws Exception {
                    return ReadOnlyFileStore.this.readSegmentUncached(ReadOnlyFileStore.this.tarFiles, id);
                }
            });
        }
        catch (ExecutionException | UncheckedExecutionException e) {
            throw ReadOnlyFileStore.asSegmentNotFoundException((Exception)e, id);
        }
    }

    @Override
    public void close() {
        Closer closer = Closer.create();
        closer.register((Closeable)this.tarFiles);
        closer.register((Closeable)this.revisions);
        ReadOnlyFileStore.closeAndLogOnFail((Closeable)closer);
        System.gc();
        log.info("TarMK closed: {}", (Object)this.directory);
    }

    @Override
    @NotNull
    public SegmentWriter getWriter() {
        return this.writer;
    }

    public Map<String, Set<UUID>> getTarReaderIndex() {
        return this.tarFiles.getIndices();
    }

    public Map<UUID, Set<UUID>> getTarGraph(String fileName) throws IOException {
        return this.tarFiles.getGraph(fileName);
    }

    public Iterable<SegmentId> getSegmentIds() {
        ArrayList<SegmentId> ids = new ArrayList<SegmentId>();
        for (UUID id : this.tarFiles.getSegmentIds()) {
            long msb = id.getMostSignificantBits();
            long lsb = id.getLeastSignificantBits();
            ids.add(this.tracker.newSegmentId(msb, lsb));
        }
        return ids;
    }

    @Override
    public ReadOnlyRevisions getRevisions() {
        return this.revisions;
    }

    public Set<SegmentId> getReferencedSegmentIds() {
        return this.tracker.getReferencedSegmentIds();
    }

    @Override
    public void collectBlobReferences(Consumer<String> collector) throws IOException {
        this.tarFiles.collectBlobReferences(collector, Reclaimers.newOldReclaimer(SegmentGCOptions.GCType.FULL, this.revisions.getHead().getSegmentId().getGcGeneration(), this.gcRetainedGenerations));
    }
}

