/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.security.authorization.permission.CacheStrategyImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.EntryPredicate;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionCache;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionCacheBuilder;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntryProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStore;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.jetbrains.annotations.NotNull;

class PermissionEntryProviderImpl
implements PermissionEntryProvider {
    private final Set<String> principalNames;
    private final PermissionStore store;
    private final ConfigurationParameters options;
    private boolean noExistingNames;
    private boolean initialized = false;
    private boolean isRefreshed = false;
    private PermissionCache permissionCache;

    PermissionEntryProviderImpl(@NotNull PermissionStore store, @NotNull Set<String> principalNames, @NotNull ConfigurationParameters options) {
        this.store = store;
        this.principalNames = Collections.unmodifiableSet(principalNames);
        this.options = options;
    }

    private void init() {
        if (!this.initialized) {
            PermissionCacheBuilder builder = new PermissionCacheBuilder(this.store);
            this.noExistingNames = builder.init(this.principalNames, new CacheStrategyImpl(this.options, this.isRefreshed));
            this.permissionCache = builder.build();
            this.initialized = true;
        }
    }

    @Override
    public void flush() {
        this.initialized = false;
        this.isRefreshed = true;
    }

    @Override
    @NotNull
    public Iterator<PermissionEntry> getEntryIterator(@NotNull EntryPredicate predicate) {
        this.init();
        if (this.noExistingNames) {
            return Collections.emptyIterator();
        }
        return new EntryIterator(predicate);
    }

    @Override
    @NotNull
    public Collection<PermissionEntry> getEntries(@NotNull Tree accessControlledTree) {
        this.init();
        return this.permissionCache.getEntries(accessControlledTree);
    }

    private final class EntryIterator
    extends AbstractLazyIterator<PermissionEntry> {
        private final EntryPredicate predicate;
        private Iterator<PermissionEntry> nextEntries = Collections.emptyIterator();
        private String path;

        private EntryIterator(EntryPredicate predicate) {
            this.predicate = predicate;
            this.path = Objects.toString(predicate.getPath(), "");
        }

        protected PermissionEntry getNext() {
            PermissionEntry next = null;
            while (next == null) {
                if (this.nextEntries.hasNext()) {
                    PermissionEntry pe = this.nextEntries.next();
                    if (!this.predicate.test(pe)) continue;
                    next = pe;
                    continue;
                }
                if (this.path == null) break;
                this.nextEntries = this.getEntries(this.path).iterator();
                this.path = PermissionUtil.getParentPathOrNull(this.path);
            }
            return next;
        }

        @NotNull
        private Collection<PermissionEntry> getEntries(@NotNull String path) {
            return PermissionEntryProviderImpl.this.permissionCache.getEntries(path);
        }
    }
}

