/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.cursor;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.plugins.index.cursor.AbstractCursor;
import org.apache.jackrabbit.oak.query.FilterIterators;
import org.apache.jackrabbit.oak.query.QueryImpl;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;

class IntersectionCursor
extends AbstractCursor {
    private final HashMap<String, IndexRow> secondSet = new HashMap();
    private final HashSet<String> seen = new HashSet();
    private final Cursor first;
    private final Cursor second;
    private final QueryLimits settings;
    private boolean init;
    private boolean closed;
    private IndexRow current;

    IntersectionCursor(Cursor first, Cursor second, QueryLimits settings) {
        this.first = first;
        this.second = second;
        this.settings = settings;
    }

    public IndexRow next() {
        if (this.closed) {
            throw new IllegalStateException("This cursor is closed");
        }
        if (!this.init) {
            this.fetchNext();
            this.init = true;
            if (this.closed) {
                throw new IllegalStateException("This cursor is closed");
            }
        }
        IndexRow result = this.current;
        this.init = false;
        return result;
    }

    public boolean hasNext() {
        if (!this.closed && !this.init) {
            this.fetchNext();
            this.init = true;
        }
        return !this.closed;
    }

    /*
     * Unable to fully structure code
     */
    private void fetchNext() {
        block0: while (true) {
            if (!this.first.hasNext()) {
                this.closed = true;
                return;
            }
            c = this.first.next();
            p = c.getPath();
            if (this.seen.contains(p)) continue;
            if (this.secondSet.remove(p) != null) {
                this.current = c;
                this.markSeen(p);
                return;
            }
            while (true) {
                if (this.second.hasNext()) ** break;
                continue block0;
                s = this.second.next();
                p2 = s.getPath();
                if (p.equals(p2)) {
                    this.current = c;
                    this.markSeen(p);
                    return;
                }
                this.secondSet.put(p2, s);
                FilterIterators.checkMemoryLimit(this.secondSet.size(), this.settings);
            }
            break;
        }
    }

    private void markSeen(String path) {
        this.seen.add(path);
        FilterIterators.checkMemoryLimit(this.seen.size(), this.settings);
    }

    @Override
    public long getSize(Result.SizePrecision precision, long max) {
        long a = this.first.getSize(precision, max);
        long b = this.second.getSize(precision, max);
        if (a < 0L || b < 0L) {
            return -1L;
        }
        return QueryImpl.saturatedAdd(a, b);
    }
}

