/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SecureNodeState
extends AbstractNodeState {
    private final NodeState state;
    private final TreePermission treePermission;
    private long childNodeCount = -1L;
    private long propertyCount = -1L;

    SecureNodeState(@NotNull NodeState state, @NotNull TreePermission treePermission) {
        this.state = Objects.requireNonNull(state);
        this.treePermission = Objects.requireNonNull(treePermission);
    }

    public boolean exists() {
        return this.treePermission.canRead();
    }

    @Nullable
    public PropertyState getProperty(@NotNull String name) {
        PropertyState property = this.state.getProperty(name);
        if (property != null && this.treePermission.canRead(property)) {
            return property;
        }
        return null;
    }

    public synchronized long getPropertyCount() {
        if (this.propertyCount == -1L) {
            this.propertyCount = this.treePermission.canReadProperties() ? this.state.getPropertyCount() : SecureNodeState.count((Iterable)IterableUtils.filter((Iterable)this.state.getProperties(), new ReadablePropertyPredicate()::test));
        }
        return this.propertyCount;
    }

    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        if (this.treePermission.canReadProperties()) {
            return this.state.getProperties();
        }
        return IterableUtils.filter((Iterable)this.state.getProperties(), new ReadablePropertyPredicate()::test);
    }

    public boolean hasChildNode(@NotNull String name) {
        if (!this.state.hasChildNode(name)) {
            return false;
        }
        if (this.treePermission.canReadAll()) {
            return true;
        }
        NodeState child = this.state.getChildNode(name);
        return this.treePermission.getChildPermission(name, child).canRead();
    }

    @NotNull
    public NodeState getChildNode(@NotNull String name) {
        NodeState child = this.state.getChildNode(name);
        if (child.exists() && !this.treePermission.canReadAll()) {
            MemoryChildNodeEntry entry = new MemoryChildNodeEntry(name, child);
            return new WrapChildEntryFunction().apply((ChildNodeEntry)entry).getNodeState();
        }
        return child;
    }

    public synchronized long getChildNodeCount(long max) {
        if (this.childNodeCount == -1L) {
            long count = this.treePermission.canReadAll() ? this.state.getChildNodeCount(max) : super.getChildNodeCount(max);
            if (count == Long.MAX_VALUE) {
                return count;
            }
            this.childNodeCount = count;
        }
        return this.childNodeCount;
    }

    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        if (this.treePermission.canReadAll()) {
            return this.state.getChildNodeEntries();
        }
        if (this.treePermission.canRead()) {
            Iterable readable = IterableUtils.transform((Iterable)this.state.getChildNodeEntries(), new WrapChildEntryFunction()::apply);
            return IterableUtils.filter((Iterable)readable, new IterableNodePredicate()::test);
        }
        return Collections.emptyList();
    }

    @NotNull
    public NodeBuilder builder() {
        return new MemoryNodeBuilder((NodeState)this);
    }

    private class WrapChildEntryFunction
    implements Function<ChildNodeEntry, ChildNodeEntry> {
        private WrapChildEntryFunction() {
        }

        @Override
        @NotNull
        public ChildNodeEntry apply(@NotNull ChildNodeEntry input) {
            String name = input.getName();
            NodeState child = input.getNodeState();
            TreePermission childContext = SecureNodeState.this.treePermission.getChildPermission(name, child);
            SecureNodeState secureChild = new SecureNodeState(child, childContext);
            if (child.getChildNodeCount(1L) == 0L && secureChild.treePermission.canRead() && secureChild.treePermission.canReadProperties()) {
                return input;
            }
            return new MemoryChildNodeEntry(name, (NodeState)secureChild);
        }
    }

    private static class IterableNodePredicate
    implements Predicate<ChildNodeEntry> {
        private IterableNodePredicate() {
        }

        @Override
        public boolean test(@Nullable ChildNodeEntry input) {
            return input != null && input.getNodeState().exists();
        }
    }

    private class ReadablePropertyPredicate
    implements Predicate<PropertyState> {
        private ReadablePropertyPredicate() {
        }

        @Override
        public boolean test(@Nullable PropertyState property) {
            return property != null && SecureNodeState.this.treePermission.canRead(property);
        }
    }
}

