/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.result.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.questioncontainer.answer.model.AnswerPK;
import org.silverpeas.core.questioncontainer.result.model.QuestionResult;
import org.silverpeas.core.questioncontainer.result.model.QuestionResultPK;
import org.silverpeas.core.questioncontainer.result.model.Results;

public class QuestionResultDAO {
    public static final String QUESTIONRESULTCOLUMNNAMES = "qrId, questionId, userId, answerId, qrOpenAnswer, qrNbPoints, qrPollDate, qrElapsedTime, qrParticipationId";
    private static final String DELETE_ALL_QUESTION_RESULTS = "DELETE FROM SB_Question_QuestionResult  WHERE questionId in (SELECT questionId FROM SB_Question_Question WHERE instanceId = ?)";
    private static final String SELECT = "select ";
    private static final String FROM = " from ";
    private static final String WHERE_QUESTION_ID_EQUALITY = " where questionId = ? ";
    private static final FastDateFormat formatter = FastDateFormat.getInstance((String)"yyyy/MM/dd");

    private QuestionResultDAO() {
    }

    private static QuestionResult getQuestionResultFromResultSet(ResultSet rs, ResourceReference questionPK) throws SQLException {
        String id = Integer.toString(rs.getInt(1));
        String questionId = Integer.toString(rs.getInt(2));
        String userId = rs.getString(3);
        String answerId = Integer.toString(rs.getInt(4));
        String openAnswer = rs.getString(5);
        int nbPoints = rs.getInt(6);
        String pollDate = rs.getString(7);
        int elapsedTime = rs.getInt(8);
        int participationId = rs.getInt(9);
        return new QuestionResult(new QuestionResultPK(id, (WAPrimaryKey)questionPK), new ResourceReference(questionId, questionPK.getInstanceId()), new AnswerPK(answerId, (WAPrimaryKey)questionPK), userId, openAnswer, nbPoints, pollDate, elapsedTime, participationId);
    }

    public static Collection<QuestionResult> getUserQuestionResultsToQuestion(Connection con, String userId, ResourceReference questionPK) throws SQLException {
        String tableName = new QuestionResultPK("", (WAPrimaryKey)questionPK).getTableName();
        String selectStatement = "select qrId, questionId, userId, answerId, qrOpenAnswer, qrNbPoints, qrPollDate, qrElapsedTime, qrParticipationId from " + tableName + " where questionId = ?  and userId = ? order By answerId";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            ArrayList<QuestionResult> arrayList;
            block13: {
                prepStmt.setInt(1, Integer.parseInt(questionPK.getId()));
                prepStmt.setString(2, userId);
                ResultSet rs = prepStmt.executeQuery();
                try {
                    ArrayList<QuestionResult> result = new ArrayList<QuestionResult>();
                    while (rs.next()) {
                        QuestionResult questionResult = QuestionResultDAO.getQuestionResultFromResultSet(rs, questionPK);
                        result.add(questionResult);
                    }
                    arrayList = result;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    public static Collection<String> getUsersByAnswer(Connection con, String answerId) throws SQLException {
        String tableName = "SB_Question_QuestionResult";
        String selectStatement = "select userId from " + tableName + " where answerId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            ArrayList<String> arrayList;
            block13: {
                prepStmt.setInt(1, Integer.parseInt(answerId));
                ResultSet rs = prepStmt.executeQuery();
                try {
                    ArrayList<String> result = new ArrayList<String>();
                    while (rs.next()) {
                        String userId = rs.getString(1);
                        result.add(userId);
                    }
                    arrayList = result;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    public static Collection<QuestionResult> getUserQuestionResultsToQuestionByParticipation(Connection con, String userId, ResourceReference questionPK, int participationId) throws SQLException {
        String tableName = new QuestionResultPK("", (WAPrimaryKey)questionPK).getTableName();
        String selectStatement = "select qrId, questionId, userId, answerId, qrOpenAnswer, qrNbPoints, qrPollDate, qrElapsedTime, qrParticipationId from " + tableName + " where questionId = ?  and userId = ?  and qrParticipationId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            ArrayList<QuestionResult> arrayList;
            block13: {
                prepStmt.setInt(1, Integer.parseInt(questionPK.getId()));
                prepStmt.setString(2, userId);
                prepStmt.setInt(3, participationId);
                ResultSet rs = prepStmt.executeQuery();
                try {
                    ArrayList<QuestionResult> result = new ArrayList<QuestionResult>();
                    while (rs.next()) {
                        QuestionResult questionResult = QuestionResultDAO.getQuestionResultFromResultSet(rs, questionPK);
                        result.add(questionResult);
                    }
                    arrayList = result;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    public static Collection<QuestionResult> getQuestionResultToQuestion(Connection con, ResourceReference questionPK) throws SQLException {
        String tableName = new QuestionResultPK("", (WAPrimaryKey)questionPK).getTableName();
        String selectStatement = "select qrId, questionId, userId, answerId, qrOpenAnswer, qrNbPoints, qrPollDate, qrElapsedTime, qrParticipationId from " + tableName + WHERE_QUESTION_ID_EQUALITY;
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            ArrayList<QuestionResult> arrayList;
            block13: {
                prepStmt.setInt(1, Integer.parseInt(questionPK.getId()));
                ResultSet rs = prepStmt.executeQuery();
                try {
                    ArrayList<QuestionResult> result = new ArrayList<QuestionResult>();
                    while (rs.next()) {
                        QuestionResult questionResult = QuestionResultDAO.getQuestionResultFromResultSet(rs, questionPK);
                        result.add(questionResult);
                    }
                    arrayList = result;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    public static Collection<QuestionResult> getQuestionResultToQuestionByParticipation(Connection con, ResourceReference questionPK, int participationId) throws SQLException {
        String tableName = new QuestionResultPK("", (WAPrimaryKey)questionPK).getTableName();
        String selectStatement = "select qrId, questionId, userId, answerId, qrOpenAnswer, qrNbPoints, qrPollDate, qrElapsedTime, qrParticipationId from " + tableName + " where questionId = ?  and qrParticipationId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            ArrayList<QuestionResult> arrayList;
            block13: {
                prepStmt.setInt(1, Integer.parseInt(questionPK.getId()));
                prepStmt.setInt(2, participationId);
                ResultSet rs = prepStmt.executeQuery();
                try {
                    ArrayList<QuestionResult> result = new ArrayList<QuestionResult>();
                    while (rs.next()) {
                        QuestionResult questionResult = QuestionResultDAO.getQuestionResultFromResultSet(rs, questionPK);
                        result.add(questionResult);
                    }
                    arrayList = result;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    public static void setQuestionResultToUser(Connection con, QuestionResult result) throws SQLException {
        String questionId = result.getQuestionPK().getId();
        String answerId = result.getAnswerPK().getId();
        String userId = result.getUserId();
        String openAnswer = result.getOpenedAnswer();
        int nbPoints = result.getNbPoints();
        String voteDate = result.getVoteDate() == null ? formatter.format(new Date()) : result.getVoteDate();
        int elapsedTime = result.getElapsedTime();
        int participationId = result.getParticipationId();
        int newId = DBUtil.getNextId((String)"sb_question_questionresult", (String)"qrId");
        String selectStatement = "INSERT INTO sb_question_questionresult VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            prepStmt.setInt(1, newId);
            prepStmt.setInt(2, Integer.parseInt(questionId));
            prepStmt.setString(3, userId);
            prepStmt.setInt(4, Integer.parseInt(answerId));
            prepStmt.setString(5, openAnswer);
            prepStmt.setInt(6, nbPoints);
            prepStmt.setString(7, voteDate);
            prepStmt.setInt(8, elapsedTime);
            prepStmt.setInt(9, participationId);
            prepStmt.executeUpdate();
        }
    }

    public static void deleteQuestionResultToQuestion(Connection con, ResourceReference questionPK) throws SQLException {
        String deleteStatement = "DELETE FROM sb_question_questionresult WHERE questionId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(deleteStatement);){
            prepStmt.setInt(1, Integer.parseInt(questionPK.getId()));
            prepStmt.executeUpdate();
        }
    }

    public static void setDeleteAllQuestionResultsByInstanceId(Connection con, String instanceId) throws SQLException {
        try (PreparedStatement deletion = con.prepareStatement(DELETE_ALL_QUESTION_RESULTS);){
            deletion.setString(1, instanceId);
            deletion.execute();
        }
    }

    public static QuestionResult getUserAnswerToQuestion(Connection con, String userId, ResourceReference questionPK, AnswerPK answerPK) throws SQLException {
        String tableName = "SB_Question_QuestionResult";
        String selectStatement = "select qrId, questionId, userId, answerId, qrOpenAnswer, qrNbPoints, qrPollDate, qrElapsedTime, qrParticipationId from " + tableName + " where questionId = ?  and answerId = ?  and userId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            QuestionResult questionResult;
            block16: {
                ResultSet rs;
                block14: {
                    QuestionResult questionResult2;
                    block15: {
                        prepStmt.setInt(1, Integer.parseInt(questionPK.getId()));
                        prepStmt.setInt(2, Integer.parseInt(answerPK.getId()));
                        prepStmt.setString(3, userId);
                        rs = prepStmt.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            questionResult2 = QuestionResultDAO.getQuestionResultFromResultSet(rs, questionPK);
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return questionResult2;
                }
                questionResult = null;
                if (rs == null) break block16;
                rs.close();
            }
            return questionResult;
        }
    }

    public static Results getResults(Connection con, List<ResourceReference> pks) throws SQLException {
        String tableName = new QuestionResultPK("").getTableName();
        Results results = new Results();
        List ids = pks.stream().map(WAPrimaryKey::getId).collect(Collectors.toList());
        ResourceReference firstQuestionPK = pks.get(0);
        String selectStatement = "select qrId, questionId, userId, answerId, qrOpenAnswer, qrNbPoints, qrPollDate, qrElapsedTime, qrParticipationId from " + tableName + " where questionId in (" + StringUtils.join(ids, (char)',') + ") order by answerId asc";
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            Results results2;
            block13: {
                ResultSet rs = prepStmt.executeQuery();
                try {
                    while (rs.next()) {
                        QuestionResult questionResult = QuestionResultDAO.getQuestionResultFromResultSet(rs, firstQuestionPK);
                        results.addQuestionResult(questionResult);
                    }
                    results2 = results;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return results2;
        }
    }
}

