/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.warupdater;

import com.sun.portal.portletcontainer.common.PortletContainerUtil;
import com.sun.portal.portletcontainer.warupdater.PortletWarUpdaterException;
import com.sun.portal.portletcontainer.warupdater.PortletWarUpdaterUtil;
import com.sun.portal.portletcontainer.warupdater.WebXMLDocumentHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletWebAppUpdater {
    private static Logger logger = PortletWarUpdaterUtil.getLogger(PortletWebAppUpdater.class, "PWULogMessages");
    private static final String PAE_SERVLET_NAME = "PortletAppEngineServlet";
    private static final String PAE_SERVLET_MAPPING = "/servlet/PortletAppEngineServlet";
    private static final String SERVLET_CLASS_NAME = "com.sun.portal.portletcontainer.appengine.PortletAppEngineServlet";
    private static final String PAE_FILTER_NAME = "PortletAppEngineFilter";
    private static final String FILTER_CLASS_NAME = "com.sun.portal.portletcontainer.appengine.PortletAppEngineFilter";
    private static final String LOAD_ON_STARTUP_PROPERTY = "portlet.loadOnStartup";
    private static final String VENDOR_PORTLET_XML_PREFIX = "vendorPortletXML";
    private static final List contextParams = new ArrayList();
    private static final String CONTEXT_PARAM = "context-param";
    private static final String PARAM_NAME = "param-name";
    private static final String PARAM_VALUE = "param-value";
    private static final String LISTENER = "listener";
    private static final String LISTENER_CLASS = "listener-class";
    private static final String SERVLET = "servlet";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String SERVLET_CLASS = "servlet-class";
    private static final String LOAD_ON_STARTUP = "load-on-startup";
    private static final String SERVLET_MAPPING = "servlet-mapping";
    private static final String FILTER = "filter";
    private static final String FILTER_NAME = "filter-name";
    private static final String FILTER_CLASS = "filter-class";
    private static final String FILTER_MAPPING = "filter-mapping";
    private static final String DISPATCHER_NAME = "dispatcher";
    private static final String DISPATCHER_TYPE = "INCLUDE";
    private static final String URL_PATTERN = "url-pattern";
    private static final String SECURITY_ROLE = "security-role";
    private static final String ROLE_NAME = "role-name";
    private static final String TAGLIB = "taglib";
    private static final String JSP_CONFIG = "jsp-config";
    private static final String TAGLIB_URI = "taglib-uri";
    private static final String TAGLIB_LOCATION = "taglib-location";
    private static final String taglibURI_1 = "http://java.sun.com/portlet";
    private static final String taglibLocation_1 = "/WEB-INF/sun-portlet.tld";
    private static final String taglibURI_2 = "http://java.sun.com/portlet_2_0";
    private static final String taglibLocation_2 = "/WEB-INF/sun-portlet_2_0.tld";
    private static final String contextParamComment = "Init Parameters";
    private static final String servletComment = "PortletAppEngine Servlet";
    private static final String filterComment = "PortletAppEngine Filter";
    private static final String servletMappingComment = "PAE Servlet Mapping";
    private static final String filterMappingComment = "PAE Filter Mapping";
    private static final String taglibComment_1 = "taglib for portlet v1.0";
    private static final String taglibComment_2 = "taglib for portlet v2.0";
    private static List elementBeforeContextParam;
    private static List elementBeforeFilter;
    private static List elementBeforeFilterMapping;
    private static List elementBeforeListener;
    private static List elementBeforeTaglib;
    private static List elementBeforeServletMapping;
    private static final String WEB_APP_VERSION = "version";
    private static final String WEB_APP_2_4 = "2.4";
    private static final String WEB_APP_2_5 = "2.5";
    private static final String LINE_BREAK = "/n";

    public static List<String> getRoles(InputStream in) throws IOException, PortletWarUpdaterException {
        Document doc = PortletWebAppUpdater.readFile(in);
        Element root = PortletWebAppUpdater.getRootElement(doc);
        ArrayList<String> roles = new ArrayList<String>();
        List sRoleElements = WebXMLDocumentHelper.getChildElements(root, SECURITY_ROLE);
        for (int i = 0; i < sRoleElements.size(); ++i) {
            String role;
            Element sRoleElement = (Element)sRoleElements.get(i);
            Element roleName = WebXMLDocumentHelper.getChildElement(sRoleElement, ROLE_NAME);
            if (roleName == null || (role = WebXMLDocumentHelper.getTextTrim(roleName)) == null || role.length() == 0) continue;
            roles.add(role);
        }
        return roles;
    }

    protected static File addWebAppParam(InputStream in, Properties configProps, String portletAppName) throws IOException, PortletWarUpdaterException {
        Document doc = PortletWebAppUpdater.readFile(in);
        Element root = PortletWebAppUpdater.getRootElement(doc);
        boolean updated = PortletWebAppUpdater.isWebAppUpdated(root, configProps);
        if (updated) {
            try {
                PortletWebAppUpdater.removeElements(root, doc, configProps);
            }
            catch (PortletWarUpdaterException pe) {
                throw new PortletWarUpdaterException("errorIllegalAdd", pe);
            }
        }
        try {
            String version = PortletWebAppUpdater.getWebAppVersion(root);
            logger.log(Level.FINER, "PSPL_CSPPCWU0012", version);
            if (version != null && (version.equals(WEB_APP_2_4) || version.equals(WEB_APP_2_5))) {
                PortletWebAppUpdater.addElementsAsPer2_4Schema(root, doc, configProps);
            } else {
                PortletWebAppUpdater.addElements(root, doc, configProps);
            }
        }
        catch (DOMException de) {
            throw new PortletWarUpdaterException("errorIllegalAdd", de);
        }
        return PortletWebAppUpdater.createUpdatedFile(doc);
    }

    protected static File removeWebAppParam(InputStream in, Properties configProps) throws IOException, PortletWarUpdaterException {
        Document doc = PortletWebAppUpdater.readFile(in);
        Element root = PortletWebAppUpdater.getRootElement(doc);
        try {
            PortletWebAppUpdater.removeElements(root, doc, configProps);
        }
        catch (DOMException de) {
            throw new PortletWarUpdaterException("errorIllegalAdd", de);
        }
        return PortletWebAppUpdater.createUpdatedFile(doc);
    }

    protected static boolean isWebAppUpdated(InputStream in, Properties configProps) throws PortletWarUpdaterException {
        Document doc = PortletWebAppUpdater.readFile(in);
        Element root = PortletWebAppUpdater.getRootElement(doc);
        return PortletWebAppUpdater.isWebAppUpdated(root, configProps);
    }

    private static boolean isWebAppUpdated(Element root, Properties configProps) throws PortletWarUpdaterException {
        boolean updated = false;
        List<Node> children = WebXMLDocumentHelper.getElementList(root);
        for (Element element : children) {
            String param;
            if (element.getTagName().equals(CONTEXT_PARAM)) {
                param = WebXMLDocumentHelper.getChildTextTrim(element, PARAM_NAME);
                if (!contextParams.contains(param)) continue;
                updated = true;
                return updated;
            }
            if (!element.getTagName().equals(SERVLET) || !(param = WebXMLDocumentHelper.getChildTextTrim(element, SERVLET_NAME)).equals(PAE_SERVLET_NAME)) continue;
            updated = true;
            return updated;
        }
        return updated;
    }

    protected static Document readFile(InputStream webStream) throws PortletWarUpdaterException {
        try {
            return PortletContainerUtil.getDocumentBuilder().parse(webStream);
        }
        catch (ParserConfigurationException pce) {
            throw new PortletWarUpdaterException(pce);
        }
        catch (SAXException saxe) {
            throw new PortletWarUpdaterException(saxe);
        }
        catch (IOException ioe) {
            throw new PortletWarUpdaterException(ioe);
        }
    }

    protected static Element getRootElement(Document document) {
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    protected static synchronized File createUpdatedFile(Document document) throws IOException, PortletWarUpdaterException {
        File newWebXMLFile = File.createTempFile("web", ".xml");
        newWebXMLFile.deleteOnExit();
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            PortletWebAppUpdater.setOutputDoctype(document, transformer);
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "5");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(newWebXMLFile);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException tce) {
            throw new PortletWarUpdaterException(tce);
        }
        catch (TransformerException te) {
            throw new PortletWarUpdaterException(te);
        }
        return newWebXMLFile;
    }

    private static void setOutputDoctype(Document document, Transformer transformer) {
        DocumentType doctype = document.getDoctype();
        if (doctype != null) {
            String id = doctype.getSystemId();
            if (id == null || id.length() == 0) {
                return;
            }
            transformer.setOutputProperty("doctype-system", id);
            id = doctype.getPublicId();
            if (id == null || id.length() == 0) {
                return;
            }
            transformer.setOutputProperty("doctype-public", id);
        }
    }

    private static void addElements(Element root, Document doc, Properties configProps) throws DOMException {
        int i;
        List<Node> children = WebXMLDocumentHelper.getElementList(root);
        int size = children.size();
        int newSize = size + contextParams.size() + 1;
        ArrayList<Node> newChildren = new ArrayList<Node>(newSize);
        int j = 0;
        boolean addContextParam = false;
        for (i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            if (!elementBeforeContextParam.contains(child.getTagName())) {
                newChildren.addAll(PortletWebAppUpdater.genContextParamElements(doc, configProps));
                addContextParam = true;
                break;
            }
            newChildren.add(child);
        }
        if (!addContextParam) {
            newChildren.addAll(PortletWebAppUpdater.genContextParamElements(doc, configProps));
        }
        boolean addFilterParam = false;
        for (j = i; j < size; ++j) {
            Element child = (Element)children.get(j);
            if (!elementBeforeFilter.contains(child.getTagName())) {
                newChildren.addAll(PortletWebAppUpdater.genFilterElements(doc, configProps));
                addFilterParam = true;
                break;
            }
            newChildren.add(child);
        }
        if (!addFilterParam) {
            newChildren.addAll(PortletWebAppUpdater.genFilterElements(doc, configProps));
        }
        boolean addFilterMappingParam = false;
        for (j = i; j < size; ++j) {
            Element child = (Element)children.get(j);
            if (!elementBeforeFilterMapping.contains(child.getTagName())) {
                newChildren.addAll(PortletWebAppUpdater.genFilterMappingElements(doc));
                addFilterMappingParam = true;
                break;
            }
            newChildren.add(child);
        }
        if (!addFilterMappingParam) {
            newChildren.addAll(PortletWebAppUpdater.genFilterMappingElements(doc));
        }
        boolean addServletParam = false;
        for (j = i; j < size; ++j) {
            Element child = (Element)children.get(j);
            if (!elementBeforeListener.contains(child.getTagName())) {
                newChildren.addAll(PortletWebAppUpdater.genServletElements(doc, configProps));
                addServletParam = true;
                break;
            }
            newChildren.add(child);
        }
        if (!addServletParam) {
            newChildren.addAll(PortletWebAppUpdater.genServletElements(doc, configProps));
        }
        boolean addServletMappingParam = false;
        for (i = j; i < size; ++i) {
            Element child = (Element)children.get(i);
            if (!elementBeforeServletMapping.contains(child.getTagName())) {
                newChildren.addAll(PortletWebAppUpdater.genServletMappingElements(doc));
                addServletMappingParam = true;
                break;
            }
            newChildren.add(child);
        }
        if (!addServletMappingParam) {
            newChildren.addAll(PortletWebAppUpdater.genServletMappingElements(doc));
        }
        boolean addTaglibParam = false;
        for (j = i; j < size; ++j) {
            Element child = (Element)children.get(j);
            if (!elementBeforeTaglib.contains(child.getTagName())) {
                newChildren.addAll(PortletWebAppUpdater.genTaglibElements(doc));
                addTaglibParam = true;
                break;
            }
            newChildren.add(child);
        }
        if (!addTaglibParam) {
            newChildren.addAll(PortletWebAppUpdater.genTaglibElements(doc));
        }
        for (i = j; i < size; ++i) {
            newChildren.add(children.get(i));
        }
        Iterator<Node> it = WebXMLDocumentHelper.getElementList(root).iterator();
        ArrayList<Element> list = new ArrayList<Element>();
        while (it.hasNext()) {
            list.add((Element)it.next());
        }
        for (int count = 0; count < list.size(); ++count) {
            root.removeChild((Node)list.get(count));
        }
        WebXMLDocumentHelper.addContent(root, newChildren);
    }

    private static void addElementsAsPer2_4Schema(Element root, Document doc, Properties configProps) throws DOMException {
        Element child;
        List<Node> children = WebXMLDocumentHelper.getElementList(root);
        int size = children.size();
        int newSize = size + contextParams.size() + 30;
        ArrayList<Element> newChildren = new ArrayList<Element>(newSize);
        int i = 0;
        boolean addTaglibParam = false;
        for (i = 0; i < size; ++i) {
            child = (Element)children.get(i);
            if (child.getTagName().equals(JSP_CONFIG)) {
                Element newChild = (Element)child.cloneNode(true);
                WebXMLDocumentHelper.insertContent(newChild, PortletWebAppUpdater.genTaglibElements(doc));
                newChildren.add(newChild);
                addTaglibParam = true;
                continue;
            }
            newChildren.add(child);
        }
        newChildren.addAll(PortletWebAppUpdater.genContextParamElements(doc, configProps));
        newChildren.addAll(PortletWebAppUpdater.genFilterElements(doc, configProps));
        newChildren.addAll(PortletWebAppUpdater.genFilterMappingElements(doc));
        newChildren.addAll(PortletWebAppUpdater.genServletElements(doc, configProps));
        newChildren.addAll(PortletWebAppUpdater.genServletMappingElements(doc));
        if (!addTaglibParam) {
            child = doc.createElement(JSP_CONFIG);
            WebXMLDocumentHelper.addContent(child, PortletWebAppUpdater.genTaglibElements(doc));
            newChildren.add(child);
        }
        Iterator<Node> it = WebXMLDocumentHelper.getElementList(root).iterator();
        ArrayList<Element> list = new ArrayList<Element>();
        while (it.hasNext()) {
            list.add((Element)it.next());
        }
        for (int count = 0; count < list.size(); ++count) {
            root.removeChild((Node)list.get(count));
        }
        WebXMLDocumentHelper.addContent(root, newChildren);
    }

    private static List genContextParamElements(Document doc, Properties configProps) {
        List allContextParams = PortletWebAppUpdater.createVendorPortletXMLParams(configProps);
        allContextParams.addAll(0, contextParams);
        ArrayList<Element> contextParamElements = new ArrayList<Element>(allContextParams.size());
        Comment comment = doc.createComment(contextParamComment);
        for (int i = 0; i < allContextParams.size(); ++i) {
            Element contextParam = doc.createElement(CONTEXT_PARAM);
            Element paramName = doc.createElement(PARAM_NAME);
            WebXMLDocumentHelper.addContent(paramName, doc, (String)allContextParams.get(i));
            Element paramValue = doc.createElement(PARAM_VALUE);
            WebXMLDocumentHelper.addContent(paramValue, doc, configProps.getProperty((String)allContextParams.get(i)));
            WebXMLDocumentHelper.addContent(contextParam, paramName);
            WebXMLDocumentHelper.addContent(contextParam, paramValue);
            if (i == 0) {
                paramName.getParentNode().insertBefore(comment, paramName);
            }
            contextParamElements.add(contextParam);
        }
        return contextParamElements;
    }

    private static List createVendorPortletXMLParams(Properties configProps) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (configProps != null) {
            Enumeration<?> e = configProps.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith(VENDOR_PORTLET_XML_PREFIX)) continue;
                parameters.add(key);
            }
        }
        return parameters;
    }

    private static List genServletElements(Document doc, Properties configProps) {
        ArrayList<Element> servletElements = new ArrayList<Element>();
        Comment comment = doc.createComment(servletComment);
        Element servletElement = doc.createElement(SERVLET);
        Element servletNameElement = doc.createElement(SERVLET_NAME);
        WebXMLDocumentHelper.addContent(servletNameElement, doc, PAE_SERVLET_NAME);
        Element servletClassElement = doc.createElement(SERVLET_CLASS);
        WebXMLDocumentHelper.addContent(servletClassElement, doc, SERVLET_CLASS_NAME);
        String value = configProps.getProperty(LOAD_ON_STARTUP_PROPERTY);
        boolean loadOnStartup = true;
        Element loadOnStartupElement = null;
        if ("false".equalsIgnoreCase(value)) {
            loadOnStartup = false;
        }
        if (loadOnStartup) {
            loadOnStartupElement = doc.createElement(LOAD_ON_STARTUP);
            WebXMLDocumentHelper.addContent(loadOnStartupElement, doc, "1");
        }
        WebXMLDocumentHelper.addContent(servletElement, servletNameElement);
        WebXMLDocumentHelper.addContent(servletElement, servletClassElement);
        if (loadOnStartup && loadOnStartupElement != null) {
            WebXMLDocumentHelper.addContent(servletElement, loadOnStartupElement);
        }
        servletNameElement.getParentNode().insertBefore(comment, servletNameElement);
        servletElements.add(servletElement);
        return servletElements;
    }

    private static List genServletMappingElements(Document doc) {
        ArrayList<Element> servletMappingElements = new ArrayList<Element>();
        Comment comment = doc.createComment(servletMappingComment);
        Element servletMappingElement = doc.createElement(SERVLET_MAPPING);
        Element servletNameElement = doc.createElement(SERVLET_NAME);
        WebXMLDocumentHelper.addContent(servletNameElement, doc, PAE_SERVLET_NAME);
        Element urlPatternElement = doc.createElement(URL_PATTERN);
        WebXMLDocumentHelper.addContent(urlPatternElement, doc, PAE_SERVLET_MAPPING);
        WebXMLDocumentHelper.addContent(servletMappingElement, servletNameElement);
        WebXMLDocumentHelper.addContent(servletMappingElement, urlPatternElement);
        servletNameElement.getParentNode().insertBefore(comment, servletNameElement);
        servletMappingElements.add(servletMappingElement);
        return servletMappingElements;
    }

    private static List genFilterElements(Document doc, Properties configProps) {
        ArrayList<Element> filterElements = new ArrayList<Element>();
        Comment comment = doc.createComment(filterComment);
        Element filterElement = doc.createElement(FILTER);
        Element filterNameElement = doc.createElement(FILTER_NAME);
        WebXMLDocumentHelper.addContent(filterNameElement, doc, PAE_FILTER_NAME);
        Element filterClassElement = doc.createElement(FILTER_CLASS);
        WebXMLDocumentHelper.addContent(filterClassElement, doc, FILTER_CLASS_NAME);
        WebXMLDocumentHelper.addContent(filterElement, filterNameElement);
        WebXMLDocumentHelper.addContent(filterElement, filterClassElement);
        filterNameElement.getParentNode().insertBefore(comment, filterNameElement);
        filterElements.add(filterElement);
        return filterElements;
    }

    private static List genFilterMappingElements(Document doc) {
        ArrayList<Element> filterMappingElements = new ArrayList<Element>();
        Comment comment = doc.createComment(filterMappingComment);
        Element filterMappingElement = doc.createElement(FILTER_MAPPING);
        Element filterNameElement = doc.createElement(FILTER_NAME);
        WebXMLDocumentHelper.addContent(filterNameElement, doc, PAE_FILTER_NAME);
        Element servletNameElement = doc.createElement(SERVLET_NAME);
        WebXMLDocumentHelper.addContent(servletNameElement, doc, PAE_SERVLET_NAME);
        Element dispatcherNameElement = null;
        if (doc.getDoctype() == null) {
            dispatcherNameElement = doc.createElement(DISPATCHER_NAME);
            WebXMLDocumentHelper.addContent(dispatcherNameElement, doc, DISPATCHER_TYPE);
        }
        WebXMLDocumentHelper.addContent(filterMappingElement, filterNameElement);
        WebXMLDocumentHelper.addContent(filterMappingElement, servletNameElement);
        if (dispatcherNameElement != null) {
            WebXMLDocumentHelper.addContent(filterMappingElement, dispatcherNameElement);
        }
        filterNameElement.getParentNode().insertBefore(comment, filterNameElement);
        filterMappingElements.add(filterMappingElement);
        return filterMappingElements;
    }

    private static List genTaglibElements(Document doc) {
        ArrayList<Element> taglibElements = new ArrayList<Element>();
        taglibElements.add(PortletWebAppUpdater.getTabLibElement(doc, taglibComment_1, taglibURI_1, taglibLocation_1));
        taglibElements.add(PortletWebAppUpdater.getTabLibElement(doc, taglibComment_2, taglibURI_2, taglibLocation_2));
        return taglibElements;
    }

    private static Element getTabLibElement(Document doc, String comment, String uri, String location) {
        Comment commentElement = doc.createComment(comment);
        Element taglibElement = doc.createElement(TAGLIB);
        Element taglibURIElement = doc.createElement(TAGLIB_URI);
        WebXMLDocumentHelper.addContent(taglibURIElement, doc, uri);
        Element taglibLocationElement = doc.createElement(TAGLIB_LOCATION);
        WebXMLDocumentHelper.addContent(taglibLocationElement, doc, location);
        WebXMLDocumentHelper.addContent(taglibElement, taglibURIElement);
        WebXMLDocumentHelper.addContent(taglibElement, taglibLocationElement);
        taglibURIElement.getParentNode().insertBefore(commentElement, taglibURIElement);
        return taglibElement;
    }

    private static void removeElements(Element root, Document doc, Properties configProps) throws PortletWarUpdaterException {
        List<Node> children = WebXMLDocumentHelper.getElementList(root);
        ArrayList<Element> newchildren = new ArrayList<Element>();
        Iterator<Node> itr = children.iterator();
        boolean addTagLib = false;
        while (itr.hasNext()) {
            String param;
            Element child = (Element)itr.next();
            if (child.getTagName().equals(CONTEXT_PARAM)) {
                param = WebXMLDocumentHelper.getChildTextTrim(child, PARAM_NAME);
                if (contextParams.contains(param) || configProps.containsKey(param)) continue;
                newchildren.add(child);
                continue;
            }
            if (child.getTagName().equals(SERVLET)) {
                param = WebXMLDocumentHelper.getChildTextTrim(child, SERVLET_NAME);
                if (PAE_SERVLET_NAME.equals(param)) continue;
                newchildren.add(child);
                continue;
            }
            if (child.getTagName().equals(SERVLET_MAPPING)) {
                param = WebXMLDocumentHelper.getChildTextTrim(child, SERVLET_NAME);
                if (PAE_SERVLET_NAME.equals(param)) continue;
                newchildren.add(child);
                continue;
            }
            if (child.getTagName().equals(FILTER)) {
                param = WebXMLDocumentHelper.getChildTextTrim(child, FILTER_NAME);
                if (PAE_FILTER_NAME.equals(param)) continue;
                newchildren.add(child);
                continue;
            }
            if (child.getTagName().equals(FILTER_MAPPING)) {
                param = WebXMLDocumentHelper.getChildTextTrim(child, FILTER_NAME);
                if (PAE_FILTER_NAME.equals(param)) continue;
                newchildren.add(child);
                continue;
            }
            if (child.getTagName().equals(JSP_CONFIG)) {
                List taglibs = WebXMLDocumentHelper.getChildElements(child, TAGLIB);
                for (Element taglib : taglibs) {
                    String param2 = WebXMLDocumentHelper.getChildTextTrim(taglib, TAGLIB_LOCATION);
                    if (!taglibLocation_1.equals(param2) && !taglibLocation_2.equals(param2)) continue;
                    child.removeChild(taglib);
                    addTagLib = true;
                }
                if (!addTagLib) continue;
                newchildren.add(child);
                continue;
            }
            newchildren.add(child);
        }
        List<Node> nodes = WebXMLDocumentHelper.getElementList(root);
        for (Node node : nodes) {
            root.removeChild(node);
        }
        PortletWebAppUpdater.removeAll(doc, (short)8, null);
        PortletWebAppUpdater.removeAll(doc, (short)3, LINE_BREAK);
        WebXMLDocumentHelper.addContent(root, newchildren);
    }

    private static String getWebAppVersion(Element root) throws PortletWarUpdaterException {
        String versionValue = null;
        NamedNodeMap attrs = root.getAttributes();
        int numAttrs = attrs.getLength();
        for (int i = 0; i < numAttrs; ++i) {
            Attr attr = (Attr)attrs.item(i);
            String attrName = attr.getNodeName();
            if (!attrName.equals(WEB_APP_VERSION)) continue;
            versionValue = root.getAttribute(WEB_APP_VERSION);
            if (versionValue != null && !(Float.parseFloat(versionValue) < Float.parseFloat(WEB_APP_2_4))) break;
            throw new PortletWarUpdaterException("errorGettingVersionValue");
        }
        return versionValue;
    }

    protected static void removeAll(Node node, short nodeType, String name) {
        block3: {
            block1: {
                block2: {
                    if (node.getNodeType() != nodeType) break block1;
                    if (name != null && !node.getNodeName().equals(name)) break block2;
                    node.getParentNode().removeChild(node);
                    break block3;
                }
                if (!LINE_BREAK.equals(name)) break block3;
                node.getParentNode().removeChild(node);
                break block3;
            }
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                PortletWebAppUpdater.removeAll(list.item(i), nodeType, name);
            }
        }
    }

    public static void main(String[] args) {
        try {
            String webXML = args[0];
            File webXMLFile = new File(webXML);
            FileInputStream webXMLStream = new FileInputStream(webXMLFile);
            InputStream configPropsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("PortletDeployConfig.properties");
            Properties configProps = new Properties();
            configProps.load(configPropsStream);
            File newWebXMLFile = PortletWebAppUpdater.addWebAppParam(webXMLStream, configProps, "test");
            File tmpFile = new File("/tmp/webnew.xml");
            PortletWarUpdaterUtil.copyFile(newWebXMLFile, tmpFile, true, false);
            System.out.println("File:" + newWebXMLFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        contextParams.add("request_response_factory.minSizeParam");
        contextParams.add("request_response_factory.maxSizeParam");
        contextParams.add("request_response_factory.partitionParam");
        elementBeforeContextParam = new ArrayList();
        elementBeforeFilter = new ArrayList();
        elementBeforeFilterMapping = new ArrayList();
        elementBeforeListener = new ArrayList();
        elementBeforeTaglib = new ArrayList();
        elementBeforeServletMapping = new ArrayList();
        elementBeforeContextParam.add("icon");
        elementBeforeContextParam.add("display-name");
        elementBeforeContextParam.add("description");
        elementBeforeContextParam.add("distributable");
        elementBeforeContextParam.add(CONTEXT_PARAM);
        elementBeforeFilter.add(FILTER);
        elementBeforeFilterMapping.add(FILTER_MAPPING);
        elementBeforeListener.add(LISTENER);
        elementBeforeServletMapping.add(SERVLET);
        elementBeforeTaglib.add(SERVLET_MAPPING);
        elementBeforeTaglib.add("session-config");
        elementBeforeTaglib.add("mime-mapping");
        elementBeforeTaglib.add("welcome-file-list");
        elementBeforeTaglib.add("error-page");
    }
}

