/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.warupdater;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortletWarUpdaterUtil {
    private static Logger logger = PortletWarUpdaterUtil.getLogger(PortletWarUpdaterUtil.class, "PWULogMessages");
    private static String DEBUG_NAME = "debug";

    public static void copyFile(String sourceFile, String destFile) throws IOException {
        PortletWarUpdaterUtil.copyFile(new File(sourceFile), new File(destFile), false, true);
    }

    public static void copyFile(File sourceFile, File destFile, boolean overwrite, boolean preserveLastModified) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "PSPL_CSPPCWU0007", new String[]{sourceFile.getAbsolutePath(), destFile.getAbsolutePath()});
        }
        if (overwrite || !destFile.exists() || destFile.lastModified() < sourceFile.lastModified()) {
            File parent;
            if (destFile.exists() && destFile.isFile()) {
                destFile.delete();
            }
            if (!(parent = new File(destFile.getParent())).exists()) {
                parent.mkdirs();
            }
            FileInputStream in = new FileInputStream(sourceFile);
            FileOutputStream out = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                out.write(buffer, 0, count);
            } while ((count = in.read(buffer, 0, buffer.length)) != -1);
            in.close();
            out.close();
            if (preserveLastModified) {
                destFile.setLastModified(sourceFile.lastModified());
            }
        }
    }

    public static void copyFile(InputStream sourceInputStream, File destFile) throws IOException {
        File parent;
        if (destFile.exists() && destFile.isFile()) {
            destFile.delete();
        }
        if (!(parent = new File(destFile.getParent())).exists()) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(destFile);
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            out.write(buffer, 0, count);
        } while ((count = sourceInputStream.read(buffer, 0, buffer.length)) != -1);
        sourceInputStream.close();
        out.close();
    }

    public static boolean makeDir(String dirName) {
        File dir = new File(dirName);
        if (dir.exists()) {
            return true;
        }
        return dir.mkdirs();
    }

    public static String getWarName(String warFile) {
        int index = warFile.lastIndexOf(File.separator);
        if (index == -1 && (index = warFile.lastIndexOf("\\")) == -1) {
            index = warFile.lastIndexOf("/");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "PSPL_CSPPCWU0010", new String[]{warFile, File.separator, String.valueOf(index)});
        }
        String warNameOnly = index != -1 ? warFile.substring(index + 1) : warFile;
        logger.log(Level.FINER, "PSPL_CSPPCWU0002", warNameOnly);
        return warNameOnly;
    }

    public static String getFileSuffix(String fileName) {
        String ext = "";
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            ext = fileName.substring(index);
        }
        return ext;
    }

    public static Logger getLogger(Class cls, String logMessages) {
        return Logger.getLogger(PortletWarUpdaterUtil.getName(cls), logMessages);
    }

    private static String getName(Class cls) {
        Package pkg = cls.getPackage();
        String packageName = pkg == null ? "com.sun.portal.portletcontainer.warupdater" : pkg.getName();
        StringBuffer csuffix = new StringBuffer();
        csuffix.append(DEBUG_NAME);
        csuffix.append(".");
        csuffix.append(packageName);
        return csuffix.toString();
    }

    public static void main(String[] args) {
        System.out.println("Suffix for abc.zyz is " + PortletWarUpdaterUtil.getFileSuffix("abc.xyz"));
        System.out.println("Suffix for 123 is " + PortletWarUpdaterUtil.getFileSuffix("123"));
    }
}

