/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.portlet.impl;

import com.sun.portal.container.ContainerLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDRequestWrapper
extends HttpServletRequestWrapper {
    private static Logger logger = ContainerLogger.getLogger(RDRequestWrapper.class, (String)"PAELogMessages");
    private static final String FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    private static final String FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    private static final String FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    private static final String FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    private static final String FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    private ServletContext servletContext;
    private HttpServletRequest request;
    private PortletRequest portletRequest;
    private boolean isInclude;
    private boolean isNamed;
    private boolean isParamMapInitialized;
    private Map<String, String[]> paramMap;
    private String requestURI;
    private String servletPath;
    private String pathInfo;
    private String queryString;
    private String lifecyclePhase;
    private static final String[] NULL_ARRAY = new String[0];

    public RDRequestWrapper(ServletContext servletContext, HttpServletRequest request, PortletRequest portletRequest, String requestURI, String servletPath, String pathInfo, String queryString, String lifecyclePhase, boolean isInclude, boolean isNamed) {
        super(request);
        this.servletContext = servletContext;
        this.request = request;
        this.portletRequest = portletRequest;
        this.requestURI = requestURI;
        this.requestURI = requestURI;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.lifecyclePhase = lifecyclePhase;
        this.isInclude = isInclude;
        this.isNamed = isNamed;
        this.initializeParamMap();
    }

    public String getParameter(String name) {
        String[] value;
        String retVal = null;
        if (this.paramMap != null && (value = this.paramMap.get(name)) != null) {
            retVal = value[0];
        }
        if (retVal == null) {
            retVal = super.getParameter(name);
        }
        return retVal;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.paramMap.keySet());
    }

    public String[] getParameterValues(String name) {
        String[] retVal = null;
        if (this.paramMap != null) {
            retVal = this.paramMap.get(name);
        }
        return retVal;
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.paramMap);
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        String pathTranslated = this.getPathInfo();
        if (pathTranslated == null || this.servletContext == null) {
            return null;
        }
        return this.servletContext.getRealPath(pathTranslated);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getScheme() {
        return this.portletRequest.getScheme();
    }

    public String getServerName() {
        return this.portletRequest.getServerName();
    }

    public int getServerPort() {
        return this.portletRequest.getServerPort();
    }

    public Object getAttribute(String name) {
        if (this.isInclude || name == null) {
            return this.portletRequest.getAttribute(name);
        }
        if (FORWARD_REQUEST_URI.equals(name)) {
            if (this.isNamed) {
                return null;
            }
            return this.requestURI;
        }
        if (FORWARD_SERVLET_PATH.equals(name)) {
            if (this.isNamed) {
                return null;
            }
            return this.servletPath;
        }
        if (FORWARD_PATH_INFO.equals(name)) {
            if (this.isNamed) {
                return null;
            }
            return this.pathInfo;
        }
        if (FORWARD_QUERY_STRING.equals(name)) {
            if (this.isNamed) {
                return null;
            }
            return this.queryString;
        }
        if (FORWARD_CONTEXT_PATH.equals(name)) {
            if (this.isNamed) {
                return null;
            }
            return this.portletRequest.getContextPath();
        }
        return this.portletRequest.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.portletRequest.getAttributeNames();
    }

    public void setAttribute(String name, Object value) {
        this.portletRequest.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.portletRequest.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.portletRequest.getLocale();
    }

    public Enumeration getLocales() {
        return this.portletRequest.getLocales();
    }

    public boolean isSecure() {
        return this.portletRequest.isSecure();
    }

    public String getAuthType() {
        return this.portletRequest.getAuthType();
    }

    public String getContextPath() {
        return this.portletRequest.getContextPath();
    }

    public String getRemoteUser() {
        return this.portletRequest.getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this.portletRequest.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.portletRequest.getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.portletRequest.isRequestedSessionIdValid();
    }

    public String getHeader(String name) {
        return this.portletRequest.getProperty(name);
    }

    public Enumeration getHeaders(String name) {
        return this.portletRequest.getProperties(name);
    }

    public Enumeration getHeaderNames() {
        return this.portletRequest.getPropertyNames();
    }

    public Cookie[] getCookies() {
        return this.portletRequest.getCookies();
    }

    public long getDateHeader(String name) {
        long date;
        block2: {
            String value = this.portletRequest.getProperty(name);
            date = 0L;
            try {
                date = Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                if (!logger.isLoggable(Level.INFO)) break block2;
                logger.log(Level.INFO, "PSPL_PAECSPPI0033", new String[]{name, value});
            }
        }
        return date;
    }

    public int getIntHeader(String name) {
        int intValue;
        block2: {
            String value = this.portletRequest.getProperty(name);
            intValue = 0;
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                if (!logger.isLoggable(Level.INFO)) break block2;
                logger.log(Level.INFO, "PSPL_PAECSPPI0034", new String[]{name, value});
            }
        }
        return intValue;
    }

    public String getCharacterEncoding() {
        if (this.lifecyclePhase.equals("ACTION_PHASE") || this.lifecyclePhase.equals("RESOURCE_PHASE")) {
            return ((ClientDataRequest)this.portletRequest).getCharacterEncoding();
        }
        return null;
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.lifecyclePhase.equals("ACTION_PHASE") || this.lifecyclePhase.equals("RESOURCE_PHASE")) {
            ((ClientDataRequest)this.portletRequest).setCharacterEncoding(enc);
        }
    }

    public String getContentType() {
        if (this.lifecyclePhase.equals("ACTION_PHASE") || this.lifecyclePhase.equals("RESOURCE_PHASE")) {
            return ((ClientDataRequest)this.portletRequest).getContentType();
        }
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.lifecyclePhase.equals("ACTION_PHASE") || this.lifecyclePhase.equals("RESOURCE_PHASE")) {
            return (ServletInputStream)((ClientDataRequest)this.portletRequest).getPortletInputStream();
        }
        return null;
    }

    public int getContentLength() {
        if (this.lifecyclePhase.equals("ACTION_PHASE") || this.lifecyclePhase.equals("RESOURCE_PHASE")) {
            return ((ClientDataRequest)this.portletRequest).getContentLength();
        }
        return 0;
    }

    public String getMethod() {
        if (this.lifecyclePhase.equals("RENDER_PHASE")) {
            return "GET";
        }
        return this.request.getMethod();
    }

    public BufferedReader getReader() throws IOException {
        if (this.lifecyclePhase.equals("ACTION_PHASE") || this.lifecyclePhase.equals("RESOURCE_PHASE")) {
            return ((ClientDataRequest)this.portletRequest).getReader();
        }
        return null;
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    private void initializeParamMap() {
        if (!this.isParamMapInitialized) {
            String queryStringLocal = this.getQueryString();
            if (queryStringLocal != null) {
                this.paramMap = new HashMap<String, String[]>();
                String decodedQueryString = null;
                try {
                    decodedQueryString = URLDecoder.decode(queryStringLocal, "UTF-8");
                }
                catch (UnsupportedEncodingException usee) {
                    decodedQueryString = queryStringLocal;
                }
                StringTokenizer queryStringTokens = new StringTokenizer(decodedQueryString, "&", false);
                String[] values = new String[1];
                while (queryStringTokens.hasMoreTokens()) {
                    StringTokenizer equalTokens = new StringTokenizer(queryStringTokens.nextToken(), "=");
                    if (equalTokens.countTokens() != 2) continue;
                    String key = equalTokens.nextToken();
                    values[0] = equalTokens.nextToken();
                    this.addParamToMap(this.paramMap, key, values);
                }
                for (Map.Entry entry : this.portletRequest.getParameterMap().entrySet()) {
                    String key = (String)entry.getKey();
                    String[] value = (String[])entry.getValue();
                    if (this.paramMap.containsKey(key)) {
                        this.addParamToMap(this.paramMap, key, value);
                        continue;
                    }
                    this.paramMap.put(key, value);
                }
            } else {
                this.paramMap = new HashMap<String, String[]>(this.portletRequest.getParameterMap());
            }
            this.isParamMapInitialized = true;
        }
    }

    private void addParamToMap(Map<String, String[]> map, String key, String[] values) {
        String[] newValues = null;
        String[] origValues = map.get(key);
        if (origValues == null) {
            origValues = NULL_ARRAY;
        }
        newValues = new String[origValues.length + values.length];
        System.arraycopy(origValues, 0, newValues, 0, origValues.length);
        System.arraycopy(values, 0, newValues, origValues.length, values.length);
        map.put(key, newValues);
    }
}

