/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common.descriptor;

import com.sun.portal.container.service.EventHolder;
import com.sun.portal.portletcontainer.common.descriptor.PortletXMLDocumentHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDescriptor {
    private String id;
    private EventHolder eventHolder;

    public void load(Element eventDefinitionElement, String namespaceURI, String defaultNameSpace) {
        String name;
        Map<String, String> descriptionMap = PortletXMLDocumentHelper.getDescriptionMap(eventDefinitionElement);
        QName qname = PortletXMLDocumentHelper.generateQName(PortletXMLDocumentHelper.getChildElement(eventDefinitionElement, "qname"), defaultNameSpace);
        if (qname == null && (name = PortletXMLDocumentHelper.getChildTextTrim(eventDefinitionElement, "name")) != null) {
            qname = new QName(defaultNameSpace, name);
        }
        ArrayList<QName> aliases = null;
        NodeList aliasElements = eventDefinitionElement.getElementsByTagName("alias");
        if (aliasElements.getLength() > 0) {
            aliases = new ArrayList<QName>(aliasElements.getLength());
            for (int i = 0; i < aliasElements.getLength(); ++i) {
                Element alias = (Element)aliasElements.item(i);
                aliases.add(PortletXMLDocumentHelper.generateQName(alias, defaultNameSpace));
            }
        }
        String valueType = PortletXMLDocumentHelper.getChildTextTrim(eventDefinitionElement, "value-type");
        this.eventHolder = new EventHolder(descriptionMap, qname, aliases, valueType);
    }

    public EventHolder getEventHolder() {
        return this.eventHolder;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getDescriptions() {
        return new ArrayList<String>(this.getDescriptionMap().values());
    }

    public String getDescription() {
        return PortletXMLDocumentHelper.getDescription(this.getDescriptionMap());
    }

    public String getDescription(String lang) {
        return this.getDescriptionMap().get(lang);
    }

    public Map<String, String> getDescriptionMap() {
        return this.eventHolder.getDescriptionMap();
    }

    public String getValueType() {
        return this.eventHolder.getValueType();
    }

    public QName getQName() {
        return this.eventHolder.getQName();
    }

    public List<QName> getAliases() {
        return this.eventHolder.getAliases();
    }
}

